/*
** Copyright (c) Massachusetts Institute of Technology 1994-1997.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@larch.lcs.mit.edu).
*/
/*
** lltok.h
*/

# ifndef LLTOK_H
# define LLTOK_H

typedef struct _lltok
{
  int tok;
  fileloc loc;
} lltok;

extern lltok lltok_create  (int p_tok, /*@only@*/ fileloc p_loc) /*@modifies nothing@*/ ;
extern /*@observer@*/ cstring lltok_unparse (lltok p_tok) /*@*/ ;

extern void lltok_release (/*@special@*/ lltok p_t) /*@releases p_t.loc@*/ ;

extern /*@dependent@*/ /*@exposed@*/ fileloc lltok_getLoc (lltok p_t) /*@*/ ;
extern int lltok_getTok (lltok p_t) /*@*/ ;

# define lltok_getTok(t)  ((t).tok)
# define lltok_getLoc(t)  ((t).loc)

extern bool lltok_isSemi (lltok p_tok);

# else
# error "Multiple include"
# endif
