/*
** Copyright (c) Massachusetts Institute of Technology 1994-1997.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@larch.lcs.mit.edu).
*/

# include "lclintMacros.nf"
# include "basic.h"

fileloc g_currentloc;
symtable g_symtab;

cstring g_codeFile = cstring_undefined;
int g_codeLine = 0;

cstring g_prevCodeFile = cstring_undefined;
int g_prevCodeLine = 0;
FILE *g_msgstream;

/*
** These were in llmain.c.  Most should not be globals...
*/

/*@only@*/ cstring g_localIncludePath = cstring_undefined;
/*@only@*/ cstring g_includePath = cstring_undefined;
/*@observer@*/ char *g_localSpecPath = ".";
/*@only@*/ cstring g_currentSpec;
/*@only@*/ char *g_currentSpecName;
/*@only@*/ lsymbolSet g_currentImports = lsymbolSet_undefined;

void printCodePoint (void)
{
  if (cstring_isDefined (g_codeFile))
    {
      fprintf (g_msgstream, "*** Last code point: %s:%d\n", 
	       cstring_toCharsSafe (g_codeFile), g_codeLine);
      
      if (cstring_isDefined (g_prevCodeFile))
	{
	  fprintf (g_msgstream, "*** Previous code point: %s:%d\n", 
		   cstring_toCharsSafe (g_prevCodeFile), g_prevCodeLine);
	}
    }
}




