/*
** Copyright (c) Massachusetts Institute of Technology 1994-1997.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@larch.lcs.mit.edu).
*/
/*
** letDeclNodeList.c
**
** based on list_template.c
**
** where T has T_equal (or change this) and T_unparse
*/

# include "lclintMacros.nf"
# include "llbasic.h"

/*@only@*/ letDeclNodeList
letDeclNodeList_new ()
{
  letDeclNodeList s = (letDeclNodeList) dmalloc (sizeof (*s));
  
  s->nelements = 0;
  s->nspace = letDeclNodeListBASESIZE;
  s->elements = (letDeclNode *)
    dmalloc (sizeof (*s->elements) * letDeclNodeListBASESIZE);

  return (s);
}

static void
letDeclNodeList_grow (letDeclNodeList s)
{
  int i;
  letDeclNode *newelements;

  s->nspace += letDeclNodeListBASESIZE;

  newelements = (letDeclNode *) dmalloc (sizeof (*newelements)
					 * (s->nelements + s->nspace));

  for (i = 0; i < s->nelements; i++)
    {
      newelements[i] = s->elements[i];
    }

  sfree (s->elements); 
  s->elements = newelements;
}

letDeclNodeList
letDeclNodeList_add (letDeclNodeList s, letDeclNode el)
{
  llassert (letDeclNodeListBASESIZE > 0);

  if (s->nspace <= 0)
    letDeclNodeList_grow (s);

  s->nspace--;
  s->elements[s->nelements] = el;
  s->nelements++;

  return s;
}

/*@only@*/ cstring
letDeclNodeList_unparse (letDeclNodeList s)
{
  cstring st = cstring_undefined;

  letDeclNodeList_elements (s, current)
  {
    st = message ("%qlet %s", st, ltoken_getRawString (current->varid));

    if (current->sortspec != NULL)
      {
	st = message ("%q: %q", st, lclTypeSpecNode_unparse (current->sortspec));
      }
    else
      {
	st = message ("%q ", st);
      }
    st = message ("%q = %q\n", st, termNode_unparse (current->term));
  } end_letDeclNodeList_elements;

  return st;
}

void
letDeclNodeList_free (letDeclNodeList s)
{
  int i;
  for (i = 0; i < s->nelements; i++)
    {
      letDeclNode_free (s->elements[i]); 
    }

  sfree (s->elements);
  sfree (s);
}
