/*
** Copyright (c) Massachusetts Institute of Technology 1994-1997.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@larch.lcs.mit.edu).
*/
/*
** replaceNodeList.c
**
** based on list_template.c
**
** where T has T_equal (or change this) and T_unparse
*/

# include "lclintMacros.nf"
# include "llbasic.h"

/*@only@*/ replaceNodeList
replaceNodeList_new ()
{
  replaceNodeList s = (replaceNodeList) dmalloc (sizeof (*s));

  s->nelements = 0;
  s->nspace = replaceNodeListBASESIZE;
  s->elements = (replaceNode *)
    dmalloc (sizeof (*s->elements) * replaceNodeListBASESIZE);

  return (s);
}

static void
replaceNodeList_grow (replaceNodeList s)
{
  int i;
  replaceNode *newelements; 

  s->nspace += replaceNodeListBASESIZE;

  newelements = (replaceNode *) dmalloc (sizeof (*newelements)
					 * (s->nelements + s->nspace));

  for (i = 0; i < s->nelements; i++)
    {
      newelements[i] = s->elements[i];
    }

  sfree (s->elements); 
  s->elements  = newelements;
}

replaceNodeList
  replaceNodeList_add (replaceNodeList s, replaceNode el)
{
  if (s->nspace <= 0)
    replaceNodeList_grow (s);

  s->nspace--;
  s->elements[s->nelements] = el;
  s->nelements++;

  return s;
}

/*@only@*/ cstring
replaceNodeList_unparse (replaceNodeList s)
{
  bool first = TRUE;
  cstring st = cstring_undefined;

  replaceNodeList_elements (s, current)
  {
    if (first)
      {
	st = replaceNode_unparse (current);
	first = FALSE;
      }
    else
      {
	st = message ("%q, %q", st, replaceNode_unparse (current));
      }
  } end_replaceNodeList_elements;

  return st;
}

void
replaceNodeList_free (replaceNodeList s)
{
  int i;
  for (i = 0; i < s->nelements; i++)
    {
      replaceNode_free (s->elements[i]); 
    }

  sfree (s->elements); 
  sfree (s);
}
