/*
** Copyright (c) Massachusetts Institute of Technology 1994-1997.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@larch.lcs.mit.edu).
*/
/*
** sortList.c
**
** based on list_template.c
**
** where T has T_equal (or change this) and T_unparse
*/

# include "lclintMacros.nf"
# include "llbasic.h"

/*@only@*/ sortList
sortList_new ()
{
  sortList s = (sortList) dmalloc (sizeof (*s));
  
  s->nelements = 0;
  s->nspace = sortListBASESIZE;
  s->elements = (sort *) dmalloc (sizeof (*s->elements) * sortListBASESIZE);
  s->current = 0;

  return (s);
}

static void
sortList_grow (sortList s)
{
  int i;
  sort *newelements;

  s->nspace += sortListBASESIZE;

  newelements = (sort *) dmalloc (sizeof (*newelements) * (s->nelements + s->nspace));

  if (newelements == (sort *) 0)
    {
      llfatalerror (cstring_makeLiteral ("sortList_grow: out of memory!"));
    }

  for (i = 0; i < s->nelements; i++)
    {
      newelements[i] = s->elements[i];
    }

  sfree (s->elements);
  s->elements = newelements;
}

void 
sortList_addh (sortList s, sort el)
{
  if (s->nspace <= 0)
    sortList_grow (s);

  s->nspace--;
  s->elements[s->nelements] = el;
  s->nelements++;
}

void 
sortList_reset (sortList s)
{
  s->current = 0;
}

void 
sortList_advance (sortList s)
{
  s->current++;
  llassert (s->current < s->nelements);
}

sort 
sortList_current (sortList s)
{
  if (s->current < 0 || s->current >= s->nelements)
    {
      llbug (message ("sortList_current: current out of range: %d (size: %d)",
		      s->current, s->nelements));
    }
  return (s->elements[s->current]);
}

/*@only@*/ cstring
sortList_unparse (sortList s)
{
  int i;
  cstring st = cstring_undefined;

  for (i = 0; i < s->nelements; i++)
    {
      if (i == 0)
	{
	  st = cstring_copy (sort_unparseName (s->elements[i])); /* !!! NEED COPY HERE !!! */
	}
      else
	{
	  st = message ("%q, %s", st, sort_unparseName (s->elements[i]));
	}
    }

  return st;
}

void
sortList_free (sortList s)
{
  int i;
  for (i = 0; i < s->nelements; i++)
    {
      /*      sort_free (s->elements[i]); */
    }
  
  sfree (s->elements);		/* not quite!!! */
  sfree (s);
}
