/*
  Optimizer
  Output header file
*/

/*
 *  Copyright (C) 1997,1998  Jesper Pedersen <jews@imada.ou.dk>
 *  This code is released under GNU GPL version 2 or later
 */

#ifndef _OUTPUT_H_
#define _OUTPUT_H_

#include "Global.h"
#include "Misc.h"
#include "Holder.h"
#include "Entry.h"
#include "IdEntry.h"
#include "optimizer.tab.h"
#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <string.h>

//
//	Method name : header
//
//	Description : Generates the NASM header
//	Input : ---
//	Output : ---
//
void Holder::header(void){
  extern FILE *yyout;
  PIdEntry tmp;
  PGloblEntry gtmp;
  char *tmpstr = new char[MaxSize];

  tmp = Fidlist;
  fputs("; Optimizer v", yyout);
  fputs(VERSION, yyout);
  fputs(" generated file\n\n", yyout);
  fputs("\tBITS 32\n", yyout);
  fputs("\n", yyout);
  while (tmp != NULL) {
    fputs("\tGLOBAL ", yyout);
    fputs(tmp->getname(), yyout);
    fputs(":function", yyout);
    fputs("\n", yyout);
    tmp = tmp->next;
  }

  gtmp = Fgbllist;
  while (gtmp != NULL) {
    fputs("\tGLOBAL ", yyout);
    fputs(gtmp->getname(), yyout);
    fputs(":data (", yyout);
    fputs(gtmp->getname(), yyout);
    fputs(".end - ", yyout);
    fputs(gtmp->getname(), yyout);
    fputs(")", yyout);
    fputs("\n", yyout);
    gtmp = gtmp->next;
  }
  
  tmp = Fvarlist;
  while (tmp != NULL) {
    fputs("\tCOMMON ", yyout);
    fputs(tmp->getname(), yyout);
    fputs(" ", yyout);
    fputs(tmp->getlabel(), yyout);
    fputs(":", yyout);
    fputs(tmp->getalign(), yyout);
    fputs("\n", yyout);
    tmp = tmp->next;
  }

  tmp = Fextlist;
  while (tmp != NULL) {
    fputs("\tEXTERN ", yyout);
    fputs(tmp->getname(), yyout);
    fputs("\n", yyout);
    tmp = tmp->next;
  }

  fputs("\n\tSECTION .text progbits alloc   exec nowrite align=", yyout);
  sprintf(tmpstr,"%i",this->align);
  strcat(tmpstr,"\n\n");
  fputs(tmpstr,yyout);

  delete[] tmpstr;
}

//
//	Method name : footer
//
//	Description : Generates the NASM footer
//	Input : ---
//	Output : ---
//
void Holder::footer(void){
  extern FILE *yyout;
  PIdEntry tmp;
  char *tmpstr = new char[MaxSize];

  if (!tmpstr) alloc_error();

  tmp = Fstrlist;
  fputs("\n\tSECTION .data progbits alloc noexec   write align=4\n\n", yyout);
  while (tmp != NULL) {
    strcpy(tmpstr,tmp->getlabel());
    if (strcmp(tmpstr,"\"\"")) {
      fputs(tmp->getlabel(), yyout);
      fputs(":\tdb ", yyout);
      tmp->convert();
      fputs(tmp->getname(), yyout);
      fputs(",0\n", yyout);
    }
    tmp = tmp->next;
  }
  fputs("\n",yyout);
  this->outvars();
  /*
  fputs("\n\tSECTION .bss    nobits alloc noexec   write align=4\n\n", yyout);
  tmp = Fvarlist;
  while (tmp != NULL) {
    fputs("\t\talign ",yyout);
    fputs(tmp->getalign(),yyout);
    fputs(",db 0\n",yyout);
    fputs("$", yyout);
    strcpy(tmpstr,tmp->getname());
    fputs(tmpstr, yyout);
    if (strlen(tmpstr) > 6) {
      fputs("\tresb ", yyout);
      fputs(tmp->getlabel(), yyout);
      fputs("\n\n", yyout);
    } else {
      fputs("\t\tresb ", yyout);
      fputs(tmp->getlabel(), yyout);
      fputs("\n\n", yyout);
    }
    tmp = tmp->next;
  }
  */
  delete[] tmpstr;
}

//
//	Method name : tofile
//
//	Description : Output all entry to the output-file
//	Input : ---
//	Output : ---
//
void Holder::tofile(void){
  extern FILE *yyout;
  PEntry tmp;
  tmp = firstEntry;
  bool wrt;
  while (tmp != NULL) {
    wrt = true;
    if (tmp->getFlag() & LABEL) {
      if (strstr(tmp->getlabel(),".L") == NULL) {
	fputs("$", yyout);
      }
      fputs(tmp->getlabel(), yyout);
      fputs(":\n", yyout);
      wrt = false;
    }
    if (tmp->getFlag() & OPCODE) {
      fputs("\t", yyout);
      fputs(tmp->getopcodestr(), yyout);
    }
    if (tmp->getFlag() & DEST) {
      fputs("\t", yyout);
      fputs(tmp->getdest(), yyout);
    }
    if (tmp->getFlag() & SRC) {
      fputs(", ", yyout);
      fputs(tmp->getsrc(), yyout);
    }
    if (wrt) {
      fputs("\n", yyout);
    }
    tmp = tmp->next;
  }
}

#endif
