// Copyright (c) 1997 Philip A. Hardin (pahardin@cs.utexas.edu)
//
// You may reuse and/or modify this source code for non-profit,
// non-commercial purposes without further permission from the author,
// provided that the source code retains this copyright/permission notice.
// Use of the source code for any other purpose requires prior permission
// from the author.


#include "view.h"


/*=========================================================================*/
view& view::Copy(const view& v) {
  maxPts= numPts=		v.numPts;
  modelToView=			v.modelToView;
  shape=			v.shape;

  if (maxPts >0) {
    pts= new pt3d[maxPts];
    forii(numPts) pts[i]=v.pts[i];
  }

  return *this;
}


/*-------------------------------------------------------------------------*/
// In:  mtv= new modelToView transformation matrix
void view::Update(xregion3d *newShape, const tmtrx& newMtv) {

  // if the shape has changed and the new shape has more pts than
  // the old one, allocate an adequately large array of pts
  if (newShape != shape) {
    numPts= newShape->pts.Num();
    if (numPts >maxPts) {
      if (maxPts >0) delete [] pts;
      maxPts= numPts;
      pts= new pt3d[maxPts];
    }
  }
  
  if (newShape != shape || !modelToView.RotationSame(newMtv)) {
    newShape->TransformTo(newMtv,pts);
  }
  else {
    pt3d delta= newMtv.Cart() - modelToView.Cart();
    if (delta != pt3d(0,0,0)) {
      forii(newShape->pts.Num())
	pts[i] += delta;
    }
  }
  modelToView= newMtv;
  shape= newShape;
}
