/*
* IRIX dependent code
*/
#ifdef sgi
#define __IRIX_C_
#include "xmame.h"
#include "sound.h"

#ifndef IRIX_NOSOUND
#include <sys/stropts.h>
#include <dmedia/audio.h>
#include <errno.h>

ALport devAudio;
ALconfig devAudioConfig;
#endif
	
int sysdep_init(void) {
	long parambuf[16];

#ifndef IRIX_NOSOUND
	if (play_sound) {

	    printf("IRIX sound system initializing ...");

	    /* first of all, look for anyone using driver */
	    parambuf[0] = AL_INPUT_COUNT;
	    parambuf[2] = AL_OUTPUT_COUNT;
	    ALgetparams( AL_DEFAULT_DEVICE,parambuf,4);
	    if (parambuf[1] || parambuf[3]) {
		printf("Someone is already using the sound system.Exiting..\n");
		exit(1);
	    }

	    /* try to get a configuration descriptor */
	    if ( ( devAudioConfig=ALnewconfig() ) == (ALconfig) NULL ){
		printf ("Cannot get a config Descriptor.Exiting\n");
		exit(1);
	    }

	    /* channel-specific parameters */	
	    ALsetchannels(devAudioConfig,AL_MONO); 		/* mono */
	    ALsetqueuesize(devAudioConfig,(long)AUDIO_BUFF_SIZE); /* buffer size */
	    ALsetsampfmt(devAudioConfig,AL_SAMPFMT_TWOSCOMP);	/* linear signed */
	    ALsetwidth(devAudioConfig,AL_SAMPLE_8);   	/* 8 bits */

	    /* global audio-device parameters */
	    parambuf[0]	= AL_OUTPUT_RATE;	parambuf[1] =	audio_sample_freq;
	    parambuf[2]	= AL_INPUT_RATE;	parambuf[3] =	audio_sample_freq;
	    parambuf[4]	= AL_RIGHT_SPEAKER_GAIN;parambuf[5] =	64;
	    parambuf[6]	= AL_LEFT_SPEAKER_GAIN; parambuf[7] =	64;
	    parambuf[8]	= AL_SPEAKER_MUTE_CTL;  parambuf[9] =	AL_SPEAKER_MUTE_OFF;
	    if( ALsetparams( AL_DEFAULT_DEVICE,parambuf,10) < 0) {
		printf("Cannot Configure the sound system.Exiting...\n");
		exit(1);
	    }

	    /* try to get a Audio channel descriptor with pre-calculated params */
	    if ( ( devAudio=ALopenport("audio_fd","w",devAudioConfig) ) == (ALport) NULL ){
		printf ("Cannot get an Audio Channel Descriptor.Exiting\n");
		exit(1);
	    }

	} /* if (play_sound) */
#endif
	return TRUE;
}

void sysdep_exit(void) {
#ifndef IRIX_NOSOUND
	if(play_sound){
		ALcloseport(devAudio);
		ALfreeconfig(devAudioConfig);
	}
#endif
}	

long sysdep_get_audio_freespace() {
#ifndef IRIX_NOSOUND
	return ALgetfillable(devAudio);
#else
	return 0;
#endif
}

/* routine to dump audio samples into audio device */
int sysdep_play_audio(byte *buff, int size) {
#ifndef IRIX_NOSOUND
	byte *pt=buff;
	/* try only to send samples that no cause blocking */
        long maxsize=ALgetfillable(devAudio);
	/* new mixer code works in a unsigned char; driver is signed.... */
	for (;pt<(buff+size);pt++) *pt ^=0x80;
	return ALwritesamps(devAudio,(void *)buff,(size<=maxsize)?size:maxsize);	
#endif
}

#endif 
/****** end of IRIX dependent code; DO NOT WRITE BELOW THIS LINE *********/
