/*
 * Copyright(c) 1995,1996 by Gennady B. Sorokopud (gena@NetVision.net.il)
 *
 * This software can be freely redistributed and modified for 
 * non-commercial purposes as long as above copyright
 * message and this permission notice appear in all
 * copies of distributed source code and included as separate file
 * in binary distribution.
 *
 * Any commercial use of this software requires author's permission.
 *
 * This software is provided "as is" without expressed or implied
 * warranty of any kind.
 * Under no circumstances is the author responsible for the proper
 * functioning of this software, nor does the author assume any
 * responsibility for damages incurred with its use.
 *
 */

/* $Id: pop_smtp.c,v 2.1 1997/12/14 15:27:35 gena Exp $
 */

#include <fmail.h>
#include <umail.h>
#include <choose_folder.h>
#include "configform.h"

FD_POPacc    *pacc_obj;
static FD_config_pop *pop_obj;
static FD_config_send *smtp_obj;
static FD_config_news *nntp_obj;
static int ready = 0;

void SMTP_Host_Call(FL_OBJECT *obj, long param)
{
}

void NNTP_Call(FL_OBJECT *obj, long param)
{
}

void SPOP_Call(FL_OBJECT *obj, long param)
{
}

void POP_DMark_Call(FL_OBJECT *obj, long param)
{
if (fl_get_button(obj))
        fl_show_message("Warning!", "Every retrieved message", "will remain be marked as unretrieved");
}

void POP_2_Call(FL_OBJECT *obj, long param)
{
if (fl_get_button(obj))
        fl_show_message("Warning!", "SmartPOP features", "will not work with POP2 server");
}

void SPOP_UID_Call(FL_OBJECT *obj, long param)
{
if (fl_get_button(obj))
        fl_show_message("Warning!", "This feature works only", "on last 3000 messages retrieved");
}

void SPOP_XLST_Call(FL_OBJECT *obj, long param)
{
if (fl_get_button(obj))
        fl_show_message("Warning!", "This feature is not part of RFC", "and most POP servers does not support it");
}
void POP_Smart_Call(FL_OBJECT *obj, long param)
{
}

void SMTP_POP_Call(FL_OBJECT *obj, long param)
{
if (fl_get_button(obj))
        fl_show_message("Warning!", "This feature is supported only by few", "POP server implementations");
}

void SMTP_Port_Call(FL_OBJECT *obj, long param)
{
}

void SMTP_Bg_Call(FL_OBJECT *obj, long param)
{
if (fl_get_button(obj))
        fl_show_message("Warning!", "If background sending is enabled you will not be able", "to recover from errors occured during send process");
}

void SMTP_SMTP_Call(FL_OBJECT *obj, long param)
{
if (fl_get_button(obj))
        fl_show_message("Warning!", "XFMail will send mail directly to SMTP gateway", "Make sure that host name is correct and the gateway is accessible from your computer");
}
 
void Misc_SMail_Call(FL_OBJECT *obj, long param)
{
}

void POP_Host_Call(FL_OBJECT *obj, long param)
{
}

void POP_Port_Call(FL_OBJECT *obj, long param)
{
}

void POP_User_Call(FL_OBJECT *obj, long param)
{
}

void POP_Pwd_Call(FL_OBJECT *obj, long param)
{
}

void P_Call(FL_OBJECT *obj, long param)
{
}

void POP_Store_Pwd_Call(FL_OBJECT *obj, long param)
{
if (fl_get_button(pop_obj->POP_Store_Pwd)) {
	fl_show_alert("WARNING", "This is very unsecure option", "make sure your config file (.xfmailrc) is not readable by anyone else", 1);
	b_setcfg_flags("popasswd", 0); }
}

void NNTP_Store_Pwd_Call(FL_OBJECT *obj, long param)
{
if (fl_get_button(nntp_obj->NNTP_Store_Pwd))	{
	fl_show_alert("WARNING", "This is very unsecure option", "make sure your config file (.xfmailrc) is not readable by anyone else", 1);
	b_setcfg_flags("nntpasswd", 0);		}
}

void POP_Delete_Call(FL_OBJECT *obj, long param)
{
}

void
pop_conf(int set_default, FD_config_pop *form) 
{
 pop_obj = form;
 fl_set_input(pop_obj->POP_Host, b_getcfg_str_default(conf_name, "pophost", "127.0.0.1", set_default));
 fl_set_input(pop_obj->POP_Port, b_getcfg_str_default(conf_name, "poport", "110", set_default));
 fl_set_input(pop_obj->POP_User, b_getcfg_str_default(conf_name, "popuser", "", set_default));
 fl_set_input(pop_obj->POP_Pwd, b_getcfg_str_default(conf_name, "popasswd", "", set_default));

 fl_set_button(pop_obj->POP_Delete, b_getcfg_int_default(conf_name,"popdelete", 0, set_default));
 fl_set_button(pop_obj->POP_DMark, b_getcfg_int_default(conf_name,"popdmark", 0, set_default));
 fl_set_button(pop_obj->POP_Store_Pwd, b_getcfg_int_default(conf_name,"popstorpwd", 0, set_default));
 fl_set_button(pop_obj->POP_2, b_getcfg_int_default(conf_name,"pop2", 0, set_default));

 fl_set_input(pop_obj->SPOP_Kb, b_getcfg_str_default(conf_name, "popmaxmsg", "-1", set_default));

 switch (b_getcfg_int_default(conf_name, "popmaxact", 1, set_default)) {
   case 0:
	fl_set_button(pop_obj->SPOP_Header, 1);
   break;

   case 1:
	fl_set_button(pop_obj->SPOP_Skip, 1);
   break;

   default:
	fl_set_button(pop_obj->SPOP_Skip, 1);
   break;
						  }

 switch (b_getcfg_int_default(conf_name, "popcheckretr", 0, set_default)) {
   case 0:
	fl_set_button(pop_obj->SPOP_Status, 0);
	fl_set_button(pop_obj->SPOP_UID, 0);
   break;

   case 1:
	fl_set_button(pop_obj->SPOP_Status, 1);
	fl_set_button(pop_obj->SPOP_UID, 0);
   break;

   case 2:
	fl_set_button(pop_obj->SPOP_Status, 0);
	fl_set_button(pop_obj->SPOP_UID, 1);
   break;

   case 3:
	fl_set_button(pop_obj->SPOP_Status, 1);
	fl_set_button(pop_obj->SPOP_UID, 1);
   break;

   default:
	fl_set_button(pop_obj->SPOP_Status, 0);
	fl_set_button(pop_obj->SPOP_UID, 0);
   break;
						     }

 if (b_getcfg_int_default(conf_name, "popgetstat", 0, set_default))
	fl_set_button(pop_obj->SPOP_Stat_XLST, 1);
 else
	fl_set_button(pop_obj->SPOP_Stat_Header, 1);

 fl_set_button(pop_obj->POP_Log, (logging & LOG_POP) ? 1 : 0);     

}

void
handle_pop_input(FD_config_pop *form)
{
 pop_obj = form;
 b_putcfg_str(conf_name, "pophost", (char *)fl_get_input(pop_obj->POP_Host));
 b_putcfg_str(conf_name, "poport", (char *)fl_get_input(pop_obj->POP_Port));
 b_putcfg_str(conf_name, "popuser", (char *)fl_get_input(pop_obj->POP_User));

 b_putcfg_int(conf_name, "popdelete", fl_get_button(pop_obj->POP_Delete));
 b_putcfg_int(conf_name, "popdmark", fl_get_button(pop_obj->POP_DMark));
 b_putcfg_int(conf_name, "popstorpwd", fl_get_button(pop_obj->POP_Store_Pwd));
 b_putcfg_int(conf_name, "pop2", fl_get_button(pop_obj->POP_2));

 b_putcfg_str(conf_name, "popasswd", (char *)fl_get_input(pop_obj->POP_Pwd));

 if (fl_get_button(pop_obj->POP_Store_Pwd))
	b_setcfg_flags("popasswd", CF_UNSECURE);
 else
	b_setcfg_flags("popasswd", DONT_STORE|CF_UNSECURE);

 b_putcfg_int(conf_name, "popmaxmsg", atoi((char *)fl_get_input(pop_obj->SPOP_Kb)));

 if (fl_get_button(pop_obj->SPOP_Header))
	b_putcfg_int(conf_name, "popmaxact", 0);
 else
	b_putcfg_int(conf_name, "popmaxact", 1);

 if (fl_get_button(pop_obj->SPOP_Status) && fl_get_button(pop_obj->SPOP_UID))
	b_putcfg_int(conf_name, "popcheckretr", 3);
 else
 if (fl_get_button(pop_obj->SPOP_Status))
	b_putcfg_int(conf_name, "popcheckretr", 1);
 else
 if (fl_get_button(pop_obj->SPOP_UID))
	b_putcfg_int(conf_name, "popcheckretr", 2);
 else
	b_putcfg_int(conf_name, "popcheckretr", 0);

 if (fl_get_button(pop_obj->SPOP_Stat_Header))
	b_putcfg_int(conf_name, "popgetstat", 0);
 else
	b_putcfg_int(conf_name, "popgetstat", 1);

 if (fl_get_button(pop_obj->POP_Log))
        logging |= LOG_POP;
 else
        logging &= ~LOG_POP;

 return;         

}

void POP_Ok_Call(FL_OBJECT *obj, long param)
{
}

void
pop_account_init()
{
 pacc_obj = create_form_POPacc();
}

void
pop_account()
{

 if (ready)
        return;

 ready = 1;

 fl_set_input(pacc_obj->P_Username, b_getcfg_str(conf_name, "popuser", ""));
 fl_set_input(pacc_obj->P_Password, b_getcfg_str(conf_name, "popasswd", ""));
 fl_set_object_label(pacc_obj->P_Server, b_getcfg_str(conf_name, "pophost", "127.0.0.1"));
 fl_set_object_label(pacc_obj->P_Title, "POP account on");

 fl_set_object_focus(pacc_obj->POPacc, pacc_obj->P_Password);

 fl_show_form(pacc_obj->POPacc, FL_PLACE_CENTER, FL_TRANSIENT, "POP account");

 fl_do_only_forms();

 b_putcfg_str(conf_name,"popuser",(char *)fl_get_input(pacc_obj->P_Username));
 b_putcfg_str(conf_name,"popasswd",(char *)fl_get_input(pacc_obj->P_Password));

 fl_hide_form(pacc_obj->POPacc);

 ready = 0;
 return;         
}

void
nntp_account()
{

 if (ready)
        return;

 ready = 1;

 fl_set_input(pacc_obj->P_Username, b_getcfg_str(conf_name, "nntpuser",user_n));
 fl_set_input(pacc_obj->P_Password, b_getcfg_str(conf_name, "nntpasswd", ""));
 fl_set_object_label(pacc_obj->P_Server, b_getcfg_str(conf_name, "nntphost", "news"));
 fl_set_object_label(pacc_obj->P_Title, "NNTP authorization on");

 fl_set_object_focus(pacc_obj->POPacc, pacc_obj->P_Password);

 fl_show_form(pacc_obj->POPacc, FL_PLACE_CENTER, FL_TRANSIENT, "NEWS login");

 fl_do_only_forms();

 b_putcfg_str(conf_name,"nntpuser",(char *)fl_get_input(pacc_obj->P_Username));
 b_putcfg_str(conf_name,"nntpasswd",(char *)fl_get_input(pacc_obj->P_Password));

 fl_hide_form(pacc_obj->POPacc);

 ready = 0;
 return;         
}

void
news_conf(int set_default, FD_config_news *form) 
{

 nntp_obj = form;
 fl_set_input(nntp_obj->NNTP_Host, b_getcfg_str_default(conf_name, "nntphost", "news", set_default));
 fl_set_input(nntp_obj->NNTP_Port, b_getcfg_str_default(conf_name, "nntport", "119", set_default));
 fl_set_input(nntp_obj->NNTP_Username, b_getcfg_str_default(conf_name, "nntpuser", user_n, set_default));
 fl_set_input(nntp_obj->NNTP_Password, b_getcfg_str_default(conf_name, "nntpasswd", "", set_default));
 fl_set_button(nntp_obj->NNTP_Store_Pwd, b_getcfg_int_default(conf_name, "nntpstorpwd", 0, set_default));
 fl_set_button(nntp_obj->NNTP_Authorize, b_getcfg_int_default(conf_name, "nntpauth", 0, set_default));
 fl_set_button(nntp_obj->NNTP_Log, (logging & LOG_NNTP) ? 1 : 0);

 if (fl_get_button(nntp_obj->NNTP_Store_Pwd))
	b_setcfg_flags("nntpasswd", CF_UNSECURE);
 else
	b_setcfg_flags("nntpasswd", DONT_STORE|CF_UNSECURE);
}

void
handle_news_input(FD_config_news *form)
{
 nntp_obj = form;
 b_putcfg_str(conf_name, "nntphost", (char *)fl_get_input(nntp_obj->NNTP_Host));
 b_putcfg_str(conf_name, "nntport", (char *)fl_get_input(nntp_obj->NNTP_Port));
 b_putcfg_str(conf_name, "nntpuser", (char *)fl_get_input(nntp_obj->NNTP_Username));
 b_putcfg_str(conf_name, "nntpasswd", (char *)fl_get_input(nntp_obj->NNTP_Password));
 b_putcfg_int(conf_name, "nntpstorpwd",fl_get_button(nntp_obj->NNTP_Store_Pwd));
 b_putcfg_int(conf_name, "nntpauth", fl_get_button(nntp_obj->NNTP_Authorize));

 if (fl_get_button(nntp_obj->NNTP_Log))
        logging |= LOG_NNTP;
 else
        logging &= ~LOG_NNTP; 

 return;         
}

void
smtp_conf(int set_default, FD_config_send *form) 
{

 smtp_obj = form;
 fl_set_input(smtp_obj->SMTP_Host, b_getcfg_str_default(conf_name, "smtphost", "127.0.0.1", set_default));
 fl_set_input(smtp_obj->SMTP_Port, b_getcfg_str_default(conf_name, "smtport", "25", set_default));

 switch(b_getcfg_int_default(conf_name,"smtpsend", 0, set_default)) 	{
   case 0:
	fl_set_button(smtp_obj->SMTP_Sendmail, 1);
   break;

   case 1:
	fl_set_button(smtp_obj->SMTP_SMTP, 1);
   break;

   case 2:
	fl_set_button(smtp_obj->SMTP_POP, 1);
   break;

   default:
	fl_set_button(smtp_obj->SMTP_Sendmail, 1);
   break;
		}

 fl_set_button(smtp_obj->SMTP_Bg, b_getcfg_int_default(conf_name,"smtpbg", 0, set_default));

 fl_set_button(smtp_obj->SMTP_Save, b_getcfg_int_default(conf_name,"smtpsave", 0, set_default));
 fl_set_button(smtp_obj->SMTP_Bcc, b_getcfg_int_default(conf_name,"smtpbcc", 0, set_default));
 fl_set_button(smtp_obj->SMTP_Off, b_getcfg_int_default(conf_name,"smtpoffl", 0, set_default));
 fl_set_button(smtp_obj->SMTP_DSN, b_getcfg_int_default(conf_name,"smtpdsn", 0, set_default));

 fl_set_input(smtp_obj->Misc_SMail, b_getcfg_str_default(conf_name, "sendmail", _PATH_SENDMAIL, set_default));
 fl_set_input(smtp_obj->Sendmail_Opt, b_getcfg_str_default(conf_name, "sendmailopt", "-i", set_default));
 fl_set_input(smtp_obj->Sendmail_DSN, b_getcfg_str_default(conf_name, "sendmaildsn", "-R hdrs -N failure,delay,success", set_default));
 fl_set_button(smtp_obj->SMTP_Log, (logging & LOG_SMTP) ? 1 : 0);
}

void
handle_smtp_input(FD_config_send *form)
{
 smtp_obj = form;
 b_putcfg_str(conf_name, "smtphost", (char *)fl_get_input(smtp_obj->SMTP_Host));
 b_putcfg_str(conf_name, "smtport", (char *)fl_get_input(smtp_obj->SMTP_Port));

 if (fl_get_button(smtp_obj->SMTP_Sendmail))
	b_putcfg_int(conf_name, "smtpsend", 0);
 else
 if (fl_get_button(smtp_obj->SMTP_SMTP))
	b_putcfg_int(conf_name, "smtpsend", 1);
 else
 if (fl_get_button(smtp_obj->SMTP_POP))
	b_putcfg_int(conf_name, "smtpsend", 2);
 else
	b_putcfg_int(conf_name, "smtpsend", 0);

 b_putcfg_int(conf_name, "smtpbg", fl_get_button(smtp_obj->SMTP_Bg));

 b_putcfg_int(conf_name, "smtpsave", fl_get_button(smtp_obj->SMTP_Save));
 b_putcfg_int(conf_name, "smtpbcc", fl_get_button(smtp_obj->SMTP_Bcc));
 b_putcfg_int(conf_name, "smtpoffl", fl_get_button(smtp_obj->SMTP_Off));
 b_putcfg_int(conf_name, "smtpdsn", fl_get_button(smtp_obj->SMTP_DSN));
 offline = fl_get_button(smtp_obj->SMTP_Off);

 b_putcfg_str(conf_name, "sendmail",(char *)fl_get_input(smtp_obj->Misc_SMail));
 b_putcfg_str(conf_name, "sendmailop",(char *)fl_get_input(smtp_obj->Sendmail_Opt));
 b_putcfg_str(conf_name, "sendmaildsn",(char *)fl_get_input(smtp_obj->Sendmail_DSN));

 if (fl_get_button(smtp_obj->SMTP_Log))
        logging |= LOG_SMTP;
 else
        logging &= ~LOG_SMTP; 

 return;         
}
