# DEXPIRE.CTL
#
# Information from all matching entries are merged, taking
# the lowest equivalent expire time.  So, for example,
# a * entry with a maximum file size of 2m covers ALL
# articles, but a later :m400k match will reduce that.
#
# expiration is in days, but you should construct the file
# with an eye towards relative expiration rather then
# absolute since dexpire.factor automatically scales the
# expirations in this file based on available space.
#
# directives:
#
#	mSIZE[k,m,g]	specify maximum article size
#
#	sFLOAT		exponential size factor, reduce expire based
#			on article size.  1.0 == no effect.  Specify
#			a number 0.01 to 1.0 inclusive.  Numbers less
#			then 0.50 are typically not specified.
#
#			actual = pow(factor, SIZE/100000)
#
#	cFLOAT		exponential cross posting factor, reduce expire
#			based on number of cross posts.  1.0 == no effect.
#			Specify a number 0.01 to 1.0 inclusive.  Numbers
#			less then 0.50 are typically not specified.
#
#			actual = pow(factor, numgroups)
#
# An expiration of 0 rejects the article entirely.
#
# NOTE! expirations are set for an article when it is
# received, not when dexpire runs.

*:4.0:s0.85:c0.95:m2m
*.advocacy:1.0
*.test:1.0

alt.binaries.*:0.8:m400k
alt.binaries.pictures*:0.3
alt.binaries.warez*:0.1
alt.binaries.mac.games:1.0
alt.binaries.misc*:1.0
alt.binaries.multimedia.erotica:1.0
alt.binaries.games*:1.0
alt.cracks*:1.0:s0.50:m400k
alt.sex*:1.0:m400k
alt.sex.pictures*:1.0:m400k
#
# control
#
control:1.0

# permanent, semi-permanent, local groups
#
best.*:14.0

