/*
 * Decompiled with CFR 0.152.
 */
package jde.parser;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import jde.parser.JavaParser;
import jde.parser.ParseException;
import jde.parser.syntaxtree.CompilationUnit;
import jde.parser.visitor.GetVariablesVisitor;

public class ParserMain {
    static JavaParser parser;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Java Parser Version 1.1:  Reading from standard input . . .");
            JavaParser parser = new JavaParser(System.in);
        } else {
            if (args.length != 1) {
                System.out.println("Java Parser Version 1.1:  Usage is one of:");
                System.out.println("         java JavaParser < inputfile");
                System.out.println("OR");
                System.out.println("         java JavaParser inputfile");
                return;
            }
            System.out.println("Java Parser Version 1.1:  Reading from file " + args[0] + " . . .");
            try {
                JavaParser parser = new JavaParser(new FileInputStream(args[0]));
            }
            catch (FileNotFoundException e) {
                System.out.println("Java Parser Version 1.1:  File " + args[0] + " not found.");
                return;
            }
        }
        try {
            JavaParser.CompilationUnit();
            System.out.println("Java Parser Version 1.1:  Java program parsed successfully.");
            return;
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            System.out.println("Java Parser Version 1.1:  Encountered errors during parse.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void parseFile(String pathName) {
        try {
            if (parser == null) {
                parser = new JavaParser(new FileInputStream(pathName));
            } else {
                JavaParser.ReInit(new FileInputStream(pathName));
            }
        }
        catch (FileNotFoundException e) {
            ParserMain.println("\"Parser error:  File " + pathName + " not found.\"");
            return;
        }
        try {
            JavaParser.CompilationUnit();
            ParserMain.println("nil");
            return;
        }
        catch (ParseException e) {
            String message = e.getMessage().replace('\"', '\'');
            ParserMain.println("\"" + message + "\"");
        }
    }

    public static void println(String s) {
        System.out.print(s + "\n");
        System.out.flush();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void getVariables(String pathName) {
        try {
            if (parser == null) {
                parser = new JavaParser(new FileInputStream(pathName));
            } else {
                JavaParser.ReInit(new FileInputStream(pathName));
            }
        }
        catch (FileNotFoundException e) {
            ParserMain.println("\"Parser error:  File " + pathName + " not found.\"");
            return;
        }
        try {
            CompilationUnit root = JavaParser.CompilationUnit();
            ParserMain.println("nil");
            root.accept(new GetVariablesVisitor());
            return;
        }
        catch (ParseException e) {
            String message = e.getMessage().replace('\"', '\'');
            ParserMain.println("\"" + message + "\"");
        }
    }
}

