/*
 *	Sarien AGI :: Copyright (C) 1999 Dark Fiber
 *
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "sarien.h"
#include "agi.h"
#include "opcodes.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/*
 * Determine what AGI v2 system to emulate, these are the "majour" version
 * to emulate, thus 2.915 comes under 2.917, 2.4xxx is 2.440, etc.
 *
 * 0x2089
 * 0x2272
 * 0x2440
 * 0x2917
 * 0x2936
 */


typedef struct game_ID
{
	UINT16	id;
	UINT32	crc;
	UINT32	flags;
} game_ID;

static game_ID v2id[]=
{
	/* IBM PC versions */
{ 0x2440, 0x24A18, ID_NONE },/* Black Cauldron (2.00)   2.439   6/14/87 */
{ 0x2917, 0x49EDA, ID_NONE },/* Kings Quest 1 (2.0F)	2.917		*/
{ 0x2440, 0x633CB, ID_NONE },/* Kings Quest 2           2.411           */
{ 0x2917, 0x63338, ID_NONE },/* Kings Quest 2 (2.2)     2.917           */
{ 0x2272, 0x88673, ID_NONE },/* Kings Quest 3 (1.01)    2.272  11/08/86 */
{ 0x2440, 0x840D3, ID_NONE },/* Kings Quest 3 (2.00)    2.435   5/25/87 */
{ 0x2936, 0x8410B, ID_NONE },/* Kings Quest 3 (2.14)    2.936   3/15/88 */
{ 0x2936, 0x83695, ID_NONE },/* Kings Quest 3 (2.14)    2.936   3/15/88 */
{ 0x2440, 0x6F5E1, ID_NONE },/* Larry 1 (1.00)          2.440    6/1/87 */
{ 0x2917, 0x5D77C, ID_NONE },/* Mixed Up Mother Goose   2.915           */
{ 0x2917, 0x5D7C6, ID_NONE },/* Mixed Up Mother Goose   2.915           */
{ 0x2917, 0x7F18B, ID_NONE },/* Police Quest 1 (2.0A)   2.911  10/23/87 */
{ 0x2917, 0x7E0BC, ID_NONE },/* Polive Quest 1 (2.0G)   2.917  12/03/87 */
{ 0x2917, 0x7EF06, ID_NONE },/* Police Quest 1 (2.0G)   2.917  12/03/87 */
{ 0x2089, 0x68036, ID_NONE },/* Space Quest 1 (1.0X)    2.089           */
{ 0x2272, 0x67F6E, ID_NONE },/* Space Quest 1 (1.1A)    2.272           */
{ 0x2440, 0x68244, ID_NONE },/* Space Quest 1 (2.2)     2.426           */
{ 0x2917, 0x8DB32, ID_NONE },/* Space Quest 2           2.912           */
{ 0x2917, 0x8DA3E, ID_NONE },/* Space Quest 2 (2.0C)    2.915           */
{ 0x2936, 0x8E29B, ID_NONE },/* Space Quest 2 (2.0F)    2.936           */
{ 0x2272, 0x31677, ID_NONE },/* XMAS Card 1986          2.272           */
{ 0x2917, 0x8CC43, ID_NONE },/* Demo 1                  2.915           */
{ 0x2917, 0x8856C, ID_NONE },/* Demo 2                  2.915           */
{ 0x2917, 0x843AC, ID_NONE },/* Demo 3                  2.917           */

	/* Apple //gs versions */
{ 0x2272, 0x4A9E8, ID_NONE },/* Kings Quest 1 (1.0S-88223)              */
{ 0x2917, 0x5F4E8, ID_NONE },/* Mixed Up Mother Goose                   */
{ 0x2917, 0x7DB3F, ID_NONE },/* Police Quest 1 (2.0A)                   */

	/* Apple //gs versions :: guessed interp vers */
{ 0x2917, 0x93260, ID_NONE },/* Demo Disk 1.0C (Censored)		*/

	/* Apple Macintosh versions */
{ 0x2440, 0x4C02C, ID_NONE },/* Kings Quest 1 (2.0C)                    */
{ 0x2440, 0x6382E, ID_NONE },/* Kings Quest 2 (2.0R)                    */
{ 0x2440, 0x78202, ID_NONE },/* Larry 1 (1.05)                  6/26/87 */
{ 0x2936, 0x8DF84, ID_NONE },/* Space Quest 2 (2.0D)                    */

	/* ATARI-ST versions */
	/* guessed, kq3 pc august86 uses 2.272 */
{ 0x2272, 0x1A7AF, ID_NONE },/* Donald Duck's Playground 1.0C Aug 8, 1986 */

	/* Amiga versions */
{ 0x2440, 0x5BCE6, ID_AMIGA },/* Kings Quest 2 (2.0J)                   */
{ 0x2936, 0x8FEA6, ID_AMIGA },/* Space Quest 2 (2.0F)                   */
{ 0x2440, 0x6FDDB, ID_AMIGA },/* Leisure Suit Larry 1 (1.05)    6/26/87 */

	/* AGDS games */
{ 0x2440, 0x5501A, ID_AGDS },/* Groza, AGDS sample game                 */

{ 0x0000, 0x00000, ID_NONE }
};

static game_ID v3id[]=
{
{ 0x3086, 0x0B124B, ID_NONE },/* Kings Quest 4 (v2.0) 3.002.086  7/27/88 */
{ 0x3086, 0x0B291F, ID_NONE },/* Kings Quest 4 (v2.2) 3.002.086  9/27/88 */
{ 0x3149, 0x023E0E, ID_NONE },/* Black Cauldron       3.002.098          */
{ 0x3149, 0x022B50, ID_NONE },/* Black Cauldron       3.002.098          */
{ 0x3149, 0x089592, ID_NONE },/* Demo 4				  3.002.102          */
{ 0x3149, 0x09CB15, ID_NONE },/* Kings Quest 4 demo   3.002.102          */
{ 0x3149, 0x04C16D, ID_NONE },/* Manhunter 1 (1.22)   3.002.107  8/31/88 */
{ 0x3149, 0x053971, ID_NONE },/* Manhunter 2 (3.02)   3.002.149  7/26/89 */
{ 0x3149, 0x0B5A25, ID_NONE },/* Gold Rush (5.25)     3.002.149          */
{ 0x3149, 0x0B1C9E, ID_NONE },/* Gold Rush (3.5)      3.002.149          */
{ 0x3149, 0x0B1C08, ID_NONE },/* GR (Cracked) (3.5)   3.002.149          */
{ 0x3149, 0x0B598F, ID_NONE },/* GR (Cracked) (5.25)  3.002.149          */

	/* Amiga versions */
{ 0x3149, 0x4BA94, ID_AMIGA },/* Manhunter 1 (1.06)             3/18/89 */

	/* Apple //gs versions */
{ 0x3149, 0x285FB, ID_NONE },/* Black Cauldron 1.0O 2.24.89 (CE)         */
{ 0x3149, 0x4C705, ID_NONE },/* Manhunter New York 2.0E 10/05/88 (CE)    */

{ 0x0000, 0x00000, ID_NONE }
};


UINT32 v2id_game(void)
{
	UINT8 *fn[] = {
		(UINT8*)"viewdir",
		(UINT8*)"logdir",
		(UINT8*)"picdir",
		(UINT8*)"snddir",
		(UINT8*)"words.tok",
		(UINT8*)"object",
		(UINT8*)""
	};
	UINT16	ec=err_OK, x, y;
	UINT32	len, c, crc;
	UINT8	*buff;
	FILE	*fp;

	loader->int_version=0x2917;
	buff=(UINT8*)malloc(8192);

	for(crc=0, y=0; fn[y][0]!=0x0; y++)
	{
		fixpath(NO_GAMEDIR, fn[y]);
		if((fp=fopen((char*)path, "rb"))!=NULL)
		{
			len=1;
			while(len>0)
			{
				memset(buff, 0x0, 8192);
				len=fread(buff, 1, 8000, fp);
				for(c=0; c<len; c++)
					crc+=*(buff+c);
			}
			fclose(fp);
		}
	}
	free(buff);

	loader->int_version=0;

	for(x=0; v2id[x].id!=0x0; x++)
	{
		if(v2id[x].crc==crc)
		{
			loader->int_version=v2id[x].id;
			game_flags=v2id[x].flags;

			if((v2id[x].flags&ID_AGDS)==ID_AGDS)
			{
				optAGDS = __TRUE;
				printf ("AGDS game detected.\n");
			}
			/*
			else if (optAGDS)
			{
				optAGDS = __FALSE;
				printf ("AGDS mode disabled.\n");
			}
			*/
		}
	}

	if(loader->int_version==0)
	{
		printf("Unknown Sierra Game Version :: %08lX\n", crc);

		if(optAGDS==__FALSE)
			loader->int_version=0x2917;
	}

	/* setup the differences in the opcodes and other bits in the
	 * AGI v2 specs
	 */

	if(optEmuVersion!=0x0000)
		loader->int_version=optEmuVersion;

	if(optAGDS==__TRUE)
		loader->int_version=0x2440;		/* ALL AGDS games built for 2.440 */

	switch(loader->int_version)
	{
	case 0x2089:
		logic_names_cmd[0x86].num_args=0;	/* quit: 0 args */
	case 0x2272:
		logic_names_cmd[0x97].num_args=3;	/* print.at: 3 args */
		logic_names_cmd[0x98].num_args=3;	/* print.at.v: 3 args */
		break;
	case 0x2440:
		break;
	case 0x2917:
		break;
	case 0x2936:
		break;
	default:
		printf("** Cannot setup for unknown version\n");
		ec=err_UnknownAGIVersion;
		break;
	}

	return ec;
}

/*
 * Currently, there is no known difference between v3.002.098 -> v3.002.149
 * So version emulated;
 *
 * 0x0086,
 * 0x0149
 */

UINT32 v3id_game(void)
{
	UINT8 *fn[] = {
		(UINT8*)"words.tok",
		(UINT8*)"object",
		(UINT8*)""
	};

	UINT16	ec=err_OK, x, y;
	UINT32	len, c, crc;
	UINT8	*buff;
	FILE	*fp;

	loader->int_version=0x3149;			/* default v3 emulation */
	buff=(UINT8*)malloc(8192);

	for(crc=0, y=0; fn[y][0]!=0x0; y++)
	{
		fixpath(NO_GAMEDIR, fn[y]);
		if((fp=fopen((char*)path, "rb"))!=NULL)
		{
			len=1;
			while(len>0)
			{
				memset(buff, 0x0, 8192);
				len=fread(buff, 1, 8000, fp);
				for(c=0; c<len; c++)
					crc+=*(buff+c);
			}
			fclose(fp);
		}
	}

	/* no do the directory file */

	fixpath(GAMEDIR, (UINT8*)DIR);
	if((fp=fopen((char*)path, "rb"))!=NULL)
	{
		len=1;
		while(len>0)
		{
			memset(buff, 0x0, 8192);
			len=fread(buff, 1, 8000, fp);
			for(c=0; c<len; c++)
				crc+=*(buff+c);
		}
		fclose(fp);
	}

	free(buff);

	loader->int_version=0;
	for(x=0; v3id[x].id!=0x0; x++)
	{
		if(v3id[x].crc==crc)
		{
			loader->int_version=v3id[x].id;
			game_flags=v3id[x].flags;
		}
	}

	if(loader->int_version==0)
	{
		printf("Unknown Sierra Game Version :: %08lX\n", crc);
		loader->int_version=0x3149;
	}


	if(optEmuVersion!=0x0)
		loader->int_version=optEmuVersion;

	switch(loader->int_version)
	{
		case 0x3086:
			logic_names_cmd[0xAD].num_args=1;	/* 173 : 1 args */
			break;
		case 0x3149:
			logic_names_cmd[0xAD].num_args=0;	/* 173 : 0 args */
			break;
		default:
			printf("** Cannot setup for unknown version\n");
			ec=err_UnknownAGIVersion;
			break;
	}
	return ec;
}
