/*
 * Decompiled with CFR 0.152.
 */
package org.openxml.parser;

import java.io.IOException;
import java.io.Reader;
import org.openxml.DTDDocument;
import org.openxml.dom.EntityImpl;
import org.openxml.parser.BaseParser;
import org.openxml.parser.ParseException;
import org.openxml.util.FastString;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

abstract class ContentParser
extends BaseParser {
    protected Node _currentNode;
    protected DTDDocument _docType;
    private Text _entityLt;
    private Text _entityGt;
    private Text _entityAmp;
    private Text _entityApos;
    private Text _entityQuot;

    protected ContentParser(Reader reader, String string, short s, short s2) {
        super(reader, string, s, s2);
    }

    protected final Node getEntityContents(String string, boolean bl) throws ParseException {
        if (string.equals("lt")) {
            if (this._entityLt == null) {
                this._entityLt = this._document.createTextNode("<");
            }
            return this._entityLt;
        }
        if (string.equals("gt")) {
            if (this._entityGt == null) {
                this._entityGt = this._document.createTextNode(">");
            }
            return this._entityGt;
        }
        if (string.equals("amp")) {
            if (this._entityAmp == null) {
                this._entityAmp = this._document.createTextNode("&");
            }
            return this._entityAmp;
        }
        if (string.equals("apos")) {
            if (this._entityApos == null) {
                this._entityApos = this._document.createTextNode("'");
            }
            return this._entityApos;
        }
        if (string.equals("quot")) {
            if (this._entityQuot == null) {
                this._entityQuot = this._document.createTextNode("\"");
            }
            return this._entityQuot;
        }
        if (this._docType != null) {
            EntityImpl entityImpl = this._docType.findEntity(string);
            if (entityImpl != null) {
                if (entityImpl.isUnparsed()) {
                    if (bl) {
                        this.error((short)1, "Unparsed general entity '" + this._tokenText + "' cannot be used in attribute value.");
                    } else {
                        this.error((short)1, "Unparsed general entity '" + this._tokenText + "' cannot be used in document content.");
                    }
                } else if (bl && !entityImpl.isInternal()) {
                    this.error((short)1, "External general entity '" + this._tokenText + "' cannot be used in attribute value.");
                } else if (this.parseGeneralEntity(entityImpl) != null) {
                    return entityImpl.getFirstChild();
                }
            } else {
                this.error((short)1, "General entity '" + string + "' not declared.");
            }
            return this._document.createEntityReference(string);
        }
        this.error((short)1, "General entity '" + string + "' not declared, DTD missing.");
        return this._document.createEntityReference(string);
    }

    protected final void parseAttrEntity() throws ParseException {
        Node node = this.getEntityContents(this._tokenText.toString(), true);
        this._tokenText.setLength(0);
        while (node != null) {
            if (node instanceof Text || node instanceof CDATASection) {
                this._tokenText.append(((CharacterData)node).getData());
            } else if (!(node instanceof Comment) && !(node instanceof ProcessingInstruction)) {
                if (node instanceof EntityReference) {
                    this._tokenText.append('&').append(node.getNodeName()).append(';');
                    this.error((short)1, "Could not recursively parse entity '" + this._tokenText + "' for use in attribute value.");
                    return;
                }
                this.error((short)1, "Non-textual entity '" + this._tokenText + "' cannot be used in attribute value.");
                return;
            }
            node = node.getNextSibling();
        }
    }

    protected final boolean parseAttributes(Element element, boolean bl) throws ParseException, IOException {
        FastString fastString = null;
        this.readChar();
        while (this._curChar != -1) {
            if (this._curChar == 62) {
                return true;
            }
            if (bl && this._curChar == 47) {
                if (this.readChar() == 62) {
                    return false;
                }
                this.pushBack();
            } else {
                if (this._curChar == 60) {
                    this.error((short)1, "Element's attribute list terminated prematurely.");
                    this.pushBack();
                    return true;
                }
                if (this.isNamePart(this._curChar, true)) {
                    int n;
                    this._tokenText.setLength(1);
                    this._tokenText.setCharAt(0, (char)this._curChar);
                    while (this.isNamePart(this.readChar(), false)) {
                        this._tokenText.append((char)this._curChar);
                    }
                    String string = this._tokenText.toString();
                    Attr attr = this._document.createAttribute(string);
                    if (element.getAttributeNode(string) != null && element.getAttributeNode(string).getSpecified()) {
                        this.error((short)1, "Attribute '" + string + "' defined twice for this element.");
                    } else {
                        element.setAttributeNode(attr);
                    }
                    while (this.isSpace(this._curChar)) {
                        this.readChar();
                    }
                    if (this._curChar != 61) continue;
                    while (this.isSpace(this.readChar())) {
                    }
                    if (this._curChar == 39 || this._curChar == 34) {
                        n = this._curChar;
                        this.readChar();
                    } else {
                        if (bl) {
                            this.error((short)1, "Attribute value not enclosed with quotes.");
                        }
                        n = 32;
                    }
                    if (fastString == null) {
                        fastString = new FastString(32);
                    } else {
                        fastString.setLength(0);
                    }
                    boolean bl2 = false;
                    while (this._curChar != -1) {
                        if (this._curChar == n) {
                            this.readChar();
                            break;
                        }
                        if (n == 32) {
                            if (this.isSpace(this._curChar) || this._curChar == 62) break;
                            if (bl && this._curChar == 47) {
                                if (this.readChar() == 62) {
                                    this.pushBack();
                                    this._curChar = 47;
                                    break;
                                }
                                this.pushBack();
                                fastString.append('/');
                            }
                        } else {
                            if (this._curChar == 60) break;
                            if (this._curChar == 38) {
                                if (this.readTokenEntity() == 0) {
                                    fastString.append(this._tokenText);
                                } else {
                                    fastString.append('&').append(this._tokenText).append(';');
                                }
                            } else if (this.isSpace(this._curChar)) {
                                fastString.append(' ');
                            } else {
                                fastString.append((char)this._curChar);
                            }
                        }
                        this.readChar();
                    }
                    if (fastString.length() <= 0) continue;
                    attr.setValue(fastString.toString());
                    continue;
                }
                if (!this.isSpace(this._curChar)) {
                    this.error((short)1, "Element contains junk text inbetween attributes.");
                }
            }
            this.readChar();
        }
        this.error((short)1, "Element's attribute list terminated prematurely.");
        return true;
    }

    protected final void parseContentEntity() throws ParseException {
        Node node = this.getEntityContents(this._tokenText.toString(), false);
        while (node != null) {
            this._currentNode.appendChild(node.cloneNode(true));
            node = node.getNextSibling();
        }
    }

    protected final int readTokenContent() throws ParseException, IOException {
        this.readChar();
        if (this._curChar == 60) {
            return this.readTokenMarkup();
        }
        if (this._curChar == 38) {
            return this.readTokenEntity();
        }
        if (this._curChar == -1) {
            return -1;
        }
        this._tokenText.setLength(0);
        while (this._curChar != -1 && this._curChar != 60 && this._curChar != 38) {
            this._tokenText.append((char)this._curChar);
            this.readChar();
        }
        if (this._curChar != -1) {
            this.pushBack();
        }
        return 0;
    }
}

