/*
 * Decompiled with CFR 0.152.
 */
package org.openxml.x3p.processors;

import org.openxml.util.Log;
import org.openxml.util.Resources;
import org.openxml.x3p.ProcessContext;
import org.openxml.x3p.Processor;
import org.openxml.x3p.ProcessorEngine;
import org.openxml.x3p.ProcessorEngineCreator;
import org.openxml.x3p.ProcessorException;
import org.openxml.x3p.processors.ProcessContextImpl;
import org.openxml.x3p.processors.TreeIterator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ChainProcessor
extends ProcessContextImpl
implements Processor,
ProcessorEngine {
    private ProcessorEngineCreator[] _factories;

    public ChainProcessor(Object object, ProcessorEngineCreator[] processorEngineCreatorArray) {
        super(object);
        if (processorEngineCreatorArray == null) {
            throw new NullPointerException(Resources.format("Error001", "factories"));
        }
        this._factories = processorEngineCreatorArray;
    }

    public void destroy(ProcessContext processContext) {
    }

    public ProcessContext getContext() {
        return this;
    }

    public synchronized Node process(ProcessContext processContext, Node node) throws ProcessorException {
        int n = 0;
        while (n < this._factories.length) {
            Node node2;
            ProcessorEngine processorEngine = this._factories[n].createEngine(processContext);
            if (Log.DEBUG) {
                Log.debug("ChainProcessor.process: Created processor engine [" + processorEngine + "]");
            }
            if (processorEngine.whatToProcess() == 0) {
                node2 = processorEngine.process(processContext, node);
                if (node2 == null) {
                    processorEngine.destroy(processContext);
                    return null;
                }
                if (node2 != node) {
                    node = node2;
                }
            } else {
                TreeIterator treeIterator = new TreeIterator(node, processorEngine.whatToProcess());
                Node node3 = treeIterator.nextNode();
                while (node3 != null) {
                    Node node4 = treeIterator.nextNode();
                    node2 = processorEngine.process(processContext, node3);
                    if (node2 == null) {
                        node3.getParentNode().removeChild(node3);
                    } else if (node2 != node3) {
                        node4 = node2;
                        node3.getParentNode().replaceChild(node2, node3);
                    }
                    node3 = node4;
                }
            }
            processorEngine.destroy(processContext);
            ++n;
        }
        return node;
    }

    public synchronized Document process(Document document) throws ProcessorException {
        return (Document)this.process(this.getContext(), document);
    }

    public synchronized Node process(Node node) throws ProcessorException {
        return this.process(this.getContext(), node);
    }

    public String toString() {
        if (this._factories.length == 0) {
            return Resources.message("Processor009");
        }
        String string = "ChainProcessor [" + this._factories[0].toString();
        int n = 0;
        while (n < this._factories.length) {
            string = String.valueOf(string) + ", " + this._factories[n].toString();
            ++n;
        }
        return String.valueOf(string) + "]";
    }

    public int whatToProcess() {
        return 0;
    }
}

