/*
 * Decompiled with CFR 0.152.
 */
package org.openxml.x3p.publishers;

import java.io.IOException;
import java.io.StringWriter;
import org.openxml.x3p.Publisher;
import org.openxml.x3p.StreamFormat;
import org.openxml.x3p.publishers.HTMLStreamPublisher;
import org.openxml.x3p.publishers.StreamPublisher;
import org.openxml.x3p.publishers.StreamPublisherTarget;
import org.openxml.x3p.publishers.XHTMLStreamPublisher;
import org.openxml.x3p.publishers.XMLStreamPublisher;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLDocument;
import org.w3c.dom.html.HTMLElement;

public class StringPublisher
implements Publisher {
    private StreamFormat _format;
    private StringWriter _writer;
    private StreamPublisher _lastPublisher;

    public StringPublisher(StreamFormat streamFormat) {
        this._format = streamFormat;
    }

    public synchronized void close() {
        if (this._lastPublisher != null) {
            this._lastPublisher.close();
        }
    }

    private StreamPublisher getPublisher(Node node) throws IOException {
        if (this._writer == null) {
            this._writer = new StringWriter();
        }
        if (this._lastPublisher == null) {
            if (this._format == null) {
                this._format = node instanceof HTMLDocument || node instanceof HTMLElement ? StreamFormat.XHTML : StreamFormat.XML;
            } else if (!(this._format.isXML() || this._format.isHTML() || this._format.isXHTML())) {
                this._format = node instanceof HTMLDocument || node instanceof HTMLElement ? this._format.changeToXHTML() : this._format.changeToXML();
            }
            StreamPublisherTarget streamPublisherTarget = new StreamPublisherTarget(this._writer, this._format);
            if (this._format.isXML()) {
                this._lastPublisher = new XMLStreamPublisher(streamPublisherTarget);
            } else if (this._format.isHTML()) {
                this._lastPublisher = new HTMLStreamPublisher(streamPublisherTarget);
            } else if (this._format.isXHTML()) {
                this._lastPublisher = new XHTMLStreamPublisher(streamPublisherTarget);
            }
        }
        return this._lastPublisher;
    }

    public String getString() {
        if (this._writer == null) {
            return "";
        }
        return this._writer.toString();
    }

    public StringBuffer getStringBuffer() {
        if (this._writer == null) {
            return new StringBuffer();
        }
        return this._writer.getBuffer();
    }

    public synchronized void publish(Document document) throws IOException {
        this.getPublisher(document).publish(document);
    }

    public synchronized void publish(Node node) throws IOException {
        this.getPublisher(node).publish(node);
    }
}

