/*
 * Decompiled with CFR 0.152.
 */
package com.kvisco.xsl;

import com.kvisco.xsl.InvalidExprException;
import com.kvisco.xsl.MatchExpr;
import com.kvisco.xsl.NodeSet;
import com.kvisco.xsl.ProcessorState;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AxisIdentifier {
    public static NodeSet fromAncestors(MatchExpr matchExpr, Node node, ProcessorState processorState) throws InvalidExprException {
        Node node2 = null;
        if (node != null) {
            node2 = node.getParentNode();
        }
        return AxisIdentifier.fromAncestorsOrSelf(matchExpr, node2, processorState);
    }

    public static NodeSet fromAncestorsOrSelf(MatchExpr matchExpr, Node node, ProcessorState processorState) throws InvalidExprException {
        NodeSet nodeSet = new NodeSet();
        Node node2 = node;
        while (node2 != null) {
            if (matchExpr.matches(node2, node, processorState)) {
                nodeSet.add(node2);
            }
            node2 = node2.getParentNode();
        }
        return nodeSet;
    }

    public static NodeSet fromAttributes(MatchExpr matchExpr, Node node, ProcessorState processorState) throws InvalidExprException {
        NodeSet nodeSet = new NodeSet();
        if (node.getNodeType() != 1) {
            return nodeSet;
        }
        NamedNodeMap namedNodeMap = ((Element)node).getAttributes();
        if (namedNodeMap != null) {
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                if (matchExpr.matches(namedNodeMap.item(n), node, processorState)) {
                    nodeSet.add(namedNodeMap.item(n));
                }
                ++n;
            }
        }
        return nodeSet;
    }

    public static NodeSet fromChildren(MatchExpr matchExpr, Node node, ProcessorState processorState) throws InvalidExprException {
        NodeSet nodeSet = new NodeSet();
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            if (matchExpr.matches(node2, node, processorState)) {
                nodeSet.add(node2);
            }
            ++n;
        }
        return nodeSet;
    }

    public static NodeSet fromDescendants(MatchExpr matchExpr, Node node, ProcessorState processorState) throws InvalidExprException {
        NodeSet nodeSet = new NodeSet();
        if (node == null) {
            return nodeSet;
        }
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            if (matchExpr.matches(node2, node, processorState)) {
                nodeSet.add(node2);
            }
            if (node2.hasChildNodes()) {
                NodeSet nodeSet2 = AxisIdentifier.fromDescendants(matchExpr, node2, processorState);
                nodeSet.add(nodeSet2);
            }
            ++n;
        }
        return nodeSet;
    }

    public static NodeSet fromDescendantsOrSelf(MatchExpr matchExpr, Node node, ProcessorState processorState) throws InvalidExprException {
        if (node == null) {
            return new NodeSet();
        }
        NodeSet nodeSet = AxisIdentifier.fromDescendants(matchExpr, node, processorState);
        if (matchExpr.matches(node, node, processorState)) {
            nodeSet.add(0, node);
        }
        return nodeSet;
    }

    public static NodeSet fromFollowing(MatchExpr matchExpr, Node node, ProcessorState processorState) throws InvalidExprException {
        NodeSet nodeSet = new NodeSet();
        if (node == null) {
            return nodeSet;
        }
        Object object = node.getNextSibling();
        while (object != null) {
            Object object2;
            if (matchExpr.matches((Node)object, node, processorState)) {
                nodeSet.add((Node)object);
            }
            if (object.hasChildNodes()) {
                object2 = AxisIdentifier.fromDescendants(matchExpr, (Node)object, processorState);
                nodeSet.add((NodeSet)object2);
            }
            if ((object2 = object.getNextSibling()) == null) {
                if ((object = object.getParentNode()) == null || object.getNodeType() == 9) continue;
                object = object.getNextSibling();
                continue;
            }
            object = object2;
        }
        return nodeSet;
    }

    public static NodeSet fromFollowingSiblings(MatchExpr matchExpr, Node node, ProcessorState processorState) throws InvalidExprException {
        NodeSet nodeSet = new NodeSet();
        if (node == null) {
            return nodeSet;
        }
        Node node2 = node.getNextSibling();
        while (node2 != null) {
            if (matchExpr.matches(node2, node, processorState)) {
                nodeSet.add(node2);
            }
            node2 = node2.getNextSibling();
        }
        return nodeSet;
    }

    public static NodeSet fromParent(MatchExpr matchExpr, Node node, ProcessorState processorState) throws InvalidExprException {
        NodeSet nodeSet = new NodeSet();
        Node node2 = null;
        node2 = node.getNodeType() == 2 ? processorState.findParent((Attr)node) : node.getParentNode();
        if (matchExpr.matches(node2, node, processorState)) {
            nodeSet.add(node2);
        }
        return nodeSet;
    }

    public static NodeSet fromPreceding(MatchExpr matchExpr, Node node, ProcessorState processorState) throws InvalidExprException {
        NodeSet nodeSet = new NodeSet();
        if (node == null) {
            return nodeSet;
        }
        Node node2 = node.getPreviousSibling();
        if (node2 == null) {
            node2 = node.getParentNode();
        }
        while (node2 != null) {
            Node node3;
            if (matchExpr.matches(node2, node, processorState)) {
                nodeSet.add(node2);
            }
            node2 = (node3 = node2.getPreviousSibling()) == null ? node2.getParentNode() : node3;
        }
        return nodeSet;
    }

    public static NodeSet fromPrecedingSiblings(MatchExpr matchExpr, Node node, ProcessorState processorState) throws InvalidExprException {
        NodeSet nodeSet = new NodeSet();
        if (node == null) {
            return nodeSet;
        }
        Node node2 = node.getPreviousSibling();
        while (node2 != null) {
            if (matchExpr.matches(node2, node, processorState)) {
                nodeSet.add(node2);
            }
            node2 = node2.getPreviousSibling();
        }
        return nodeSet;
    }

    public static NodeSet fromSelf(MatchExpr matchExpr, Node node, ProcessorState processorState) throws InvalidExprException {
        NodeSet nodeSet = new NodeSet();
        if (matchExpr.matches(node, node, processorState)) {
            nodeSet.add(node);
        }
        return nodeSet;
    }
}

