/*
 * Decompiled with CFR 0.152.
 */
package com.kvisco.xsl;

import com.kvisco.util.List;
import com.kvisco.util.QuickStack;
import com.kvisco.xsl.AdditiveExpr;
import com.kvisco.xsl.AndExpr;
import com.kvisco.xsl.AnyNodeExpr;
import com.kvisco.xsl.AttributeExpr;
import com.kvisco.xsl.CommentExpr;
import com.kvisco.xsl.ElementExpr;
import com.kvisco.xsl.EqualityExpr;
import com.kvisco.xsl.Expr;
import com.kvisco.xsl.FilterBase;
import com.kvisco.xsl.FilterExpr;
import com.kvisco.xsl.IdentityExpr;
import com.kvisco.xsl.InvalidExprException;
import com.kvisco.xsl.LocationStep;
import com.kvisco.xsl.MatchExpr;
import com.kvisco.xsl.MultiplicativeExpr;
import com.kvisco.xsl.NodeExpr;
import com.kvisco.xsl.OrExpr;
import com.kvisco.xsl.PIExpr;
import com.kvisco.xsl.ParentExpr;
import com.kvisco.xsl.PathExpr;
import com.kvisco.xsl.PrimaryExpr;
import com.kvisco.xsl.RootExpr;
import com.kvisco.xsl.SelectExpr;
import com.kvisco.xsl.StringExpr;
import com.kvisco.xsl.UnionExpr;
import com.kvisco.xsl.WildCardExpr;
import com.kvisco.xsl.functions.BooleanFunctionCall;
import com.kvisco.xsl.functions.Concat;
import com.kvisco.xsl.functions.Contains;
import com.kvisco.xsl.functions.CountFunctionCall;
import com.kvisco.xsl.functions.DocumentFunctionCall;
import com.kvisco.xsl.functions.ExtensionFunctionCall;
import com.kvisco.xsl.functions.FalseFunctionCall;
import com.kvisco.xsl.functions.FormatNumber;
import com.kvisco.xsl.functions.FunctionCall;
import com.kvisco.xsl.functions.GenerateIDFunctionCall;
import com.kvisco.xsl.functions.IdFunctionCall;
import com.kvisco.xsl.functions.IdRefFunctionCall;
import com.kvisco.xsl.functions.LangFunctionCall;
import com.kvisco.xsl.functions.LastFunctionCall;
import com.kvisco.xsl.functions.Normalize;
import com.kvisco.xsl.functions.NotFunctionCall;
import com.kvisco.xsl.functions.NumberFunctionCall;
import com.kvisco.xsl.functions.PositionFunctionCall;
import com.kvisco.xsl.functions.StartsWith;
import com.kvisco.xsl.functions.StringFunctionCall;
import com.kvisco.xsl.functions.StringLength;
import com.kvisco.xsl.functions.Substring;
import com.kvisco.xsl.functions.SubstringAfter;
import com.kvisco.xsl.functions.SubstringBefore;
import com.kvisco.xsl.functions.SumFunctionCall;
import com.kvisco.xsl.functions.SystemFunctionCall;
import com.kvisco.xsl.functions.TextFunctionCall;
import com.kvisco.xsl.functions.Translate;
import com.kvisco.xsl.functions.TrueFunctionCall;
import com.kvisco.xsl.functions.XMLNamesFunctionCall;
import com.kvisco.xsl.util.ExprLexer;
import com.kvisco.xsl.util.Token;

public class ExpressionParser {
    private static final String PATTERN_SEP = "|";
    private static WildCardExpr wildCardExpr = new WildCardExpr();
    private static final String INVALID_EXPR = "Invalid expression: ";

    private static Expr createBinaryExpr(Expr expr, Expr expr2, Token token) throws InvalidExprException {
        if (expr == null) {
            throw new InvalidExprException("Missing left side of expression: ");
        }
        if (expr2 == null) {
            throw new InvalidExprException("Missing right side of expression: ");
        }
        switch (token.type) {
            case 302: {
                return new OrExpr(expr, expr2);
            }
            case 301: {
                return new AndExpr(expr, expr2);
            }
            case 312: {
                return new EqualityExpr(expr, expr2, 0);
            }
            case 314: {
                return new EqualityExpr(expr, expr2, 1);
            }
            case 315: {
                return new EqualityExpr(expr, expr2, 2);
            }
            case 316: {
                return new EqualityExpr(expr, expr2, 4);
            }
            case 317: {
                return new EqualityExpr(expr, expr2, 5);
            }
            case 309: {
                return new AdditiveExpr(expr, expr2, 0);
            }
            case 310: {
                return new AdditiveExpr(expr, expr2, 1);
            }
            case 311: {
                return new MultiplicativeExpr(expr, expr2, 0);
            }
            case 303: {
                return new MultiplicativeExpr(expr, expr2, 2);
            }
            case 304: {
                return new MultiplicativeExpr(expr, expr2, 1);
            }
            case 305: {
                return new MultiplicativeExpr(expr, expr2, 3);
            }
        }
        throw new InvalidExprException("Invalid binary expr: " + expr + token + expr2);
    }

    private static Expr createExpr(ExprLexer exprLexer) throws InvalidExprException {
        if (!exprLexer.hasMoreTokens()) {
            ExpressionParser.missingExpr(exprLexer.toString(), null);
        }
        Expr expr = null;
        QuickStack quickStack = new QuickStack();
        QuickStack quickStack2 = new QuickStack();
        boolean bl = true;
        int n = exprLexer.getPosition();
        while (exprLexer.hasMoreTokens() && bl) {
            Token token = exprLexer.nextToken();
            if (ExprLexer.isBinaryOp(token)) {
                if (!quickStack.empty() && !ExpressionParser.hasGreaterPrecedence(token, (Token)quickStack2.peek())) {
                    expr = ExpressionParser.createBinaryExpr((Expr)quickStack.pop(), expr, (Token)quickStack2.pop());
                }
                quickStack.push(expr);
                quickStack2.push(token);
                continue;
            }
            switch (token.type) {
                case 2: 
                case 4: 
                case 6: {
                    exprLexer.pushBack();
                    bl = false;
                    break;
                }
                case 701: {
                    PrimaryExpr primaryExpr = new PrimaryExpr(2);
                    primaryExpr.setLiteral(token.value);
                    expr = primaryExpr;
                    break;
                }
                case 308: {
                    Expr expr2;
                    if (expr == null) {
                        throw new InvalidExprException("| cannot start an expr");
                    }
                    if (expr instanceof PathExpr) {
                        expr2 = ExpressionParser.createUnionExpr(exprLexer);
                        ((UnionExpr)expr2).add((PathExpr)expr, 0);
                        expr = expr2;
                        break;
                    }
                    throw new InvalidExprException();
                }
                case 306: 
                case 307: {
                    if (expr == null) {
                        exprLexer.pushBack();
                        expr = ExpressionParser.createPathExpr(exprLexer);
                        break;
                    }
                    throw new InvalidExprException();
                }
                default: {
                    exprLexer.pushBack();
                    if (ExpressionParser.isLocationStepToken(token)) {
                        if (expr == null) {
                            expr = ExpressionParser.createPathExpr(exprLexer);
                            break;
                        }
                        if (expr instanceof PathExpr) {
                            ((PathExpr)expr).add(ExpressionParser.createLocationStep(exprLexer));
                            break;
                        }
                        throw new InvalidExprException();
                    }
                    Expr expr2 = ExpressionParser.createPrimaryExpr(exprLexer);
                    Token token2 = exprLexer.lookAhead(0);
                    if (token2 != null && token2.type == 3) {
                        PathExpr pathExpr = null;
                        FilterExpr filterExpr = new FilterExpr();
                        filterExpr.setPrimaryExpr((PrimaryExpr)expr2);
                        ExpressionParser.parsePredicates(filterExpr, exprLexer);
                        pathExpr = new PathExpr();
                        pathExpr.add(filterExpr);
                        expr = pathExpr;
                        break;
                    }
                    expr = expr2;
                    break;
                }
            }
        }
        while (!quickStack.empty()) {
            expr = ExpressionParser.createBinaryExpr((Expr)quickStack.pop(), expr, (Token)quickStack2.pop());
        }
        return expr;
    }

    public static Expr createExpr(String string) throws InvalidExprException {
        ExprLexer exprLexer = new ExprLexer(string);
        Expr expr = ExpressionParser.createExpr(exprLexer);
        return expr;
    }

    private static FilterExpr createFilterExpr(ExprLexer exprLexer) throws InvalidExprException {
        FilterExpr filterExpr = new FilterExpr();
        PrimaryExpr primaryExpr = ExpressionParser.createPrimaryExpr(exprLexer);
        if (primaryExpr == null) {
            throw new InvalidExprException(exprLexer.toString());
        }
        filterExpr.setPrimaryExpr(primaryExpr);
        ExpressionParser.parsePredicates(filterExpr, exprLexer);
        return filterExpr;
    }

    public static FilterExpr createFilterExpr(String string) throws InvalidExprException {
        return ExpressionParser.createFilterExpr(new ExprLexer(string));
    }

    public static FunctionCall createFunctionCall(String string, List list) {
        FunctionCall functionCall = null;
        if ((string = string.intern()) == "true") {
            return new TrueFunctionCall();
        }
        if (string == "false") {
            return new FalseFunctionCall();
        }
        if (string == "not") {
            functionCall = new NotFunctionCall();
        } else if (string == "boolean") {
            functionCall = new BooleanFunctionCall();
        } else if (string == "lang") {
            functionCall = new LangFunctionCall();
        } else {
            if (string == "position") {
                return new PositionFunctionCall();
            }
            if (string == "last") {
                return new LastFunctionCall();
            }
            if (string == "count") {
                functionCall = new CountFunctionCall();
            } else if (string == "local-part") {
                functionCall = new XMLNamesFunctionCall(1);
            } else if (string == "namespace") {
                functionCall = new XMLNamesFunctionCall(3);
            } else if (string == "name") {
                functionCall = new XMLNamesFunctionCall();
            } else if (string == "qname") {
                functionCall = new XMLNamesFunctionCall();
            } else if (string == "generate-id") {
                functionCall = new GenerateIDFunctionCall();
            } else if (string == "id") {
                functionCall = new IdFunctionCall();
            } else if (string == "idref") {
                functionCall = new IdRefFunctionCall();
            } else if (string == "doc") {
                functionCall = new DocumentFunctionCall();
            } else if (string == "document") {
                functionCall = new DocumentFunctionCall();
            } else {
                if (string == "text") {
                    return new TextFunctionCall();
                }
                if (string == "concat") {
                    functionCall = new Concat();
                } else if (string == "contains") {
                    functionCall = new Contains();
                } else if (string == "format-number") {
                    functionCall = new FormatNumber();
                } else if (string == "normalize") {
                    functionCall = new Normalize();
                } else if (string == "starts-with") {
                    functionCall = new StartsWith();
                } else if (string == "string") {
                    functionCall = new StringFunctionCall();
                } else if (string == "string-length") {
                    functionCall = new StringLength();
                } else if (string == "substring") {
                    functionCall = new Substring();
                } else if (string == "substring-before") {
                    functionCall = new SubstringBefore();
                } else if (string == "substring-after") {
                    functionCall = new SubstringAfter();
                } else if (string == "translate") {
                    functionCall = new Translate();
                } else if (string == "sum") {
                    functionCall = new SumFunctionCall();
                } else if (string == "number") {
                    functionCall = new NumberFunctionCall();
                } else if (string == "floor") {
                    functionCall = new NumberFunctionCall(2);
                } else if (string == "ceiling") {
                    functionCall = new NumberFunctionCall(3);
                } else if (string == "round") {
                    functionCall = new NumberFunctionCall(1);
                } else if (string == "system-property") {
                    functionCall = new SystemFunctionCall();
                } else if (string == "function-available") {
                    functionCall = new SystemFunctionCall(2);
                }
            }
        }
        if (functionCall == null) {
            functionCall = new ExtensionFunctionCall(string);
        }
        int n = 0;
        while (n < list.size()) {
            functionCall.addExprParameter((Expr)list.get(n));
            ++n;
        }
        return functionCall;
    }

    private static LocationStep createLocationStep(ExprLexer exprLexer) throws InvalidExprException {
        LocationStep locationStep = new LocationStep();
        Token token = exprLexer.lookAhead(0);
        short s = 3;
        int n = 1;
        switch (token.type) {
            case 601: {
                s = 0;
                break;
            }
            case 602: {
                s = 1;
                break;
            }
            case 603: {
                s = 2;
                break;
            }
            case 604: {
                s = 3;
                break;
            }
            case 605: {
                s = 4;
                break;
            }
            case 606: {
                s = 5;
                break;
            }
            case 607: {
                s = 6;
                break;
            }
            case 608: {
                s = 7;
                break;
            }
            case 609: {
                s = 8;
                break;
            }
            case 610: {
                s = 9;
                break;
            }
            case 611: {
                s = 10;
                break;
            }
            case 612: {
                s = 11;
                break;
            }
            default: {
                n = 0;
            }
        }
        if (n == 1 && exprLexer.lookAhead((int)1).type == 1) {
            n = 2;
        }
        exprLexer.advance(n);
        NodeExpr nodeExpr = ExpressionParser.createNodeExpr(exprLexer);
        if (nodeExpr == null) {
            throw new InvalidExprException(exprLexer.toString());
        }
        locationStep.setNodeExpr(nodeExpr);
        ExpressionParser.parsePredicates(locationStep, exprLexer);
        if (n > 0) {
            token = exprLexer.nextToken();
            if (token.type != 2) {
                throw new InvalidExprException("missing closing parenthesis ')'");
            }
        } else {
            switch (nodeExpr.getNodeExprType()) {
                case 4: {
                    s = 11;
                    break;
                }
                case 5: {
                    s = 8;
                    break;
                }
                case 1: {
                    s = 2;
                    break;
                }
            }
        }
        locationStep.setAxisIdentifier(s);
        return locationStep;
    }

    public static LocationStep createLocationStep(String string) throws InvalidExprException {
        return ExpressionParser.createLocationStep(new ExprLexer(string));
    }

    public static MatchExpr createMatchExpr(String string) throws InvalidExprException {
        UnionExpr unionExpr = ExpressionParser.createUnionExpr(string);
        return unionExpr;
    }

    public static NodeExpr createNodeExpr(ExprLexer exprLexer) throws InvalidExprException {
        NodeExpr nodeExpr;
        block21: {
            Token token;
            block20: {
                nodeExpr = null;
                token = exprLexer.nextToken();
                if (token == null) {
                    return null;
                }
                if (!exprLexer.hasMoreTokens() || exprLexer.lookAhead((int)0).type != 1) break block20;
                Object var3_3 = null;
                exprLexer.advance(1);
                Token token2 = exprLexer.nextToken();
                if (token2 == null) {
                    ExpressionParser.unexpectedToken(exprLexer.toString(), null);
                }
                String string = null;
                while (token2.type != 2) {
                    string = string == null ? token2.value : String.valueOf(string) + token2.value;
                    token2 = exprLexer.nextToken();
                    if (token2 != null) continue;
                    ExpressionParser.unexpectedToken(exprLexer.toString(), null);
                }
                switch (token.type) {
                    case 203: {
                        nodeExpr = new TextFunctionCall();
                        break block21;
                    }
                    case 202: {
                        nodeExpr = new CommentExpr();
                        break block21;
                    }
                    case 204: {
                        nodeExpr = new PIExpr(string);
                        break block21;
                    }
                    case 201: {
                        nodeExpr = new AnyNodeExpr();
                        break block21;
                    }
                    default: {
                        throw new InvalidExprException();
                    }
                }
            }
            switch (token.type) {
                case 7: {
                    Token token3 = exprLexer.nextToken();
                    switch (token3.type) {
                        default: {
                            ExpressionParser.unexpectedToken(exprLexer.toString(), token3);
                        }
                        case 101: 
                        case 102: 
                    }
                    nodeExpr = new AttributeExpr(token3.value);
                    break;
                }
                case 603: {
                    nodeExpr = new AttributeExpr(token.value);
                    break;
                }
                case 802: {
                    nodeExpr = new IdentityExpr();
                    break;
                }
                case 803: {
                    nodeExpr = new ParentExpr();
                    break;
                }
                case 101: {
                    nodeExpr = wildCardExpr;
                    break;
                }
                case 401: {
                    throw new InvalidExprException();
                }
                default: {
                    nodeExpr = new ElementExpr(token.value);
                    break;
                }
            }
        }
        return nodeExpr;
    }

    public static PathExpr createPathExpr(ExprLexer exprLexer) throws InvalidExprException {
        PathExpr pathExpr = new PathExpr();
        if (!exprLexer.hasMoreTokens()) {
            return pathExpr;
        }
        boolean bl = false;
        Token token = exprLexer.lookAhead(0);
        if (token.type == 306) {
            if (exprLexer.lookAhead(1) == null) {
                exprLexer.nextToken();
                return new RootExpr();
            }
            bl = true;
        } else {
            bl = token.type == 307;
        }
        int n = 0;
        boolean bl2 = false;
        while (exprLexer.hasMoreTokens() && !bl2) {
            token = exprLexer.nextToken();
            if (ExprLexer.isBinaryOp(token)) {
                exprLexer.pushBack();
                break;
            }
            switch (token.type) {
                case 2: 
                case 4: 
                case 6: 
                case 308: {
                    exprLexer.pushBack();
                    bl2 = true;
                    break;
                }
                case 306: {
                    n = 2;
                    break;
                }
                case 307: {
                    n = 1;
                    break;
                }
                default: {
                    exprLexer.pushBack();
                    FilterBase filterBase = null;
                    filterBase = ExpressionParser.isLocationStepToken(token) ? ExpressionParser.createLocationStep(exprLexer) : ExpressionParser.createFilterExpr(exprLexer);
                    filterBase.setAncestryOp(n);
                    pathExpr.add(filterBase);
                    n = 0;
                    break;
                }
            }
        }
        return pathExpr;
    }

    public static PathExpr createPathExpr(String string) throws InvalidExprException {
        return ExpressionParser.createPathExpr(new ExprLexer(string));
    }

    private static PrimaryExpr createPrimaryExpr(ExprLexer exprLexer) throws InvalidExprException {
        PrimaryExpr primaryExpr = null;
        if (!exprLexer.hasMoreTokens()) {
            ExpressionParser.missingExpr(exprLexer.toString(), null);
        }
        Token token = exprLexer.nextToken();
        switch (token.type) {
            case 1: {
                primaryExpr = new PrimaryExpr(1);
                primaryExpr.setExpr(ExpressionParser.createExpr(exprLexer));
                token = exprLexer.nextToken();
                if (token.type == 2) break;
                ExpressionParser.unexpectedToken(exprLexer.toString(), token);
                break;
            }
            case 801: {
                primaryExpr = new PrimaryExpr(0);
                primaryExpr.setLiteral(token.value);
                break;
            }
            case 701: {
                primaryExpr = new PrimaryExpr(2);
                primaryExpr.setLiteral(token.value);
                break;
            }
            case 501: {
                String string = token.value;
                List list = ExpressionParser.parseParams(exprLexer);
                FunctionCall functionCall = ExpressionParser.createFunctionCall(string, list);
                primaryExpr = new PrimaryExpr(4);
                primaryExpr.setExpr(functionCall);
                break;
            }
            case 401: {
                try {
                    Double d = Double.valueOf(token.value);
                    primaryExpr = new PrimaryExpr(3);
                    primaryExpr.setNumber(d);
                }
                catch (NumberFormatException numberFormatException) {
                    primaryExpr = new PrimaryExpr(2);
                    primaryExpr.setLiteral(token.value);
                }
                break;
            }
        }
        if (primaryExpr == null) {
            throw new InvalidExprException("Invalid PrimaryExpr: " + exprLexer.toString() + " ->{" + token.value + "}");
        }
        return primaryExpr;
    }

    public static SelectExpr createSelectExpr(String string) throws InvalidExprException {
        SelectExpr selectExpr = new SelectExpr();
        selectExpr.setUnionExpr(ExpressionParser.createUnionExpr(string));
        return selectExpr;
    }

    public static StringExpr createStringExpr(String string) throws InvalidExprException {
        return new StringExpr(string);
    }

    private static UnionExpr createUnionExpr(ExprLexer exprLexer) throws InvalidExprException {
        UnionExpr unionExpr = new UnionExpr();
        boolean bl = false;
        block4: while (exprLexer.hasMoreTokens() && !bl) {
            Token token = exprLexer.nextToken();
            if (ExprLexer.isBinaryOp(token)) {
                exprLexer.pushBack();
                break;
            }
            switch (token.type) {
                case 2: 
                case 4: {
                    exprLexer.pushBack();
                    bl = true;
                    break;
                }
                case 308: {
                    if (unionExpr.size() != 0) continue block4;
                    throw new InvalidExprException();
                }
                default: {
                    exprLexer.pushBack();
                    unionExpr.add(ExpressionParser.createPathExpr(exprLexer));
                    break;
                }
            }
        }
        return unionExpr;
    }

    public static UnionExpr createUnionExpr(String string) throws InvalidExprException {
        return ExpressionParser.createUnionExpr(new ExprLexer(string));
    }

    private static boolean hasGreaterPrecedence(Token token, Token token2) {
        if (ExprLexer.isMultiplicativeOp(token)) {
            return !ExprLexer.isMultiplicativeOp(token2);
        }
        if (ExprLexer.isAdditiveOp(token)) {
            if (ExprLexer.isAdditiveOp(token2)) {
                return false;
            }
            return ExprLexer.isMultiplicativeOp(token2) ^ true;
        }
        if (ExprLexer.isRelationalOp(token)) {
            if (ExprLexer.isRelationalOp(token2)) {
                return false;
            }
            if (ExprLexer.isAdditiveOp(token2)) {
                return false;
            }
            return ExprLexer.isMultiplicativeOp(token2) ^ true;
        }
        if (ExprLexer.isEqualityOp(token)) {
            if (ExprLexer.isEqualityOp(token2)) {
                return false;
            }
            if (ExprLexer.isRelationalOp(token2)) {
                return false;
            }
            if (ExprLexer.isAdditiveOp(token2)) {
                return false;
            }
            return ExprLexer.isMultiplicativeOp(token2) ^ true;
        }
        if (token.type == 301) {
            if (token2.type == 301) {
                return false;
            }
            return token2.type == 302;
        }
        return token2.type != 302;
    }

    public static boolean isAxisIdentifierToken(Token token) {
        if (token == null) {
            return false;
        }
        switch (token.type) {
            case 601: 
            case 602: 
            case 603: 
            case 604: 
            case 605: 
            case 606: 
            case 607: 
            case 608: 
            case 609: 
            case 610: 
            case 611: 
            case 612: {
                return true;
            }
        }
        return false;
    }

    public static boolean isLocationStepToken(Token token) {
        if (token == null) {
            return false;
        }
        if (ExpressionParser.isAxisIdentifierToken(token)) {
            return true;
        }
        return ExpressionParser.isNodeTypeToken(token);
    }

    public static boolean isNodeTypeToken(Token token) {
        if (token == null) {
            return false;
        }
        switch (token.type) {
            case 7: 
            case 101: 
            case 102: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 802: 
            case 803: {
                return true;
            }
        }
        return false;
    }

    public static void main(String[] stringArray) throws InvalidExprException {
        String[] stringArray2 = new String[]{"//pi()", "cellphone.e-catalog", "//elementA/elementB", "../elementA[@name=$name][@type='foo']", "elementA", "elementA | elementB", "element-A | element-B | element-C", "element-A[@attr and (not(position() = 1))]"};
        String[] stringArray3 = new String[]{"position() mod 2 = 0", "(position() mod 2) = 0", "count((//@name)[1])"};
        System.out.println("UnionExpr Tests\n");
        int n = 0;
        while (n < stringArray2.length) {
            System.out.println("Test:   " + stringArray2[n]);
            System.out.print("Result: ");
            System.out.println(ExpressionParser.createUnionExpr(stringArray2[n]));
            ++n;
        }
        System.out.println();
        System.out.println("Expr Tests\n");
        int n2 = 0;
        while (n2 < stringArray3.length) {
            System.out.println("Test:   " + stringArray3[n2]);
            System.out.print("Result: ");
            System.out.println(ExpressionParser.createExpr(stringArray3[n2]));
            ++n2;
        }
    }

    private static void missingExpr(String string, Token token) throws InvalidExprException {
        StringBuffer stringBuffer = new StringBuffer(INVALID_EXPR);
        stringBuffer.append(string);
        stringBuffer.append("; '");
        if (token != null) {
            stringBuffer.append(token.value);
        }
        stringBuffer.append("' -> missing remainder of expression.");
        throw new InvalidExprException(stringBuffer.toString());
    }

    private static List parseParams(ExprLexer exprLexer) throws InvalidExprException {
        List list = new List();
        Token token = exprLexer.nextToken();
        if (token.type != 1) {
            ExpressionParser.missingExpr(exprLexer.toString(), token);
        }
        while (true) {
            if (!exprLexer.hasMoreTokens()) {
                ExpressionParser.missingExpr(exprLexer.toString(), token);
            }
            token = exprLexer.lookAhead(0);
            if (token.type == 2) {
                exprLexer.advance(1);
                break;
            }
            list.add(ExpressionParser.createExpr(exprLexer));
            token = exprLexer.nextToken();
            if (token.type == 2) break;
            if (token.type == 6) continue;
            ExpressionParser.unexpectedToken(exprLexer.toString(), token);
        }
        return list;
    }

    private static void parsePredicates(FilterBase filterBase, ExprLexer exprLexer) throws InvalidExprException {
        while (exprLexer.hasMoreTokens() && exprLexer.lookAhead((int)0).type == 3) {
            exprLexer.nextToken();
            Expr expr = ExpressionParser.createExpr(exprLexer);
            filterBase.addPredicate(expr);
            Token token = exprLexer.nextToken();
            if (token != null && token.type == 4) continue;
            ExpressionParser.unexpectedToken(exprLexer.toString(), token);
        }
    }

    private static void unexpectedToken(String string, Token token) throws InvalidExprException {
        StringBuffer stringBuffer = new StringBuffer(INVALID_EXPR);
        stringBuffer.append(string);
        stringBuffer.append("; '");
        if (token != null) {
            stringBuffer.append(token.value);
        } else {
            stringBuffer.append("NULL");
        }
        stringBuffer.append("' is unexpected.");
        throw new InvalidExprException(stringBuffer.toString());
    }
}

