/*
 * Decompiled with CFR 0.152.
 */
package com.kvisco.xsl;

import com.kvisco.util.List;
import com.kvisco.xsl.Expr;
import com.kvisco.xsl.ExprResult;
import com.kvisco.xsl.InvalidExprException;
import com.kvisco.xsl.MatchExpr;
import com.kvisco.xsl.NodeSet;
import com.kvisco.xsl.PathExpr;
import com.kvisco.xsl.ProcessorState;
import org.w3c.dom.Node;

class UnionExpr
extends List
implements Expr,
MatchExpr {
    protected UnionExpr() {
    }

    public void add(PathExpr pathExpr) {
        super.add(pathExpr);
    }

    public void add(PathExpr pathExpr, int n) {
        super.add(n, pathExpr);
    }

    public ExprResult evaluate(Node node, ProcessorState processorState) throws InvalidExprException {
        NodeSet nodeSet = new NodeSet();
        int n = 0;
        while (n < this.size()) {
            PathExpr pathExpr = (PathExpr)this.get(n);
            NodeSet nodeSet2 = (NodeSet)pathExpr.evaluate(node, processorState);
            nodeSet.add(nodeSet2);
            ++n;
        }
        return nodeSet;
    }

    public short getExprType() {
        return 2;
    }

    public PathExpr getMatchingExpr(Node node, Node node2, ProcessorState processorState) throws InvalidExprException {
        PathExpr pathExpr = null;
        int n = 0;
        while (n < this.size()) {
            PathExpr pathExpr2 = (PathExpr)this.get(n);
            if (pathExpr2.matches(node, node2, processorState)) {
                if (pathExpr == null) {
                    pathExpr = pathExpr2;
                } else if (pathExpr2.getDefaultPriority() > pathExpr.getDefaultPriority()) {
                    pathExpr = pathExpr2;
                }
            }
            ++n;
        }
        return pathExpr;
    }

    public boolean matches(Node node, Node node2, ProcessorState processorState) throws InvalidExprException {
        return this.getMatchingExpr(node, node2, processorState) != null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.size()) {
            if (n != 0) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append(((PathExpr)this.get(n)).toString());
            ++n;
        }
        return stringBuffer.toString();
    }
}

