/*
 * (C) Copyright Keith Visco 1999  All rights reserved.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * The Copyright owner will not be liable for any damages suffered by
 * you as a result of using the Program. In no event will the Copyright
 * owner be liable for any special, indirect or consequential damages or
 * lost profits even if the Copyright owner has been advised of the
 * possibility of their occurrence.
 */

package com.kvisco.xsl.functions;
import com.kvisco.xsl.*;
import com.kvisco.util.List;
import org.w3c.dom.*;

/**
 * A implementation of the "starts-with" function call
 * @author <a href="mailto:kvisco@ziplink.net">Keith Visco</a>
**/
public class LangFunctionCall extends FunctionCall {
    
    /**
     * Creates a new Lang FunctionCall
    **/
    public LangFunctionCall() {
        super(Names.LANG_FN);
    } //-- LangFunctionCall
    
    /**
     * Evalutes this FunctionCall using the given Node as
     * the context. This method will always return a BooleanResult
    **/
    public ExprResult evaluate(Node context, ProcessorState ps) 
        throws InvalidExprException
    {
        List params = getParameterList();
        
        if (params.size() != 1)
            throw new InvalidExprException(INVALID_NUMBER_PARAMS+this);
            
        Expr expr = (Expr)params.get(0);
        
        
        StringResult sResult = 
            StringExpr.toStringResult(expr.evaluate(context, ps));
            
        String test = sResult.toString();
        String lang = getLangAttr(context);
        if (lang == null) return BooleanResult.FALSE_RESULT;
        
        if (lang.equalsIgnoreCase(test)) 
            return BooleanResult.TRUE_RESULT;
            
        int idx = lang.indexOf('-');
        
        if (idx >= 0) {
            lang = lang.substring(0, idx);
            if (lang.equalsIgnoreCase(test)) 
                return BooleanResult.TRUE_RESULT;
        }
        return BooleanResult.FALSE_RESULT;
    } //-- evaluate
    
    private String getLangAttr(Node context) {
        
        if (context == null) return null;
        
        Node node = context;
        if (context.getNodeType() != Node.ELEMENT_NODE)
            node = context.getParentNode();
            
        String langAttr = null;
        
        while (node != null) {
            if (node.getNodeType() != Node.ELEMENT_NODE) break;
            
            langAttr = ((Element)node).getAttribute(Names.XMLLANG_ATTR);
            if ((langAttr != null) && (langAttr.length() > 0))
                return langAttr;
                
            node = node.getParentNode();
        }
        
        return langAttr;
    } //-- getLangAttr
    
} //-- LangFunctionCall

