/*
  Copyright (C) 1997,1998,1999  Dimitrios P. Bouras

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   For author contact information, look in the README file.
*/

/* Callbacks */

void doInstanceCheck(FL_OBJECT *, long);

void doConnect(FL_OBJECT *, long);
void doInterrupt(FL_OBJECT *, long);
void doDisconnect(FL_OBJECT *, long);
void doQuit(FL_OBJECT *, long);
void doOptions(FL_OBJECT *, long);
void doHelp(FL_OBJECT *, long);
void doISPDropChoice(FL_OBJECT *, long);
void doStartupTip(FL_OBJECT *, long);

void doTelNoInput(FL_OBJECT *, long);
void doAccountInput(FL_OBJECT *, long);
void doPasswdInput(FL_OBJECT *, long);
void doUNInput(FL_OBJECT *, long);
void doRemoteInput(FL_OBJECT *, long);
void doAuthPAPButton(FL_OBJECT *, long);
void doAuthNoneButton(FL_OBJECT *, long);
void doAuthPAPSButton(FL_OBJECT *, long);
void doAuthCHAPSButton(FL_OBJECT *, long);
void doISPPick(FL_OBJECT *, long);
void doISPPickNEdit(FL_OBJECT *, long);
void doAccountInfoAdd(FL_OBJECT *, long);
void doAccountInfoDelete(FL_OBJECT *, long);
void doAccountInfoCopy(FL_OBJECT *, long);
void doAccountInfoPaste(FL_OBJECT *, long);
void doISPDefault(FL_OBJECT *, long);
void doISPAutoDial(FL_OBJECT *, long);
void doAutoRedial(FL_OBJECT *, long);
void doAccountOK(FL_OBJECT *, long);
void doAccountCancel(FL_OBJECT *, long);
void doAccountTip(FL_OBJECT *, long);

void doRetryInput(FL_OBJECT *, long);
void doDelayInput(FL_OBJECT *, long);
void doCBYesButton(FL_OBJECT *, long);
void doCBNoButton(FL_OBJECT *, long);
void doCBOptions(FL_OBJECT *, long);
void doCNWaitInput(FL_OBJECT *, long);
void doCBInfoTip(FL_OBJECT *, long);
void doRBYesButton(FL_OBJECT *, long);
void doRBNoButton(FL_OBJECT *, long);
void doTTYesButton(FL_OBJECT *, long);
void doTTNoButton(FL_OBJECT *, long);
void doColumnsInput(FL_OBJECT *, long);
void doRowsInput(FL_OBJECT *, long);
void doExpectInput(FL_OBJECT *, long);
void doSendInput(FL_OBJECT *, long);
void doDialOK(FL_OBJECT *, long);
void doDialCancel(FL_OBJECT *, long);

void doCBInfoOK(FL_OBJECT *, long);
void doCBInfoCancel(FL_OBJECT *, long);
void doCBDelayInput(FL_OBJECT *, long);
void doCBExpectInput(FL_OBJECT *, long);
void doCBSendInput(FL_OBJECT *, long);
void doCBColumnsInput(FL_OBJECT *, long);
void doCBRowsInput(FL_OBJECT *, long);
void doCBTelInput(FL_OBJECT *, long);
void doLTScriptedButton(FL_OBJECT *, long);
void doLTTerminalButton(FL_OBJECT *, long);
void doLTRASButton(FL_OBJECT *, long);

void doISPNameInput(FL_OBJECT *, long);
void doISPNameEditOK(FL_OBJECT *, long);
void doISPNameEditCancel(FL_OBJECT *, long);

void doExitOK(FL_OBJECT *, long);
void doExitCancel(FL_OBJECT *, long);

void doAboutOK(FL_OBJECT *, long);
void doHelpInfoOK(FL_OBJECT *, long);
void doStatsInfoOK(FL_OBJECT *, long);

void doCommInfoOK(FL_OBJECT *, long);
void doCommInfoCancel(FL_OBJECT *, long);
void doDeviceInput(FL_OBJECT *, long);
void doModemInitInput(FL_OBJECT *, long);
void doModemResetInput(FL_OBJECT *, long);
void doModemConnectInput(FL_OBJECT *, long);
void doToneButton(FL_OBJECT *, long);
void doPulseButton(FL_OBJECT *, long);
void doISDNButton(FL_OBJECT *, long);
void doModemDialInput(FL_OBJECT *, long);
void doSWCBSDButton(FL_OBJECT *, long);
void doSWCOffButton(FL_OBJECT *, long);
void doSWCDeflateButton(FL_OBJECT *, long);
void doSpeedButton(FL_OBJECT *, long);
void doSWCInput(FL_OBJECT *, long);
void doAsyncmapInput(FL_OBJECT *, long);
void doEscapeYesButton(FL_OBJECT *, long);
void doEscapeNoButton(FL_OBJECT *, long);
void doEscapeInput(FL_OBJECT *, long);
void doHWButton(FL_OBJECT *, long);
void doSWButton(FL_OBJECT *, long);
void doCommInfoTip(FL_OBJECT *, long);

void doLocalIPInput(FL_OBJECT *, long);
void doALYesButton(FL_OBJECT *, long);
void doALNoButton(FL_OBJECT *, long);
void doRemoteIPInput(FL_OBJECT *, long);
void doARYesButton(FL_OBJECT *, long);
void doARNoButton(FL_OBJECT *, long);
void doTcpipInfoOK(FL_OBJECT *, long);
void doTcpipInfoCancel(FL_OBJECT *, long);
void doDRYesButton(FL_OBJECT *, long);
void doDRNoButton(FL_OBJECT *, long);
void doRemoteNMInput(FL_OBJECT *, long);
void doMTUInput(FL_OBJECT *, long);
void doMRUInput(FL_OBJECT *, long);
void doUDYesButton(FL_OBJECT *, long);
void doUDNoButton(FL_OBJECT *, long);
void doPDNSInput(FL_OBJECT *, long);
void doSDNSInput(FL_OBJECT *, long);
void doTcpipInfoTip(FL_OBJECT *, long);

void doOLTimeButton(FL_OBJECT *, long);
void doOLChargeButton(FL_OBJECT *, long);
void doLogNoButton(FL_OBJECT *, long);
void doLogMonthButton(FL_OBJECT *, long);
void doLogWeekButton(FL_OBJECT *, long);
void doLogBiMonthButton(FL_OBJECT *, long);
void doLogInfoOK(FL_OBJECT *, long);
void doLogInfoCancel(FL_OBJECT *, long);
void doPttDropChoice(FL_OBJECT *, long);
void doZoneDropChoice(FL_OBJECT *, long);
void doLogInfoPTTEdit(FL_OBJECT *, long);
void doLogInfoPTTAdd(FL_OBJECT *, long);
void doLogInfoPTTRemove(FL_OBJECT *, long);

void doPttEditOK(FL_OBJECT *, long);
void doPttEditCancel(FL_OBJECT *, long);
void doPttEditHelp(FL_OBJECT *, long);
void doCUnitButton(FL_OBJECT *, long);
void doCMinuteButton(FL_OBJECT *, long);
void doCSecondsButton(FL_OBJECT *, long);
void doCPLButton(FL_OBJECT *, long);
void doCPRButton(FL_OBJECT *, long);
void doMLLButton(FL_OBJECT *, long);
void doMLNButton(FL_OBJECT *, long);
void doRuleCounter(FL_OBJECT *, long);
void doPttNameInput(FL_OBJECT *, long);
void doZonesInput(FL_OBJECT *, long);
void doCategoriesInput(FL_OBJECT *, long);
void doMinUnitsInput(FL_OBJECT *, long);
void doMinCostInput(FL_OBJECT *, long);
void doCSecondsInput(FL_OBJECT *, long);
void doUnitPriceInput(FL_OBJECT *, long);
void doCurrencyInput(FL_OBJECT *, long);
void doDecimalsInput(FL_OBJECT *, long);
void doBaseChargeInput(FL_OBJECT *, long);
void doRuleChargeInput(FL_OBJECT *, long);
void doRelDateInput(FL_OBJECT *, long);
void doRSInput(FL_OBJECT *, long);
void doREInput(FL_OBJECT *, long);
void doZEDYesButton(FL_OBJECT *, long);
void doZEDNoButton(FL_OBJECT *, long);
void doRDYesButton(FL_OBJECT *, long);
void doRDNoButton(FL_OBJECT *, long);
void doTButton(FL_OBJECT *, long);
void doZMLYesButton(FL_OBJECT *, long);
void doZMLNoButton(FL_OBJECT *, long);
void doMLSecondsInput(FL_OBJECT *, long);
void doDiscountInput(FL_OBJECT *, long);
void doZSInput(FL_OBJECT *, long);
void doZEInput(FL_OBJECT *, long);
void doRDInput(FL_OBJECT *, long);
void doRDEInput(FL_OBJECT *, long);
void doZonePick(FL_OBJECT *, long);
void doZonePickNEdit(FL_OBJECT *, long);

void doPTTNameInput(FL_OBJECT *, long);
void doPTTNameEditOK(FL_OBJECT *, long);
void doPTTNameEditCancel(FL_OBJECT *, long);

void doZoneNameInput(FL_OBJECT *, long);
void doZoneNameEditOK(FL_OBJECT *, long);
void doZoneNameEditCancel(FL_OBJECT *, long);

void doPppdPathInput(FL_OBJECT *, long);
void doEnvInfoOK(FL_OBJECT *, long);
void doEnvInfoCancel(FL_OBJECT *, long);
void doRunPathInput(FL_OBJECT *, long);
void doChatPathInput(FL_OBJECT *, long);
void doXispUtilsPathInput(FL_OBJECT *, long);
void doPipePathInput(FL_OBJECT *, long);
void doPppdDefault(FL_OBJECT *, long);
void doRunDefault(FL_OBJECT *, long);
void doChatDefault(FL_OBJECT *, long);
void doXispUtilsDefault(FL_OBJECT *, long);
void doPipeDefault(FL_OBJECT *, long);
void doEnvInfoTip(FL_OBJECT *, long);

/* Forms and Objects */

#define OPTIONS_ACCOUNT 1
#define OPTIONS_DIALING 2
#define OPTIONS_COMM    3
#define OPTIONS_TCPIP   4
#define OPTIONS_PATHS   5
#define LOGGING_OPTIONS 1
#define LOGGING_STATS   2
#define HELP_ABOUT      1
#define HELP_GENERAL    2

typedef struct {
	FL_FORM *instanceCheck;
	void *vdata;
	char *cdata;
	long  ldata;
	FL_OBJECT *msgString;
	FL_OBJECT *instanceCheckContinue;
	FL_OBJECT *instanceCheckAbort;
} FD_instanceCheck;
FD_instanceCheck * create_form_instanceCheck(void);

typedef struct {
	FL_FORM *topFrame;
	void *vdata;
	char *cdata;
	long ldata;
	FL_OBJECT *conButton;
	FL_OBJECT *intButton;
	FL_OBJECT *disButton;
	FL_OBJECT *quitButton;
	FL_OBJECT *optMenu;
	FL_OBJECT *logMenu;
	FL_OBJECT *hlpMenu;
	FL_OBJECT *lstBrowser;
	FL_OBJECT *logDescr;
	FL_OBJECT *logText;
	FL_OBJECT *speedText;
	FL_OBJECT *IPText;
	FL_OBJECT *statusText;
	FL_OBJECT *topIcon;
	FL_OBJECT *ISPDropChoice;
	FL_OBJECT *tipTimer;
} FD_topFrame;
FD_topFrame * create_form_topFrame(void);

typedef struct {
	FL_FORM *accountInfo;
	void *vdata;
	char *cdata;
	long  ldata;
	FL_OBJECT *telInput;
	FL_OBJECT *accInput;
	FL_OBJECT *pswInput;
	FL_OBJECT *accOK;
	FL_OBJECT *accCancel;
	FL_OBJECT *authType;
	FL_OBJECT *authPAPButton;
	FL_OBJECT *authNoneButton;
	FL_OBJECT *authPAPSButton;
	FL_OBJECT *authCHAPSButton;
	FL_OBJECT *UNInput;
	FL_OBJECT *remoteInput;
	FL_OBJECT *ISPBrowser;
	FL_OBJECT *accountInfoAdd;
	FL_OBJECT *accountInfoDelete;
	FL_OBJECT *accountInfoCopy;
	FL_OBJECT *accountInfoPaste;
	FL_OBJECT *ISPDefault;
	FL_OBJECT *ISPAutoDial;
	FL_OBJECT *autoRedial;
	FL_OBJECT *tipTimer;
} FD_accountInfo;
FD_accountInfo * create_form_accountInfo(void);

typedef struct {
	FL_FORM *renameISP;
	void *vdata;
	char *cdata;
	long ldata;
	FL_OBJECT *ISPNameInput;
	FL_OBJECT *ISPNameEditOK;
	FL_OBJECT *ISPNameEditCancel;
} FD_renameISP;
FD_renameISP * create_form_renameISP(void);

typedef struct {
	FL_FORM *dialInfo;
	void *vdata;
	char *cdata;
	long ldata;
	FL_OBJECT *rtrInput;
	FL_OBJECT *dlyInput;
	FL_OBJECT *CNWaitInput;
	FL_OBJECT *TTGroup;
	FL_OBJECT *TTYesButton;
	FL_OBJECT *TTNoButton;
	FL_OBJECT *RBGroup;
	FL_OBJECT *RBYesButton;
	FL_OBJECT *RBNoButton;
	FL_OBJECT *CBGroup;
	FL_OBJECT *CBYesButton;
	FL_OBJECT *CBNoButton;
	FL_OBJECT *CBOptions;
	FL_OBJECT *TSGroup;
	FL_OBJECT *rowsInput;
	FL_OBJECT *columnsInput;
	FL_OBJECT *ALGroup;
	FL_OBJECT *expectInput;
	FL_OBJECT *sendInput;
	FL_OBJECT *dialOK;
	FL_OBJECT *dialCancel;
	FL_OBJECT *tipTimer;
} FD_dialInfo;
FD_dialInfo * create_form_dialInfo(void);

typedef struct {
	FL_FORM *CBInfo;
	void *vdata;
	char *cdata;
	long  ldata;
	FL_OBJECT *CBInfoOK;
	FL_OBJECT *CBInfoCancel;
	FL_OBJECT *CBdlyInput;
	FL_OBJECT *LTGroup;
	FL_OBJECT *LTScriptedButton;
	FL_OBJECT *LTTerminalButton;
	FL_OBJECT *LTRASButton;
	FL_OBJECT *ALGroup;
	FL_OBJECT *CBExpectInput;
	FL_OBJECT *CBSendInput;
	FL_OBJECT *TSGroup;
	FL_OBJECT *columnsInput;
	FL_OBJECT *rowsInput;
	FL_OBJECT *CBTelInput;
	FL_OBJECT *tipTimer;
} FD_CBInfo;
FD_CBInfo * create_form_CBInfo(void);

typedef struct {
	void *vdata;
	char *cdata;
	long ldata;
	FL_FORM *aboutInfo;
	FL_OBJECT *verString;
	FL_OBJECT *aboutOK;
} FD_aboutInfo;
FD_aboutInfo * create_form_aboutInfo(void);

typedef struct {
	FL_FORM *exitDialog;
	void *vdata;
	char *cdata;
	long ldata;
	FL_OBJECT *exitIcon;
	FL_OBJECT *exitOK;
	FL_OBJECT *exitCancel;
} FD_exitDialog;
FD_exitDialog * create_form_exitDialog(void);

typedef struct {
	FL_FORM *helpInfo;
	void *vdata;
	char *cdata;
	long ldata;
	FL_OBJECT *helpBrowser;
	FL_OBJECT *helpInfoOK;
} FD_helpInfo;
FD_helpInfo * create_form_helpInfo(void);

typedef struct {
	FL_FORM *alertMessage;
	void *vdata;
	char *cdata;
	long  ldata;
	FL_OBJECT *alertMessageDismiss;
	FL_OBJECT *alertMessageStr;
	FL_OBJECT *noMoreHints;
} FD_alertMessage;
FD_alertMessage * create_form_alertMessage(void);

typedef struct {
	FL_FORM *commInfo;
	void *vdata;
	char *cdata;
	long ldata;
	FL_OBJECT *commInfoOK;
	FL_OBJECT *commInfoCancel;
	FL_OBJECT *modemInitInput;
	FL_OBJECT *modemResetInput;
	FL_OBJECT *modemConnectInput;
	FL_OBJECT *modemDialType;
	FL_OBJECT *toneButton;
	FL_OBJECT *pulseButton;
	FL_OBJECT *ISDNButton;
	FL_OBJECT *modemDialInput;
	FL_OBJECT *SWCType;
	FL_OBJECT *SWCBSDButton;
	FL_OBJECT *SWCDeflateButton;
	FL_OBJECT *SWCOffButton;
	FL_OBJECT *deviceInput;
	FL_OBJECT *modemSpeedType;
	FL_OBJECT *speedButton[8];
	FL_OBJECT *SWCInput;
	FL_OBJECT *asyncmapInput;
	FL_OBJECT *escapeType;
	FL_OBJECT *escapeYesButton;
	FL_OBJECT *escapeNoButton;
	FL_OBJECT *escapeInput;
	FL_OBJECT *flowCtrlType;
	FL_OBJECT *HWButton;
	FL_OBJECT *SWButton;
	FL_OBJECT *tipTimer;
} FD_commInfo;
FD_commInfo * create_form_commInfo(void);

typedef struct {
	FL_FORM *tcpipInfo;
	void *vdata;
	char *cdata;
	long ldata;
	FL_OBJECT *localIPInput;
	FL_OBJECT *ALTypeGroup;
	FL_OBJECT *ALYesButton;
	FL_OBJECT *ALNoButton;
	FL_OBJECT *remoteIPInput;
	FL_OBJECT *ARTypeGroup;
	FL_OBJECT *ARYesButton;
	FL_OBJECT *ARNoButton;
	FL_OBJECT *tcpipInfoOK;
	FL_OBJECT *tcpipInfoCancel;
	FL_OBJECT *DRTypeGroup;
	FL_OBJECT *DRYesButton;
	FL_OBJECT *DRNoButton;
	FL_OBJECT *UDTypeGroup;
	FL_OBJECT *UDYesButton;
	FL_OBJECT *UDNoButton;
	FL_OBJECT *NMInput;
	FL_OBJECT *MTUInput;
	FL_OBJECT *MRUInput;
	FL_OBJECT *pDNSInput;
	FL_OBJECT *sDNSInput;
	FL_OBJECT *tipTimer;
} FD_tcpipInfo;
FD_tcpipInfo * create_form_tcpipInfo(void);

typedef struct {
	FL_FORM *logInfo;
	void *vdata;
	char *cdata;
	long ldata;
	FL_OBJECT *OLGroup;
	FL_OBJECT *OLTimeButton;
	FL_OBJECT *OLChargeButton;
	FL_OBJECT *logGroup;
	FL_OBJECT *logNoButton;
	FL_OBJECT *logMonthButton;
	FL_OBJECT *logWeekButton;
	FL_OBJECT *logBiMonthButton;
	FL_OBJECT *logInfoOK;
	FL_OBJECT *logInfoCancel;
	FL_OBJECT *pttDropChoice;
	FL_OBJECT *zoneDropChoice;
	FL_OBJECT *costBrowser;
	FL_OBJECT *LogInfoPTTEdit;
	FL_OBJECT *LogInfoPTTAdd;
	FL_OBJECT *logInfoPTTRemove;
} FD_logInfo;
FD_logInfo * create_form_logInfo(void);

typedef struct {
	FL_FORM *statInfo;
	void *vdata;
	char *cdata;
	long ldata;
	FL_OBJECT *statsBrowser;
	FL_OBJECT *statsChart;
	FL_OBJECT *pieChart;
	FL_OBJECT *statInfoOK;
} FD_statInfo;
FD_statInfo * create_form_statInfo(void);

typedef struct {
	FL_FORM *pttEditor;
	void *vdata;
	char *cdata;
	long  ldata;
	FL_OBJECT *zonePick;
	FL_OBJECT *defaultTariffUnits;
	FL_OBJECT *pttEditOK;
	FL_OBJECT *pttEditCancel;
	FL_OBJECT *ruleTariffUnits;
	FL_OBJECT *pttEditHelp;
	FL_OBJECT *CMType;
	FL_OBJECT *CUnitButton;
	FL_OBJECT *CMinuteButton;
	FL_OBJECT *CSecondsButton;
	FL_OBJECT *CPType;
	FL_OBJECT *CPLButton;
	FL_OBJECT *CPRButton;
	FL_OBJECT *MCType;
	FL_OBJECT *MLLButton;
	FL_OBJECT *MLNButton;
	FL_OBJECT *ruleCounter;
	FL_OBJECT *pttNameInput;
	FL_OBJECT *zonesInput;
	FL_OBJECT *categoriesInput;
	FL_OBJECT *minUnitsInput;
	FL_OBJECT *minCostInput;
	FL_OBJECT *CSecondsInput;
	FL_OBJECT *unitPriceInput;
	FL_OBJECT *currencyInput;
	FL_OBJECT *decimalsInput;
	FL_OBJECT *baseChargeInput;
	FL_OBJECT *ruleChargeInput;
	FL_OBJECT *relDateInput;
	FL_OBJECT *RSHInput;
	FL_OBJECT *RSMInput;
	FL_OBJECT *RSSInput;
	FL_OBJECT *REHInput;
	FL_OBJECT *REMInput;
	FL_OBJECT *RESInput;
	FL_OBJECT *ZEDType;
	FL_OBJECT *ZEDYesButton;
	FL_OBJECT *ZEDNoButton;
	FL_OBJECT *RDStr;
	FL_OBJECT *REDType;
	FL_OBJECT *RDYesButton;
	FL_OBJECT *RDNoButton;
	FL_OBJECT *CTType;
	FL_OBJECT *TWDButton;
	FL_OBJECT *TSDButton;
	FL_OBJECT *THRButton;
	FL_OBJECT *TUDButton;
	FL_OBJECT *TWEButton;
	FL_OBJECT *THAButton;
	FL_OBJECT *TWDSButton;
	FL_OBJECT *TWESButton;
	FL_OBJECT *TAWButton;
	FL_OBJECT *ZMLStr;
	FL_OBJECT *ZMLType;
	FL_OBJECT *ZMLYesButton;
	FL_OBJECT *ZMLNoButton;
	FL_OBJECT *TimeChargeType;
	FL_OBJECT *MLSecondsInput;
	FL_OBJECT *discountInput;
	FL_OBJECT *DiscountType;
	FL_OBJECT *PCSymbol;
	FL_OBJECT *ZSHInput;
	FL_OBJECT *ZSMInput;
	FL_OBJECT *ZSSInput;
	FL_OBJECT *ZEHInput;
	FL_OBJECT *ZEMInput;
	FL_OBJECT *ZESInput;
	FL_OBJECT *ruleDateStr;
	FL_OBJECT *CalDateType;
	FL_OBJECT *RDMInput;
	FL_OBJECT *RDDInput;
	FL_OBJECT *EndDateType;
	FL_OBJECT *RDEMInput;
	FL_OBJECT *RDEDInput;
} FD_pttEditor;
FD_pttEditor * create_form_pttEditor(void);

typedef struct {
	FL_FORM *renamePTT;
	void *vdata;
	char *cdata;
	long  ldata;
	FL_OBJECT *PTTNameInput;
	FL_OBJECT *PTTNameEditOK;
	FL_OBJECT *PTTNameEditCancel;
} FD_renamePTT;
FD_renamePTT * create_form_renamePTT(void);

typedef struct {
	FL_FORM *renameZone;
	void *vdata;
	char *cdata;
	long  ldata;
	FL_OBJECT *zoneNameInput;
	FL_OBJECT *zoneNameEditOK;
	FL_OBJECT *zoneNameEditCancel;
} FD_renameZone;
FD_renameZone * create_form_renameZone(void);

typedef struct {
	FL_FORM *actionVerify;
	void *vdata;
	char *cdata;
	long  ldata;
	FL_OBJECT *actionVerifyNo;
	FL_OBJECT *actionVerifyYes;
	FL_OBJECT *actionVerifyStr;
} FD_actionVerify;
FD_actionVerify * create_form_actionVerify(void);

typedef struct {
	FL_FORM *envInfo;
	void *vdata;
	char *cdata;
	long  ldata;
	FL_OBJECT *pppdPathInput;
	FL_OBJECT *envInfoOK;
	FL_OBJECT *envInfoCancel;
	FL_OBJECT *runPathInput;
	FL_OBJECT *chatPathInput;
	FL_OBJECT *xispUtilsPathInput;
	FL_OBJECT *pipePathInput;
	FL_OBJECT *pppdDefault;
	FL_OBJECT *runDefault;
	FL_OBJECT *chatDefault;
	FL_OBJECT *xispUtilsDefault;
	FL_OBJECT *pipeDefault;
	FL_OBJECT *pppdStatus;
	FL_OBJECT *runStatus;
	FL_OBJECT *chatStatus;
	FL_OBJECT *utilsStatus;
	FL_OBJECT *tipTimer;
} FD_envInfo;
FD_envInfo * create_form_envInfo(void);

/* Other xISP defines */

#define BU_INTERVAL   2.0	/* check dialer output every 2 seconds */
#define CT_INTERVAL   5.0	/* update connection time every 5 seconds */
#define SP_INTERVAL  15.0	/* check link status every 15 seconds */
#define DIAL_WAIT    30.0	/* max wait seconds for xispdial to open pipe */
#define UD_WAIT      16.0	/* max wait for ip-up/-down output in pipe */
#ifdef XPMANIMATE
#define XPM_INTERVAL  0.3	/* XPM animation trigger interval */
#endif
#define HINT_TRIGGER  0.2	/* one-shot trigger interval for pop-up hints */

typedef struct {			/* the color structure */
	int r, g, b;
} color_t;

#define BGCOL_DEFAULT {79, 124, 156}	/* default form-background color */
#define BGCOL_STRING  "#4F7C9C"

#define DISCONNECTED 0		/* to specify xISP state */
#define DIALING      1
#define CONNECTED    2

#define EMPTY_TIME  "00:00:00"
#define EMPTY_IP    "---.---.---.---"
#define EMPTY_SPEED "--,---"

#define TIMER_CURSOR_WIDTH 17
#define TIMER_CURSOR_HEIGHT 19

