/* -*- mode: C++; tab-width: 4 -*- */
/* ================================================================================== */
/* Copyright (c) 1998-1999 3Com Corporation or its subsidiaries. All rights reserved. */
/* ================================================================================== */

#ifndef _BYTESWAPPING_H_
#define _BYTESWAPPING_H_

#if !defined (BYTESWAP)
#error "Must define BYTESWAP"
#endif

#include "EmulatorTypes.h"		// SysPktRPC2Type


/*
**	--------------------------------------------------------------------------------
**		Byte swapping
**	--------------------------------------------------------------------------------
*/

#define BYTE_SWAP_16(n)	((((unsigned short) n) >> 8) |	\
						 (((unsigned short) n) << 8))

#define BYTE_SWAP_32(n)	( (((unsigned long) n) << 24) |					\
						 ((((unsigned long) n) << 8) & 0x00FF0000) |	\
						 ((((unsigned long) n) >> 8) & 0x0000FF00) |	\
						  (((unsigned long) n) >> 24))


inline void Byteswap(bool&)
{
}

inline void Byteswap(char&)
{
}

inline void Byteswap(signed char&)
{
}

inline void Byteswap(unsigned char&)
{
}

inline void Byteswap(short& v)
{
	v = (short) BYTE_SWAP_16(v);
}

inline void Byteswap(unsigned short& v)
{
	v = (unsigned short) BYTE_SWAP_16(v);
}

inline void Byteswap(int& v)
{
	if (sizeof(int) == 4)
		v = (int) BYTE_SWAP_32(v);

	else if (sizeof(int) == 2)
		v = (int) BYTE_SWAP_16(v);
}

inline void Byteswap(unsigned int& v)
{
	if (sizeof(unsigned int) == 4)
		v = (unsigned int) BYTE_SWAP_32(v);

	else if (sizeof(unsigned int) == 2)
		v = (unsigned int) BYTE_SWAP_16(v);
}

inline void Byteswap(long& v)
{
	v = (long) BYTE_SWAP_32(v);
}

inline void Byteswap(unsigned long& v)
{
	v = (unsigned long) BYTE_SWAP_32(v);
}

template <class T>
inline void Byteswap(T*& v)
{
	v = (T*) BYTE_SWAP_32(v);
}

inline void Byteswap(WinHandle& v)
{
	v = (WinHandle) BYTE_SWAP_32(v);
}

inline void Byteswap(SysKernelInfoSelector& v)
{
	if (sizeof(SysKernelInfoSelector) == 4)
		v = (SysKernelInfoSelector) BYTE_SWAP_32(v);

	else if (sizeof(SysKernelInfoSelector) == 2)
		v = (SysKernelInfoSelector) BYTE_SWAP_16(v);
}

inline void Byteswap(enum events& v)
{
	if (sizeof(enum events) == 4)
		v = (enum events) BYTE_SWAP_32(v);

	else if (sizeof(enum events) == 2)
		v = (enum events) BYTE_SWAP_16(v);
}

void Byteswap (BreakpointType& p);
void Byteswap (CardHeaderType& p);
void Byteswap (DatabaseDirType& p);
void Byteswap (DatabaseHdrType& p);
void Byteswap (DmAccessType& p);
void Byteswap (DmOpenInfoType& p);
void Byteswap (DmSearchStateType& p);
void Byteswap (EventType& event);
void Byteswap (FieldAttrType& p);
void Byteswap (HwrDBallEZType&);
void Byteswap (HwrDBallType&);
void Byteswap (M68KRegsType& p);
void Byteswap (Mem1ChunkHeaderType& p);
void Byteswap (Mem1HeapHeaderType& p);
void Byteswap (Mem1MstrPtrTableType& p);
void Byteswap (Mem2HeapHeaderType& p);
void Byteswap (MemChunkHeaderType& p);
void Byteswap (MemHeapHeaderType& p);
void Byteswap (MemMstrPtrTableType& p);
void Byteswap (PenBtnInfoType& p);
void Byteswap (PointType& p);
void Byteswap (RecordListType& p);
void Byteswap (RecordEntryType& p);
void Byteswap (RectangleType& p);
void Byteswap (RsrcEntryType& p);
void Byteswap (SlkPktHeaderType& p);
void Byteswap (SlkPktFooterType& p);
void Byteswap (SysAppInfoType& p);
void Byteswap (SysKernelInfoType& p);
void Byteswap (SysNVParamsType& p);
void Byteswap (SysPktBodyType& p);
void Byteswap (SysPktChecksumType& p);			// --- response is same type
void Byteswap (SysPktCommCmdType& p);
void Byteswap (SysPktCommRspType& p);
void Byteswap (SysPktContinueCmdType& p);		// --- no response
void Byteswap (SysPktDbgBreakToggleCmdType& p);
void Byteswap (SysPktDbgBreakToggleRspType& p);
void Byteswap (sysPktExecFlashType& p);			// --- no response
void Byteswap (SysPktFindCmdType& p);
void Byteswap (SysPktFindRspType& p);
void Byteswap (SysPktFlashWriteType& p);		// --- response is same type
void Byteswap (SysPktGetBreakpointsCmdType& p);
void Byteswap (SysPktGetBreakpointsRspType& p);
void Byteswap (SysPktGetTrapBreaksCmdType& p);
void Byteswap (SysPktGetTrapBreaksRspType& p);
void Byteswap (SysPktGetTrapConditionsCmdType& p);
void Byteswap (SysPktGetTrapConditionsRspType& p);
void Byteswap (SysPktGremlinsCmdType&);			// --- no response
void Byteswap (SysPktReadMemCmdType& p);
void Byteswap (SysPktReadMemRspType& p);
void Byteswap (SysPktReadRegsCmdType& p);
void Byteswap (SysPktReadRegsRspType& p);
void Byteswap (SysPktRemoteMsgCmdType& p);		// --- no response
void Byteswap (SysPktRPCType& p);				// --- response is same type
void Byteswap (SysPktRPC2Type& p);				// --- response is same type
void Byteswap (SysPktRtnNameCmdType& p);
void Byteswap (SysPktRtnNameRspType& p);
void Byteswap (SysPktSetBreakpointsCmdType& p);
void Byteswap (SysPktSetBreakpointsRspType& p);
void Byteswap (SysPktSetTrapBreaksCmdType& p);
void Byteswap (SysPktSetTrapBreaksRspType& p);
void Byteswap (SysPktSetTrapConditionsCmdType& p);
void Byteswap (SysPktSetTrapConditionsRspType& p);
void Byteswap (SysPktStateCmdType& p);
void Byteswap (SysPktStateRspType& p);
void Byteswap (SysPktWriteRegsCmdType& p);
void Byteswap (SysPktWriteRegsRspType& p);
void Byteswap (SysPktWriteMemCmdType& p);
void Byteswap (SysPktWriteMemRspType& p);

void Byteswap (regstruct& r);
void Byteswap (struct flag_struct& r);

void Byteswap (SED1375RegsType& p);
void Byteswap (HwrJerryPLDType& p);

#if BYTESWAP

	template <class T>
	inline void Canonical(T& v)
	{
		Byteswap (v);
	}

#else

	template <class T>
	inline void Canonical(T&)
	{
	}

#endif


#if WORDSWAP_MEMORY

	inline void ByteswapWords (void* start, unsigned long length)
	{
		for (unsigned long ii = 0; ii < length / 2; ++ii)
		{
			unsigned short*	p = ((unsigned short*) start) + ii;
			unsigned char*	bp = (unsigned char*) p;
			*p = (((unsigned short) *bp) << 8) | (unsigned short) (*(bp + 1));
		}
	}

#else

	inline void ByteswapWords (void*, unsigned long)
	{
	}

#endif	// WORDSWAP_MEMORY

#endif /* _BYTESWAPPING_H_ */

