/* -*- mode: C++; tab-width: 4 -*- */
/* ================================================================================== */
/* Copyright (c) 1998-1999 3Com Corporation or its subsidiaries. All rights reserved. */
/* ================================================================================== */

#ifndef _PALM_H_
#define _PALM_H_

#include "PalmPack.h"

// Remap some types that also appear in the Mac headers.
#define ControlPtr	Palm_ControlPtr
#define ListPtr		Palm_ListPtr

// Defined in both CharAttr.h and ...\VC\Includes\xlocinfo.h
#undef _XA
#undef _XS
#undef _BB
#undef _CN
#undef _DI
#undef _LO
#undef _PU
#undef _SP
#undef _UP
#undef _XD

// From Pilot.h

	// From SysAll.h

		#include "Palm/Incs/Common.h"
		#include "Palm/Incs/System/SysTraps.h"
		#include "Palm/Incs/System/SystemMgr.h"
		//#include "Palm/Incs/System/DebugMgr.h"
		//#include "Palm/Incs/System/ErrorMgr.h"
		//#include "Palm/Incs/System/StringMgr.h"
		//#include "Palm/Incs/System/SysUtils.h"
		#include "Palm/Incs/System/MemoryMgr.h"
		#include "Palm/Incs/System/DataMgr.h"
		#include "Palm/Incs/System/FeatureMgr.h"

		#include "Palm/Incs/System/Preferences.h"
		//#include "Palm/Incs/System/Localize.h"
		//#include "Palm/Incs/System/TimeMgr.h"
		//#include "Palm/Incs/System/AlarmMgr.h"
		//#include "Palm/Incs/System/SoundMgr.h"
		//#include "Palm/Incs/System/Keyboard.h"
		//#include "Palm/Incs/System/GraffitiReference.h"
		//#include "Palm/Incs/System/AppLaunchCmd.h"


	// From UIAll.h

		#include "Palm/Incs/UI/UICommon.h"
		//#include "Palm/Incs/UI/Init.h"
		#include "Palm/Incs/UI/Rect.h"
		#include "Palm/Incs/UI/Font.h"
		//#include "Palm/Incs/UI/FontSelect.h"
		#include "Palm/Incs/UI/Window.h"
		#include "Palm/Incs/UI/Chars.h"
		//#include "Palm/Incs/UI/InsPoint.h"
		//#include "Palm/Incs/UI/GraffitiShift.h"
		#include "Palm/Incs/UI/Event.h"
		//#include "Palm/Incs/UI/ClipBoard.h"
		#include "Palm/Incs/UI/Control.h"
		#include "Palm/Incs/UI/Field.h"
		#include "Palm/Incs/UI/List.h"
		#include "Palm/Incs/UI/ScrollBar.h"
		#include "Palm/Incs/UI/Table.h"
		#include "Palm/Incs/UI/Form.h"
		//#include "Palm/Incs/UI/Menu.h"
		//#include "Palm/Incs/UI/Category.h"
		#include "Palm/Incs/UI/Find.h"
		//#include "Palm/Incs/UI/SelDay.h"
		//#include "Palm/Incs/UI/SelTime.h"
		//#include "Palm/Incs/UI/AboutBox.h"
		//#include "Palm/Incs/UI/PhoneLookup.h"

	#define	NON_PORTABLE
	#include "Palm/Incs/System/Globals.h"
	//#include "Palm/Incs/UI/UIGlobals.h"
	#undef NON_PORTABLE


// Additional bits we need

#include "Palm/Incs/System/KeyMgr.h"			// keyBitHard1
#include "Palm/Incs/System/NetMgr.h"
#include "Palm/Incs/System/PenMgr.h"			// PenScreenToRaw
#include "Palm/Incs/System/SysEvtMgr.h"			// EvtEnqueuePenPoint, EvtEnqueueKey
#include "Palm/Incs/System/SystemPkt.h"			// SysPktBodyType, etc.
												// (Be sure to include _before_ DebugPrv.h so that
												//  _sysPktBodyCommon is defined.)
#include "Palm/Incs/System/SerialLinkMgr.h"		// SlkPktHeaderType, slkSocketDebugger, etc.
#include "Palm/Incs/System/FatalAlert.h"		// fatalReset, etc.


#undef small	// Defined in a VC++ header (RPCNDR.H).
#include "Palm/Incs/System/DLCommon.h"
#include "Palm/Incs/System/DLServer.h"

#include "Palm/Incs/International/TextMgr.h"	// TxtGetNextChar

#define NON_PORTABLE
#include "Palm/Incs/System/DebugPrv.h"			// BreakpointType
#include "Palm/Incs/System/KeyPrv.h"			// KeyHandleInterrupt
#include "Palm/Incs/System/DataPrv.h"			// DatabaseHdrPtr, etc.
#include "Palm/Incs/System/SysEvtPrv.h"			// SysEvtMgrGlobalsPtr
#include "Palm/Incs/System/SystemPrv.h"
#include "Palm/Incs/Hardware/Hardware.h"		// hwrDisplayWidth, hwrSystemTop, hwrSystemHeight
#include "Palm/Incs/System/MemoryPrvNew.h"		// MemNVParams

#include "Palm/Incs/Hardware/M68328Hwr.h"			// HwrDBallType

	// Bank_MC68328.cpp needs M68328Hwr.h, while Bank_MC68EZ328.cpp needs
	// M68EZ328Hwr.h.  These two header files define conflicting defintions
	// of HwrDBallType and HwrDBallPtr.  To avoid that collision, use some
	// pre-processor majik.
#define HwrDBallType HwrDBallEZType
#define HwrDBallPtr HwrDBallEZPtr
#include "Palm/Incs/Hardware/M68EZ328Hwr.h"		// HwrDBallType
#undef HwrDBallType
#undef HwrDBallPtr

#include "Palm/Incs/Hardware/M68681Hwr.h"			// HwrDuartType

	// Controls:
	//	HardwarePrv.h
	//		hwr68328Base
	//		hwrCardBase0
	//		hwrCardSize
	//		hwrFlashBase
	//		hwrFlashSize
	//		hwrCardOffsetMask
	//		hwrROMWidth
	//		hwrDuartBase
	//		hwrDuartClock
	//		hwrDuartACRReg
	//	SystemPrv.h
	//		sysDefaultSerPort
#undef HW_TARGET
#define HW_TARGET HW_TARGET_TD1

	// Controls: nothing (for us), but it needs to be defined anyway
#define HW_REV 1

#include "Palm/Incs/Hardware/HardwarePrv.h"		// hwr68328Base, hwrDuartBase
#include "Palm/Incs/Hardware/HardwareTD1.h"		// hwrTD1PortFLCDEnableOn, hwrTD1PortFPanelMask, etc.

	// Undef these, as they'll get redefined in HardwareEZ.h
#undef hwrWriteProtectOff
#undef hwrWriteProtectOn

#include "Palm/Incs/Hardware/HardwareEZ.h"

	// Undef these, as they'll get redefined in HardwareAustin.h
#undef hwrWriteProtectOff
#undef hwrWriteProtectOn

#include "Palm/Incs/Hardware/SED1375Hwr.h"			// SED1375RegsType
#include "Palm/Incs/Hardware/HardwareAustin.h"		// New Austin pin assignments

// ===== Copied from Jerry-EZ version of M68EZ328Hwr.h =====

typedef Byte	UInt8;
typedef Word	UInt16;
typedef DWord	UInt32;

/************************************************************************
 * Jerry EZ cost reduction PLD I/O register
 ***********************************************************************/
typedef struct HwrJerryPLDType {

	UInt8	dspOn;			// pld output turn dsp on/off
	UInt8	unused1;
	UInt8	chargeOn;		// pld output turn charger on/off
	UInt8	unused2;
	UInt8	refOn;			// pld output turn 3.0 volt reference on/off
	UInt8	unused3;
	UInt8	pipaBiasEnable;	// pld output turn PA bias on/off
	UInt8	unused4;
	UInt8	dspReset;		// pld output control dsp reset pin up/down
	UInt8	unused5;
	UInt8	ezToDsl;		// pld output comm. pin to dsp
	UInt8	unused6;
	UInt8	rs232Shdn;		// pld output control rs232 interface chip on/off
	UInt8	unused7;
	UInt8	spareOut;		// pld output not used
	UInt8	unused8;
	UInt16	dTo3Sln;		// pld input comm. from dsp
	UInt16	iXtrnl2;		// pld input cradle connector pin
}	HwrJerryPLDType;

typedef	volatile HwrJerryPLDType*	HwrJerryPldPtr;

/************************************************************************
 * Jerry EZ cost reduction.  PLD settings
 ***********************************************************************/
#define hwrJerryPld232Enable			0x80
#define  hwrJerryPld232Disable			0
#define hwrJerryPldChargerOn			0x80
#define  hwrJerryPldChargerOff			0
#define hwrJerryPldPaBiasEnable			0x80
#define  hwrJerryPldPaBiasDisable		0
#define hwrJerryPldRefOn				0x80
#define  hwrJerryPldRefOff				0
#define hwrJerryPldDspSelect			0x80
#define  hwrJerryPldDspDeselect			0
#define hwrJerryPldDspResetAssert		0x80
#define  hwrJerryPldDspResetDeassert	0
#define hwrJerryPldDspPowerOn			0x80
#define  hwrJerryPldDspPowerOff			0

/************************************************************************
 * Jerry EZ cost reduction.  Set the PLD address.
 ***********************************************************************/
#define	hwrJerryPldBase		0x11000000L

// ===== End of copy =====

	// Undef these again so that we don't accidentally try using them.
#undef hwrWriteProtectOff
#undef hwrWriteProtectOn


#undef NON_PORTABLE


#if defined(_WINDOWS) || defined(UNIX)

typedef signed char		SInt8;			   
typedef signed short	SInt16;			   
typedef signed long		SInt32;			   

#endif


#include "PalmPackPop.h"

#undef ControlPtr
#undef ListPtr

// Defined in both CharAttr.h and ...\VC\Includes\xlocinfo.h
#undef _XA
#undef _XS
#undef _BB
#undef _CN
#undef _DI
#undef _LO
#undef _PU
#undef _SP
#undef _UP
#undef _XD

// UICommon.h defines these, but they conflict with the STL functions

#undef min
#undef max


#endif /* _PALM_H_ */

