/* -*- mode: C++; tab-width: 4 -*- */
/* ================================================================================== */
/* Copyright (c) 1998-1999 3Com Corporation or its subsidiaries. All rights reserved. */
/* ================================================================================== */

#ifndef __MAPFILE_H__
#define __MAPFILE_H__

#include <stdio.h>

// -----------------------------------------------------------------------------
// class MapFile
//
// A MapFile is a class which reads a file of name -> value pair mappings into
// memory, and then presents the data as an associative map
// -----------------------------------------------------------------------------
class MapEntry;

class MapFile
{
public:

	// -----------------------------------------------------------------------------
	// constructor / destructor
	// -----------------------------------------------------------------------------

	MapFile( int buckets = 20 );
	MapFile( const char* filename, int buckets = 20 );
	virtual ~MapFile( void );

	// -----------------------------------------------------------------------------
	// public methods
	// -----------------------------------------------------------------------------

	void parseFile( const char* fname );

	// add mapping to Map. Memory is copied.
	void add( const char* key, const char* value );
	bool remove( const char* key );
	char* find( const char* key );
	int size() { return _count; }
	void dump( FILE* f );

	void setCaseCompare( bool b ) { _useCase = b; }
	bool getCaseCompare() { return _useCase; }

private:

	// -----------------------------------------------------------------------------
	// private methods
	// -----------------------------------------------------------------------------

	void initialize();

	void removeEntry( MapEntry* entry );
	void insertEntry( MapEntry* entry );
	int hash( const char* key );
	MapEntry* lookup( const char* key );

	void scanLine( char* line );
	void parseLine( char* line );
	char* trim( char *s );

	int compare( const char *s1, const char *s2 );

	// -----------------------------------------------------------------------------
	// private data members
	// -----------------------------------------------------------------------------	

	bool _useCase;
	int _numBuckets;
	int _count;
	MapEntry **_buckets;
};

#endif /* __MAPFILE_H__ */
