#include <ctype.h>
#include <limits.h>
#include "diadef.h"
#include "dialog.h"
#include <popen.h>
#include "internal.h"
#include "dialog.m"
#include "../diajava/proto.h"

/*
	Evaluate the horizontal space needed to draw the buttons
*/
PUBLIC int BUTTONS_INFO::evalwidth()
{
	int ret = 1;
	for (int i=0; i<nb; i++){
		/* add 2 for the < > on each side */
		/* add 2 for some space around the buttons */
		ret += strlen(tb_title[i]) + 2;
	}
	if (!helpfile.is_empty()) ret += strlen(MSG_U(B_HELP,"Help")) + 2;
	return ret;
}
PUBLIC BUTTONS_INFO::BUTTONS_INFO()
{
	nb = 0;
	nbusr = 0;
	nbhelp = 0;
	maxhelp = 0;
	tbhelp = NULL;
}

PUBLIC BUTTONS_INFO::~BUTTONS_INFO()
{
	free (tbhelp);
}


PUBLIC void BUTTONS_INFO::setbutinfo (
	int id,					// MENU_xxxx (Not MENUBUT_xxxx)
	const char *title,		// Name that goes in the button
	const char *icon)		// Icon to use in html mode
{
	tbusr[nbusr].id = id;
	tbusr[nbusr].title.setfrom (title);
	tbusr[nbusr].icon.setfrom (icon);
	nbusr++;
}

PUBLIC void BUTTONS_INFO::delbutinfo()
{
	nbusr = 0;
}

PUBLIC void BUTTONS_INFO::set(
	int _but_options,	// MENUBUT_xxxx | MENUBUT_xxxx | ...
	HELP_FILE &_helpfile)
{
	nb = 0;
	but_options = _but_options;
	/*
		Not all buttons combination are meaningful. This
		explain why several buttons may share the same
		but_ret value.
	*/
	static struct BUTTON_ALL{
		int but_id;
		MENU_STATUS but_ret;	// Returned value when this button
					// is picked
		const char *str;
		const char *icon;
	} tbl[]={
		{ MENUBUT_YES,	MENU_YES,	MSG_U(B_YES,"Yes"),	MSG_U(X_YES,"Yes")	},
		{ MENUBUT_NO,	MENU_NO,	MSG_U(B_NO,"No"),	MSG_U(X_NO,"No")	},
		{ MENUBUT_OK,	MENU_OK,	MSG_U(B_OK,"Ok"),	MSG_U(X_OKEY,"Ok")	},
		{ MENUBUT_ACCEPT,	MENU_ACCEPT,	MSG_U(B_ACCEPT,"Accept"),	MSG_U(X_ACCEPT,"Accept")},
		{ MENUBUT_CANCEL,	MENU_CANCEL,	MSG_U(B_CANCEL,"Cancel"),	MSG_U(X_CANCEL,"Cancel")},
		{ MENUBUT_QUIT,		MENU_QUIT,	MSG_U(B_QUIT,"Quit"),		MSG_U(X_QUIT,"Quit")	},
		{ MENUBUT_SAVE,		MENU_SAVE,	MSG_U(B_SAVE,"Save"),		MSG_U(X_SAVE,"Save")	},
		{ MENUBUT_ADD,		MENU_ADD,	MSG_U(B_ADD,"Add"),			MSG_U(X_ADD,"Add")	},
		{ MENUBUT_DEL,		MENU_DEL,	MSG_U(B_DEL,"Del"),			MSG_U(X_DEL,"Del")	},
		{ MENUBUT_INS,		MENU_INS,	MSG_U(B_INS,"Ins"),			MSG_U(X_INS,"Ins")	},
		{ MENUBUT_EDIT,		MENU_EDIT,	MSG_U(B_EDIT,"Edit"),		MSG_U(X_EDIT,"Edit")	},
		{ MENUBUT_RESET,	MENU_RESET,	MSG_U(B_RESET,"Reset"),		MSG_U(X_RESET,"Reset")	},
		{ MENUBUT_MORE,		MENU_MORE,	MSG_U(B_MORE,"More"),		MSG_U(X_MORE,"More")	},
		{ MENUBUT_USR1,		MENU_USR1,	MSG_U(B_USR1,"Usr1"),		"Usr1"	},
		{ MENUBUT_USR2,		MENU_USR2,	MSG_U(B_USR2,"Usr2"),		"Usr2"	},
		{ MENUBUT_USR3,		MENU_USR3,	MSG_U(B_USR3,"Usr3"),		"Usr3"	},
		{ MENUBUT_USR4,		MENU_USR4,	MSG_U(B_USR4,"Usr4"),		"Usr4"	},
		{ MENUBUT_USR5,		MENU_USR5,	MSG_U(B_USR5,"Usr5"),		"Usr5"	},
		{ MENUBUT_USR6,		MENU_USR6,	MSG_U(B_USR6,"Usr6"),		"Usr6"	},
		{ MENUBUT_USR7,		MENU_USR7,	MSG_U(B_USR7,"Usr7"),		"Usr7"	},
	};
	BUTTON_ALL *ptl = tbl;
	for (unsigned i=0; i<sizeof(tbl)/sizeof(tbl[0]); i++, ptl++){
		if ((ptl->but_id & _but_options) != 0
			&& (ptl->but_id != MENUBUT_OK || _but_options == MENUBUT_OK)){
			/* #Specification: dialog / MENUBUT_OK / nerver displayed
				The button "Ok" is never shown except if it is the
				only button of the dialog. It is implied by an
				<enter> on a menu item. Initially it was shown but soon
				user have started complaining that it was useless.

				From the outside, it looks like a normal buttons, but
				deep in dialog/buttons.c, it is simply not shown.
			*/
			tb_title[nb] = ptl->str;
			tb_icon[nb] = ptl->icon;
			int but_ret = tbret[nb] = ptl->but_ret;
			for (int u=0; u<nbusr; u++){
				if (tbusr[u].id == but_ret){
					tb_title[nb] = tbusr[u].title.get();
					tb_icon[nb] = tbusr[u].icon.get();
					break;
				}
			}
			nb++;
		}
	}
	char rpath[PATH_MAX];
	_helpfile.getrpath(rpath);
	helpfile.setfrom (rpath);
	if (!helpfile.is_empty() || nbhelp > 0){
		tb_title[nb] = MSG_R(B_HELP);
		tb_icon[nb] = MSG_U(X_HELP,"Help");
		tbret[nb] = MENU_HELP;
		nb++;
	}
}	

PUBLIC void BUTTONS_INFO::addhelp (HELP_FILE &help, const char *title)
{
	if (nbhelp == maxhelp){
		maxhelp += 20;
		tbhelp = (HELP_FILE**)realloc(tbhelp,maxhelp*sizeof(HELP_FILE*));
	}
	tbhelp[nbhelp++] = &help;
	tbhelpt.add (new SSTRING(title));
}

/*
	Setup the coordinate of each button in the dialog
*/
PUBLIC void BUTTONS_INFO::setup(
	int _y,		// Line where the buttons will be drawn
	int width)	// Width of the window
{
	if (nb > 0){
		int total_width=1;	// Total size required by all buttons
		for (int i=0; i<nb; i++){
			const char *but = tb_title[i];
			total_width += strlen(but)+2;
		}
		int space = (width-total_width)/(nb+1);
		if (space < 0) space = 0;
		int pos = 1;
		for (int i=0; i<nb; i++){
			int lenbut = strlen(tb_title[i]);
			if (pos + space + lenbut >= width){
				pos = 1;
				_y += 3;
			}else{
				pos += space;
			}
			tbcoor[i].x = pos;
			tbcoor[i].y = _y;
			pos += lenbut + 2;
		}
	}
}	

/*
	Set the screen cursor on the active button
*/
PUBLIC void BUTTONS_INFO::setcursor (
	WINDOW *dialog,
	int button)			// Which buttons is currently selected
						// or -1 if none
{
	if (button != -1 && button < nb){
		int x = tbcoor[button].x;
		int y = tbcoor[button].y;
		const char *but = tb_title[button];
		while (*but == ' '){
			but++;
			x++;
		}
		wmove (dialog,y,x+1);
	}
}

/*
	Draw all buttons
*/
PUBLIC void BUTTONS_INFO::draw(
	WINDOW *dialog,
	int button)		// Which buttons is currently selected
				// or -1 if none
{
	for (int i=0; i<nb; i++){
		print_button(dialog,tb_title[i],tbcoor[i].y,tbcoor[i].x
			, button == i ? TRUE : FALSE);
	}
	setcursor (dialog,button);
}
/*
	Defines all button in the GUI
*/
PUBLIC void BUTTONS_INFO::gui_draw()
{
	for (int i=0; i<nb; i++){
		MENU_STATUS but = tbret[i];
		char tmp[1000];
		diagui_sendcmd (P_Button,"B%d %d %s\n"
			,i
			,but != MENU_CANCEL && but != MENU_QUIT ? 1 : 0
			,diagui_quote(tb_title[i],tmp));
	}
}

static const char K_DIALOG[]="dialog";
static const char K_USELYNX[]="uselynx";
/*
	Return true if lynx is used to display help in text mode
*/
bool dialog_usinglynx()
{
	return linuxconf_getvalnum (K_DIALOG,K_USELYNX,0)!=0;
}

/*
	Record the value for using or not lynx to display help screens.
*/
void dialog_setuselynx(bool uselynx)
{
	linuxconf_replace (K_DIALOG,K_USELYNX,uselynx ? 1 : 0);
}

static bool lynx_allowed = true;
/*
	Override usage of lynx as the help previewer (disable it or not)
*/
void dialog_mayuselynx(bool mayuselynx)
{
	lynx_allowed = mayuselynx;
}

static void buttons_help (WINDOW *win, const char *relpath)
{
	if (dialog_mode == DIALOG_GUI){
		diagui_showhelp (relpath);
	}else{
		char path[PATH_MAX];
		if (lynx_allowed
			&& dialog_usinglynx()
			&& html_locatefile (relpath,".html",path,PATH_MAX)!=-1){
			dialog_end();
			// We use the POPEN object because it does many useful things
			// -it cleanup the environnement
			// -it select the original user UID
			// Unfortunatly, it screw the stdin/stdout. so lynx can't work
			// For now, we cheat with the socket_HOLDER trick. We are
			// effectivly calling the following command
			//  lynx path_of_help.html ; echo socket_handle
			// One day, the POPEN functionnality could be generalised to make
			// this cleaner.
			strcat (path,";echo");
			strcat (path,popen_SOCKETHOLDER);
			POPEN pop ("lynx",path,popen_getloginuid());
			if (pop.isok()){
				while (pop.wait(1000000)>0);
			}
		}else if (html_locatefile (relpath,".help",path,PATH_MAX)!=-1){
			dialog_textbox (path,path);
		}else{
			xconf_error (MSG_U(E_NOHELPFILE,"Help file %s not yet written"),relpath);
		}
		touchwin(stdscr);
		touchwin(win);
		dialog_clear ();
		refresh();
	}
}

PUBLIC void BUTTONS_INFO::help (WINDOW *win)
{
	if (nbhelp == 0){
		buttons_help (win,helpfile.get());
	}else{
		DIALOG_RECORDS dia;
		dia.newf_head ("",MSG_U(H_HELPFILES,"Help file\tTitle"));
		dia.new_menuitem (helpfile.get(),MSG_U(T_MAINHELP,"Main topic"));
		for (int i=0; i<nbhelp; i++){
			char rpath[PATH_MAX];
			tbhelp[i]->getrpath(rpath);
			dia.new_menuitem (rpath,tbhelpt.getitem(i)->get());
		}
		int nof = 0;
		while (1){
			MENU_STATUS code = dia.editmenu (
				MSG_U(T_PICKHELP,"Pick a help file")
				,"",help_nil,nof,0);
			if (code == MENU_QUIT || code == MENU_ESCAPE){
				break;
			}else if (nof == 0){
				buttons_help (win,helpfile.get());
			}else{
				char rpath[PATH_MAX];
				tbhelp[nof-1]->getrpath(rpath);
				buttons_help (win,rpath);
			}
		}
	}
}

/*
	Process one key.
	This function is called when the focus is in the button section.
	It will process the help button by itself.

	It return -1 is nothing special happened. It return the number
	of the selected button otherwise. The called generally
	terminate then.
*/
PUBLIC MENU_STATUS BUTTONS_INFO::dokey(
	WINDOW *dialog,
	int key,
	int &selected,
	int other_focus)	// Is there something other that buttons
				// or something that require specific focus
{
	MENU_STATUS ret = MENU_NULL;
	int button = selected;
	key = toupper(key);
	
	if (key == TAB){
		button++;
		if (button == nb) button = -1;
	}else if (key == KEY_RIGHT){
		button++;
		if (button == nb) button = 0;
	}else if (key == KEY_LEFT){
		button--;
		if (button == -1) button = nb-1;
	}else if (key == '\n'){
		if (!helpfile.is_empty() && button == nb -1){
			help (dialog);
			button = -1;
		}else{
			ret = tbret[button];
		}
	}else if (key == KEY_F(1) && !helpfile.is_empty()){
		help (dialog);
		button = -1;
	}else if (key == 'Y' && (but_options & MENUBUT_YES)){
		ret = MENU_YES;
	}else if (key == 'N' && (but_options & MENUBUT_NO)){
		ret = MENU_NO;
	}
	if (!other_focus && button == -1) button = 0;
	draw(dialog,button);
	selected = button;
	return ret;
}

PUBLIC MENU_STATUS BUTTONS_INFO::bid2status(int id)
{
	MENU_STATUS ret = MENU_ESCAPE;
	if (id == 98){
		ret = MENU_ACCEPT;
	}else if (id != 99){
		ret = tbret[id];
	}
	return ret;
}

