#include <dialog.h>
#include "internal.h"
#include <userconf.h>
#include "mailconf.m"
#include <netconf.h>

static MAILCONF_HELP_FILE help_basic ("basic");
extern CONFIG_FILE f_sendmail;

/*
	Define the help list for the available mailer
*/
void basic_setmailer (FIELD_COMBO *comb)
{
	comb->addopt ("esmtp",MSG_U(F_ESMTP,"Enhanced smtp"));
	comb->addopt ("smtp",MSG_U(F_SMTP,"Normal smtp"));
	comb->addopt ("esmtprem",MSG_U(F_ESMTPREM,"Expensive esmtp (on demand links)"));
	comb->addopt ("uucp-dom",MSG_U(F_MODERNUUCP,"Recommended modern UUCP"));
	comb->addopt ("uucp",MSG_U(F_OLDUUCP,"Old uucp"));
}


PUBLIC int MAILCONF::basicedit()
{
	DIALOG dia;
	dia.newf_str (MSG_U(F_PRESENT,"Present your system as"),mailas);
	{
		THISHOST h;
		char msg[100];
		snprintf (msg,sizeof(msg)-1,MSG_U(F_MAINSERV,"Accept email for %s")
			,h.getdomain());
		// Limit the dialog width in text mode
		if (dialog_mode == DIALOG_CURSES) msg[31] = '\0';
		dia.newf_chk ("",mainserv,msg);
	}
	dia.newf_str (MSG_U(F_MAILHOST,"Mail server"),mailhost);
	dia.newf_str (MSG_U(F_SMARTHOST,"Mail gateway"),smarthost);
	FIELD_COMBO *comb = dia.newf_combo (MSG_U(F_SMARTMAIL
		,"Mail gateway protocol"),smartmailer);
	basic_setmailer (comb);

	dia.newf_title (MSG_U(T_FEATURES,"Features"),1,"",MSG_R(T_FEATURES));
	dia.newf_chk ("",features.usegecos,MSG_U(F_USEGECOS,"match full user name"));
	dia.newf_chk ("",features.relayctrl,MSG_U(F_SPAMENABLE
		,"Enable relay control (spammers)"));
	static const char *tblimit[]={MSG_U(I_NOLIMIT,"No limit"),NULL};
	static const int  tblimitv[]={0,0};
	dia.newf_chkm_num (MSG_U(F_MAXSIZE,"Messages size limit")
		,features.maxmsgsize,tblimitv,tblimit);
	dia.newf_chk ("",features.deferdeliv
		,MSG_U(F_DEFERDELIV,"Don't try to deliver immediatly"));
	{
		static const char *tbdel[]={MSG_U(I_MANUAL,"Manual"),NULL};
		static const int  tbdelv[]={0,0};
		dia.newf_chkm_num (MSG_U(F_QUEUEDELAY
			,"Process queue every (minutes)"),features.queuedelay
			,tbdelv,tbdel);
	}
	dia.newf_chk ("",features.usesmrsh,MSG_U(F_USESMRSH,"Use special shell smrsh"));
	static const char *tbvals[]={MSG_U(I_DEFAULTS,"Defaults"),NULL};
	static int vals[]={0,0};
	dia.newf_chkm_num (MSG_U(F_MAXRECIPIENTS,"Maximum recipients per msg.")
		,features.maxrecipients,vals,tbvals);

	dia.newf_title ("",MSG_U(T_DNSFEATURES,"DNS features"));
	dia.newf_chk ("",features.dnsneeded,MSG_U(F_WAITDNS,"wait for DNS"));
	dia.newf_chk ("",features.nodns,MSG_U(F_NODNS,"don't use DNS"));


	dia.newf_title (MSG_U(T_MISC,"Misc."),1,"",MSG_R(T_MISC));

	dia.newf_chk ("",features.uucpnobatch,MSG_U(F_NOBATCH
		,"no batching for uucp mail"));
	dia.newf_num (MSG_U(F_UUCPMAXSIZE,"Max size of uucp messages")
		,features.uucpmax);
	dia.newf_str (MSG_U(F_DELIVER,"Deliver locally to users")
		,users.deliverlocal);
	dia.newf_str (MSG_U(F_NOMASQ,"No masquerade from users")
		,users.dontmasque);
	dia.newf_str (MSG_U(F_TRUST,"Trusted users"),users.trust);

	dia.newf_chk (MSG_U(F_USEMTABLE,"special routing db.")
		,features.mailertable,MSG_U(I_USEMTABLE,"Enabled"));
	comb = dia.newf_combo (MSG_U(F_SPECIAL
		 ,"Special routing db. format")
		,features.dbformat);
	comb->addopt ("btree");
	comb->addopt ("hash");
	comb->addopt ("dbm");
	comb->addopt ("NIS");

	comb = dia.newf_list (MSG_U(F_LOCALMAILER,"Local delivery agent")
		,deliver);
	comb->addopt ("",MSG_U(O_PROBED,"Let linuxconf probe"));
	comb->addopt ("deliver","/usr/bin/deliver");
	comb->addopt ("mail.local","/bin/mail.local");
	comb->addopt ("procmail","/usr/bin/procmail");

	dia.newf_chk ("",features.bogushelo
		,MSG_U(F_BOGUSHELO,"Support bogus mail clients(HELO)"));

	#ifdef DNS_LIMIT
		/* #Specification: mailconf / limiting DNS scope
			An attempt was made to somewhat limit
			the DNS usage of sendmail. One way
			is to desactivate DNS canonification in
			ruleset 96. mailconf allows this.

			This is fine for small site with a single
			mailhost for example.

			Larger site may have several mailhost
			with several subdomain and yet no full
			connectivity to the internet, and to make
			things worst, have sometime some connectivity
			on the internet. It means that the DNS knows
			how to resolv any name but will generally
			fail, unless someone establish the internet
			connection.

			So on one hand, we need DNS flexibility and
			MXs, and on the other hand we must avoid it
			to make sure sendmail won't timeout needlessly.
			In fact, in this setup, email is either local
			or through a forwarder which knows better anyway.

			This half DNS solution is still a problem.
			One solution would be to restart the DNS
			with or without a root.cache file when
			connected or not connected to the internet.

			If this problem rings bell to you, I would
			be happy to talk about it. I am pretty sure
			something generally useful would come out of  it.
		*/
		dia.newf_title ("",MSG_U(F_LIMITDNS,"Limit DNS for those domains"));
		for (int d=0; d<MAXDNSFOR; d++){
			dia.newf_str ("",dnsfor[d]);
		}
	#endif

	dia.newf_title (MSG_U(T_DOMALIASES,"Aliases"),1,"",MSG_U(T_WHENREC,"Domain aliases"));
	{
		alias.add (new SSTRING);
		const char *title = MSG_U(F_YOURSYS,"Aliases for your system");
		int nb_empty = 3;	// Always 3 empty line available for convenience
		for (int i=0; i<alias.getnb(); i++){
			SSTRING *s = alias.getitem(i);
			dia.newf_str (title,*s);
			title = "";
			if (s->is_empty()) nb_empty--;
		}
		for (int e=0; e<nb_empty; e++){
			SSTRING *s = new SSTRING;
			alias.add (s);
			dia.newf_str ("",*s);
		}
	}

	dia.addwhat (MSG_U(I_ADDEMPTY,"Select [Add] to add an empty alias line"));
	int ret = 0;
	int nof = 0;
	while (1){
		MENU_STATUS code = dia.edit(
			MSG_U(T_BASIC,"Basic Sendmail configuration")
			,""
			,help_basic
			,nof
			,MENUBUT_CANCEL|MENUBUT_ACCEPT|MENUBUT_ADD);
		if (code == MENU_CANCEL || code == MENU_ESCAPE){
			break;
		}else if (code == MENU_ADD){
			for (int e=0; e<3; e++){
				SSTRING *s = new SSTRING;
				alias.add (s);
				dia.newf_str ("",*s);
			}
		}else if (code == MENU_ACCEPT){
			VDOMAINS vdoms;
			if (check(vdoms)==0
				&& perm_rootaccess(MSG_U(P_CONFMAIL,"configure sendmail"))){
				alias.remove_empty();
				write ();
				ret = 1;
				break;
			}
		}
	}
	if (ret != 1) dia.restore();
	return ret;
}

struct MAILCONFLICT{
	const char *domain;
	const char *owner;
};

static void basic_addinfo (
	MAILCONFLICT tbname[],
	int &no,
	const char *domain,
	const char *owner)
{
	if (domain[0] != '\0'){
		tbname[no].domain = domain;
		tbname[no].owner = owner;
		no++;
	}
}

/*
	Verify various things about sendmail configuration
	Return -1 if any error was reported.
*/
PUBLIC int MAILCONF::check(VDOMAINS &vdoms)
{
	/* #Specification: mailconf / check / vdomain and domain aliases
		Linuxconf checks that a domain alias (Aliases for your system)
		is not in the list of vdomains.
	*/
	
	int i;
	// Evaluate the size of tbname[]
	int nbname = alias.getnb()+2;
	for (i=0; i<vdoms.getnb(); i++){
		VDOMAIN *dom = vdoms.getitem(i);
		nbname += 1 + dom->others.getnb();
	}
	// Collect all domain name in tbname[]
	MAILCONFLICT tbname[nbname];
	int no = 0;
	THISHOST thishost;
	basic_addinfo (tbname,no,thishost.getname1()
		,MSG_U(E_IMPLICITCONFIG,"implicit linuxconf rule"));
	if (mainserv){
		const char *dom = thishost.getdomain();
		if (dom != NULL){
			basic_addinfo (tbname,no,dom,MSG_U(E_MAINCONFIG
				,"main email configuration"));
		}
	}
	for (i=0; i<alias.getnb(); i++){
		basic_addinfo (tbname,no,alias.getitem(i)->get()
			,MSG_U(E_MAINALIASES,"aliases for your system"));
	}
	for (i=0; i<vdoms.getnb(); i++){
		VDOMAIN *dom = vdoms.getitem(i);
		const char *domname = dom->domain.get();
		basic_addinfo (tbname,no,domname,domname);
		for (int a=0; a<dom->others.getnb(); a++){
			const char *o = dom->others.getitem(a)->get();
			basic_addinfo (tbname,no,o,domname);
		}
	}
	// Check for duplicates
	int ret = 0;
	for (i=1; i<no; i++){
		const char *domain = tbname[i].domain;
		for (int j=0; j<i; j++){
			if (stricmp(domain,tbname[j].domain)==0){
				xconf_error (MSG_U(E_MAILCONFLICT
					,"Conflicting mail configuration:\n"
					 "Domain/Host name %s can't be managed both\n"
					 "by  %s\n"
					 "and %s")
					,domain,tbname[i].owner,tbname[j].owner);
				ret = -1;
			}
		}
	}
	return ret;
}

