/* ***********

	Check comments starting with // ### and fill appropriate code there

   ***********
*/
#pragma implementation
#include <stdio.h>
#include <string.h>
#include <translat.h>
#include <fstab.h>
#include "status.h"
#include "status.m"

static HELP_FILE help_status("status","status");

MODULE_DEFINE_VERSION(status);

PUBLIC MODULE_status::MODULE_status()
	: LINUXCONF_MODULE("status")
{
	linuxconf_loadmsg ("status",PACKAGE_REV);
	module_register_api ("status",1,status_api_get,status_api_release);
}


static const char *keymenu=NULL;

PUBLIC void MODULE_status::setmenu (
	DIALOG &dia,
	MENU_CONTEXT context)
{
	if (context == MENU_MAIN_STATUS){
		keymenu = MSG_U(M_status,"Viewing system state");
		dia.new_menuitem ("status","",keymenu);
	}
}

static const char *report;
static const char *sysinfo;
static const char *memory;
static const char *disk;
static const char *diskquota;
static const char *scsi;
static const char *inter;
static const char *iprouting;
static const char *ipxrouting;
static const char *processes;
static const char *ioports;
static const char *interrupts;
static const char *md;
static const char *pci;

static void status_showdiskquota()
{
	FSTAB fstab;
	DIALOG_RECORDS dia;
	dia.newf_head ("",MSG_U(H_DQUOTA,"Device\tMount point\tUser quota\tGroup quota"));
	FSTAB_ENTRY *tb[fstab.getnb()];
	int nbentry = 0;
	for (int i=0; i<fstab.getnb(); i++){
		FSTAB_ENTRY *en = fstab.getitem(i);
		if (en->is_valid() && en->gettype() == FSTAB_ENTRY_LOCAL){
			tb[nbentry++] = en;
			char buf[100];
			snprintf (buf,sizeof(buf)-1,"%s\t%s\t%s",en->getmpoint()
				,en->has_quota_u() ? MSG_U(I_ENABLED,"Enabled") : ""
				,en->has_quota_g() ? MSG_R(I_ENABLED) : "");
			dia.new_menuitem (en->getsource(),buf);
		}
	}
	int nof = 0;
	while (1){
		MENU_STATUS code = dia.editmenu (MSG_U(T_QUOTA,"Disk quota report")
			,"",help_nil,nof,0);
		if (code == MENU_ESCAPE || code == MENU_QUIT){
			break;
		}else if (nof >= 0 && nof < nbentry){
			FSTAB_ENTRY *en = tb[nof];
			if (!en->has_quota_u() && !en->has_quota_g()){
				xconf_notice (MSG_U(N_NOQUOTA
					,"Quota not enabled for this file system"));
			}else{
				const char *mpoint = en->getmpoint();
				SSTRINGS tb;
				if (en->has_quota_u()){
					char title[100],args[PATH_MAX];
					snprintf (title,sizeof(title)-1
						,MSG_U(M_USERQUOTA,"User quota on %s")
						,mpoint);
					tb.add (new SSTRING (title));
					snprintf (args,sizeof(args)-1,"-u %s",mpoint);
					sys_command ("repquota",args,tb);
				}
				if (en->has_quota_g()){
					char title[100],args[PATH_MAX];
					snprintf (title,sizeof(title)-1
						,MSG_U(M_GROUPQUOTA,"Group quota on %s")
						,mpoint);
					tb.add (new SSTRING (title));
					snprintf (args,sizeof(args)-1,"-g %s",mpoint);
					sys_command ("repquota",args,tb);
				}
				dialog_textbox (MSG_R(T_QUOTA),tb);
			}
		}
	}
}

static void ft (void *p)
{
	const char *key = (const char *)p;
	if (key == report){
		status_report();
	}else if (key == sysinfo){
		sys_sysinfo_show();
	}else if (key == memory){
		sys_memory_show();
	}else if (key == disk){
		sys_disk_show();
	}else if (key == diskquota){
		status_showdiskquota();
	}else if (key == scsi){
		sys_scsi_show();
	}else if (key == md){
		sys_md_show();
	}else if (key == inter){
		sys_inter_show();
	}else if (key == iprouting){
		sys_iprouting_show();
	}else if (key == ipxrouting){
		sys_ipxrouting_show();
	}else if (key == processes){
		sys_processes_show();
	}else if (key == interrupts){
		sys_interrupts_show();
	}else if (key == ioports){
		sys_ioports_show();
	}else if (key == pci){
		sys_pci_show();
	}else{
		module_domenu (MENU_SYS_STATUS,key);
	}
}

static void status_mainmenu()
{
	//report = MSG_U(M_REPORT,"Prepare a report");
	sysinfo = MSG_U(M_SYSINFO,"System information");
	memory = MSG_U(M_MEMORY,"memory usage(RAM)");
	disk = MSG_U(M_DISK,"disk usage");
	diskquota = MSG_U(M_DISKQUOTA,"disk quota");
	scsi = MSG_U(M_SCSI,"scsi devices");
	md = MSG_U(M_MD,"RAID (MD) usage");
	inter = MSG_U(M_INTERFACE,"network devices");
	iprouting = MSG_U(M_IPROUTING,"IP routing table");
	ipxrouting = MSG_U(M_IPXROUTING,"IPX routing table");
	processes = MSG_U(M_PROCESSES,"processes");
	interrupts = MSG_U(M_INTERRUPTS,"interrupts mapping");
	ioports = MSG_U(M_IOPORTS,"I/O port mapping");
	pci = MSG_U(M_PCI,"PCI devices");

	static const char *tbopt[]={
		// "", report,
		"-",	MSG_U(H_SYSTEM,"System"),
		"",	sysinfo,
		"",	memory,
		"",	disk,
		"",	diskquota,
		"",	scsi,
		"",	md,
		"", pci,
		"-",	MSG_U(H_NETWORKING,"Networking"),
		"",	inter,
		"",	iprouting,
		"",	ipxrouting,
		"-",	MSG_U(H_CPU,"Cpu"),
		"", processes,
		"", interrupts,
		"", ioports,
		"-",	MSG_U(H_MISC,"Miscellaneous"),
		NULL
	};
		
	DIALOG_MENU dia;
	dia.new_menuitems(tbopt);
	dia.setmenu (MENU_SYS_STATUS);
	int nof = 0;
	while (1){
		MENU_STATUS code = dia.editmenu (MSG_U(T_STATUS,"System status")
			,MSG_U(I_STATUS
				,"You can view the current state of your computer.\n"
				 "You can't modidy anything from here.")
			,help_status
			,nof,0);
		if (code == MENU_ESCAPE || code == MENU_QUIT){
			break;
		}else{
			const char *key = dia.getmenustr(nof);
			uithread (ft,(void*)key);
		}
	}
}

static void status_main()
{
	if (netconf_mainaccess()){
		status_mainmenu();
	}
}

PUBLIC int MODULE_status::domenu (
	MENU_CONTEXT context,
	const char *key)
{
	if (context == MENU_MAIN_STATUS){
		if (key == keymenu){
			status_mainmenu();
		}
	}
	return 0;
}


PUBLIC int MODULE_status::dohtml (const char *key)
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(key,"status")==0){
		// ### Insert any menu and dialog here
		ret = 0;
	}
	return ret;
}


static void usage()
{
	xconf_error (MSG_U(T_USAGE
		,"status usage\n"
		 "\n"
		 "status --option ...\n")
		);
}

PUBLIC int MODULE_status::execmain (int argc , char *argv[])
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"status")==0){
		ret = -1;
		if (argc == 1){
			status_main();
		}else{
			// ### Add some option parsing for the module
			::usage();
		}
	}
	return ret;
}


static MODULE_status status;

