#ifndef CONF_PATHS_H


// Port used when installing linuxconf in Web mode server.
#define LINUXCONF_HTTP_PORT	98
#define LINUXCONF_HTTP_PORT_DEBUG	8000

/* Different paths */
/* If you change something here, you may want to change rules.mak also */

#define ETC_ALIASES		"/etc/aliases"

#define ETC_CONF_AMD_MAP	"/etc/conf.amd.map"

#define ETC_CONF_LINUXCONF	"/etc/conf.linuxconf"
#define ETC_CONF_MODULES	"/etc/conf.modules"
#define ETC_CONF_ROUTES		"/etc/conf.routes"

#define ETC_DHCPD_CONF		"/etc/dhcpd.conf"
#define ETC_DHCPD_LEASES	"/etc/dhcpd.leases"
#define ETC_EXPORTS			"/etc/exports"

#define ETC_FAX				"/etc/fax"
#define ETC_FAX_ALIASES		"/etc/fax/faxaliases"
#define ETC_FAX_RULES		"/etc/fax/faxrules"
#define ETC_FAX_USERS		"/etc/fax/faxusers"
#define ETC_FAX_ZONES		"/etc/fax/faxzones"
#define ETC_FSTAB			"/etc/fstab"
#define ETC_HOSTNAME		"/etc/HOSTNAME"
#define ETC_GATED_CONF		"/etc/gated.conf"
#define ETC_GROUP			"/etc/group"
#define ETC_HOST_CONF		"/etc/host.conf"
#define ETC_HOSTS			"/etc/hosts"
#define ETC_INETD_CONF		"/etc/inetd.conf"
#define ETC_LILO_CONF		"/etc/lilo.conf"
#define ETC_LINUXCONF		"/etc/linuxconf"
#define ETC_LINUXCONF_ADMTREES	ETC_LINUXCONF "/admtrees"
#define ETC_LINUXCONF_ARCHIVE	ETC_LINUXCONF "/archive"
#define ETC_LINUXCONF_GROUPS	ETC_LINUXCONF "/admgroups"
#define ETC_LINUXCONF_CONTROL	ETC_LINUXCONF "/control"

#define ETC_MAIL				"/etc/mail"
#define	ETC_MAIL_IP_ALLOW		ETC_MAIL "/ip_allow"
#define ETC_MAIL_NAME_ALLOW		ETC_MAIL "/name_allow"
#define ETC_MAIL_RELAY_ALLOW	ETC_MAIL "/relay_allow"
#define ETC_MAIL_DENY			ETC_MAIL "/deny"
#define ETC_MAIL_SENDMAIL_CW	ETC_MAIL "/sendmail.cw"
#define ETC_MAIL_VIRTUSER		ETC_MAIL "/virtusertable"
#define ETC_MAIL_POPHASH		ETC_MAIL "/pophash"

#define ETC_MAIL_MAILCONF		ETC_MAIL "/mailconf"

#define ETC_QUOTA_CONF		"/etc/quota.conf"
#define ETC_SERVICES		"/etc/services"
#define ETC_SHADOW			"/etc/shadow"
#define ETC_SKEL			"/etc/skel"
#define ETC_SSH_HOST_KEY	"/etc/ssh_host_key"
#define ETC_SYSLOG_CONF		"/etc/syslog.conf"
#define ETC_VMAIL			"/etc/vmail"
#define ETC_YP_CONF			"/etc/yp.conf"
#define ETC_PPP_PPPLOGIN	"/etc/ppp/ppplogin"
#define ETC_PPP_PAPSECRETS	"/etc/ppp/pap-secrets"
#define ETC_PPP_CHAPSECRETS	"/etc/ppp/chap-secrets"

#define ETC_WVDIAL_CONF		"/etc/wvdial.conf"

#define VHOME				"/vhome"

#define BOOT_MAP		"/boot/map"
#define ETC_MTAB		"/etc/mtab"
#define ETC_NAMED_BOOT		"/etc/named.boot"
#define ETC_NAMED_CONF		"/etc/named.conf"
#define ETC_NETWORKS		"/etc/networks"
#define ETC_PASSWD			"/etc/passwd"
#define ETC_PASSWD_HTMLINTRO	"/etc/passwd.htmlintro"
#define ETC_PASSWD_HTMLEND	"/etc/passwd.htmlend"
#define ETC_PPP				"/etc/ppp"
#define ETC_PPP_IPUP		"/etc/ppp/ip-up"
#define ETC_PPP_IPDOWN		"/etc/ppp/ip-down"
#define ETC_RESOLV_CONF		"/etc/resolv.conf"
#define ETC_SENDMAIL_CF		"/etc/sendmail.cf"
#define ETC_SHELLS			"/etc/shells"
#define ETC_SMB_CONF		"/etc/smb.conf"
#define ETC_XF86CONFIG		"/etc/XF86Config"
#define ETC_X11_XF86CONFIG	"/etc/X11/XF86Config"
#define ETC_XACCEL_INI		"/etc/Xaccel.ini"
#define ETC_X11_XMETROCONFIG	"/etc/X11/XMetroconfig"
#define VAR_STATE_LINUXCONF		"/var/state/linuxconf"

/* Empty file which record the last time netconf has sent */
/* a SIGHUP signal to inetd */
#define VAR_RUN_FIREWALL_ACCT	"/var/run/firewall.state.acct"
#define VAR_RUN_FIREWALL_BLOCK	"/var/run/firewall.state.block"
#define VAR_RUN_FIREWALL_FORWD	"/var/run/firewall.state.forwd"
#define VAR_RUN_FIREWALL_OUTPUT	"/var/run/firewall.state.output"
#define VAR_RUN_INETD_SIGHUP	"/var/run/inetd.sighup"
#define VAR_RUN_LINUXCONF_RESTART "/var/run/linuxconf.restartdb"
#define VAR_RUN_NAMED_PID		"/var/run/named.pid"
#define VAR_RUN_PPP0_PID		"/var/run/ppp0.pid"
#define VAR_RUN_PPPDEV			"/var/run/pppdev"
#define VAR_RUN_PPPD_ARGS		"/var/run/pppd-args"
#define VAR_RUN_PPPD_PAP		"/var/run/pppd-pap"
#define VAR_RUN_PPPD_WAIT		"/var/run/pppd-wait"
#define VAR_RUN_PPPRESTART		"/var/run/ppprestart"
#define PPPD_DIALD				"pppd-diald"
#define VAR_RUN_PPPD_DIALD		"/var/run/" PPPD_DIALD
#define VAR_RUN_ROUTED_OPTIONS	"/var/run/routed.options"
#define VAR_RUN_RUNLEVEL_DIR	"/var/run/runlevel.dir"
#define VAR_RUN_SENDMAIL_PID	"/var/run/sendmail.pid"
#define VAR_STATE_TREEMENU_CACHE	VAR_STATE_LINUXCONF "/treemenu.cache"
#define VAR_RUN_TREEMENU_LOG	"/var/run/treemenu.log"
#define VAR_RUN_VDELIVER_TMP	"/var/run/vdeliver.tmp"
#define USR_BIN_X11_X			"/usr/bin/X11/X"

#define USR_LOCALE_ALIAS		"/usr/share/locale/locale.alias"

#define VAR_LOG_NETCONF_LOG		"/var/log/netconf.log"
#define VAR_RUN_SIMUL		"/var/run/netconf.simul"
#define VAR_RUN_UPDATE		"/var/run/netconf.update"


#define USR_LIB_KBD_KEYMAPS	"/usr/lib/kbd/keymaps"
#define USR_LIB_LINUXCONF	"/usr/lib/linuxconf"
#define USR_LIB_LINUXCONF_ROOT_CACHE "/usr/lib/linuxconf/lib/root.cache"
#define USR_LIB_LINUXCONF_UUCPTASKS	"/usr/lib/linuxconf/uucp/uucp.tasks"
#define USR_LIB_CONF_DAEMONS	USR_LIB_LINUXCONF "/DIST/conf.daemons"
#define USR_LIB_CONF_PERMISSIONS USR_LIB_LINUXCONF "/DIST/perm"
#define USR_LIB_CONF_SCRIPTS 	USR_LIB_LINUXCONF "/DIST/scripts-equiv"
#define USR_LIB_CONF_RUNLEVELS 	USR_LIB_LINUXCONF "/DIST/runlevels"
#define USR_LIB_ZONEINFO	"/usr/lib/zoneinfo"
#define USR_SHARE_ZONEINFO	"/usr/share/zoneinfo"
#define USR_LIB_LOCALTIME	"/usr/lib/zoneinfo/localtime"

#define USR_SRC_LINUX_MAKEFILE	"/usr/src/linux/Makefile"

#define USR_X11R6_BIN_REMADMIN	"/usr/X11R6/bin/remadmin"

#define HELP_BASEPATH		"/usr/lib/linuxconf"
#define HELP_ASKRUN		"askrunlevel"
#define HELP_DNSCONF		"dnsconf"
#define HELP_MAIN		"main"
#define HELP_MAILCONF		"mailconf"
#define HELP_NETCONF		"netconf"
#define HELP_USER		"userconf"
#define HELP_XCONF		"xconf"
#define HELP_FSTAB		"fstab"
#define HELP_UUCP		"uucp"
#define HELP_APACHE		"apache"
#define HELP_SAMBA		"samba"
#define HELP_NETADM		"netadm"

#define VAR_LOG_BOOT_LOG		"/var/log/boot.log"
#define VAR_LOG_HTML_LOG		"/var/log/htmlaccess.log"

#define VAR_RUN_INITRUNLEVEL	"/var/run/initrunlvl"
#define ETC_INITRUNLEVEL	"/etc/initrunlvl"
#define VAR_RUN_NETLEVEL		"/var/run/netconf.level"
#define VAR_RUN_ROUTES_CURRENT	"/var/run/routes.current"
#define VAR_RUN_BOOTING			"/var/run/linuxconf.booting"

#define VAR_LIB_MAILERTABLE	"/var/lib/mailertable"
#define VAR_LIB_CONF_PERMISSIONS "/var/lib/conf.permissions"

#define VAR_LIB_UUCP_DEVICES	"/var/lib/uucp/hdb_config/Devices"
#define VAR_LIB_UUCP_DIALERS	"/var/lib/uucp/hdb_config/Dialers"
#define VAR_LIB_UUCP_PERMS		"/var/lib/uucp/hdb_config/Permissions"
#define VAR_LIB_UUCP_POLL		"/var/lib/uucp/hdb_config/Poll"
#define VAR_LIB_UUCP_SYSTEMS	"/var/lib/uucp/hdb_config/Systems"

/* Different magic names */

#define SBIN_SLIPLOGIN			"/sbin/diplogin"
#define USR_SBIN_SENDMAIL		"/usr/sbin/sendmail"
#define USR_LIB_UUCP_UUCICO		"/usr/lib/uucp/uucico"
#define VAR_SPOOL_UUCPPUBLIC		"/var/spool/uucppublic"
#define VAR_SPOOL_VMAIL				"/var/spool/vmail"

#define POP_GROUP			"popusers"
#define PPP_GROUP			"pppusers"
#define SLIP_GROUP			"slipusers"
#define UUCP_GROUP			"uucp"
#define PROC_INTERRUPTS			"/proc/interrupts"
#define PROC_NET_ALIAS_TYPES	"/proc/net/alias_types"
#define PROC_NET_ALIASES		"/proc/net/aliases"
#define PROC_NET_DEV			"/proc/net/dev"
#define PROC_NET_IP_FWCHAINS	"/proc/net/ip_fwchains"
#define PROC_NET_IP_FORWARD		"/proc/net/ip_forward"
#define PROC_NET_IP_BLOCK		"/proc/net/ip_block"
#define PROC_NET_IP_INPUT		"/proc/net/ip_input"
#define PROC_NET_IP_OUTPUT		"/proc/net/ip_output"
#define PROC_NET_IP_ACCT		"/proc/net/ip_acct"
#define PROC_NET_IPX_INTER		"/proc/net/ipx_interface"
#define PROC_NET_RARP			"/proc/net/rarp"
#define PROC_NET_ROUTE			"/proc/net/route"
#define PROC_NET_SNMP			"/proc/net/snmp"
#define PROC_SYS_NET_MAX_ALIAS	"/proc/sys/net/core/net_alias_max"
#define PROC_SYS_NET_IPV4_DYNADDR "/proc/sys/net/ipv4/ip_dynaddr"
#define PROC_SYS_IP_FORWARD		"/proc/sys/net/ipv4/ip_forward"
#define LIB_MODULES				"/lib/modules"

#endif

