#ifndef SYSINFO_H
#define SYSINFO_H

extern unsigned long Hertz;   /* clock tick frequency */
extern long smp_num_cpus;     /* number of CPUs */

#define JT unsigned long
extern void four_cpu_numbers(JT *uret, JT *nret, JT *sret, JT *iret);
#undef JT

extern int        uptime (double *uptime_secs, double *idle_secs);
extern void       loadavg(double *av1, double *av5, double *av15);

extern unsigned kb_main_buffers;
extern unsigned kb_main_cached;
extern unsigned kb_main_free;
extern unsigned kb_main_shared;
extern unsigned kb_main_total;
extern unsigned kb_swap_free;
extern unsigned kb_swap_total;
extern unsigned kb_swap_used; /* derived */
extern unsigned kb_main_used; /* derived */

extern void meminfo(void);

#endif /* SYSINFO_H */
