/*
 *	VME Linux/m68k Loader
 *
 *	(c) Copyright 1997 by Nick Holgate
 *
 *	This file is subject to the terms and conditions of the GNU General Public
 *	License.  See the file COPYING for more details.
 */

/*--------------------------------------------------------------------------*/

#include <stdarg.h>

/* linux specific include files */
#include <linux/a.out.h>
#include <linux/elf.h>
#include <linux/linkage.h>
#include <asm/page.h>

#include "config.h"

#include "version.h"
#include "bootinfo.h"
#include "stream.h"
#include "loaderdefs.h"

/*--------------------------------------------------------------------------*/

#ifndef SEEK_SET
#define	SEEK_SET	0				/* Seek from beginning of file.			*/
#define	SEEK_CUR	1				/* Seek from current position.			*/
#define	SEEK_END	2				/* Seek from end of file.				*/
#endif

#ifndef NULL
#define	NULL		((void *)0)
#endif

#define BCD2BIN(x)	(((x) >> 4) * 10 + ((x) & 0x0f))
#define VALUE(ptr)	((ptr) ? (*(ptr)) : 0)

/*--------------------------------------------------------------------------*/
/* Console Echo Modes
 */

#define ECHO_NONE	(0)
#define ECHO_NORMAL	(1)
#define ECHO_DOT	(2)

#define NO_TIMEOUT	(0)

/*--------------------------------------------------------------------------*/
/* image of machine registers passed in from boot roms
 */

typedef struct {
	unsigned long d[8];
	void		 *a[7];

} CALLREGS;

/*--------------------------------------------------------------------------*/
/* bootinfo (internal format)
 */

struct internal_bootinfo
{
	unsigned long	machtype;			/* machine type						*/
	unsigned long	cputype;			/* system CPU						*/
	unsigned long	fputype;			/* system FPU						*/
	unsigned long	mmutype;			/* system MMU						*/
	int				num_memory;			/* # of memory blocks found			*/
	struct mem_info memory[NUM_MEMINFO];/* memory description				*/
	struct mem_info ramdisk;			/* ramdisk description				*/
	char command_line[CL_SIZE];			/* kernel command line parameters	*/
};

/*--------------------------------------------------------------------------*/
/* declarations of stream modules
 */

extern MODULE file_mod;
extern MODULE gunzip_mod;

/* startcode declarations */
extern char startcode_beg;
extern char startcode_end;

/*--------------------------------------------------------------------------*/

#ifndef GLOBAL
#define GLOBAL	extern
#endif

struct loader_globals {
	const BOOTRECORD			*default_boot_record;
	BOOTOPTIONS					boot_options;
	BOOTRECORD					*boot_records;
	FILEDEF						*boot_files;
	unsigned long				map_offset;
	unsigned long				detected_mem_size;
	char						input_buffer[CL_SIZE];
	char						cmdln_buffer[CL_SIZE];
	char						sector_buffer[SECTOR_SIZE];
	Elf32_Ehdr					kexec_elf;
	struct internal_bootinfo	bi;
	unsigned char				cpu_type;
	unsigned char				fpu_type;

#ifdef BOOTINFO_COMPAT_1_0
	struct compat_bootinfo		compat_bootinfo;
#endif /* BOOTINFO_COMPAT_1_0 */

#define MAX_BI_SIZE				(4096)
	unsigned long				bi_size;
	union {
		struct bi_record		record;
		unsigned char			fake[MAX_BI_SIZE];
	} bi_union;

	void						(*startcode_entry)(void);
	int							leader_adjust;
	char						force_prompt;
	char						debug_mode;
	char						callmonitor;
	char						master_mode;
};

GLOBAL struct loader_globals	*v;

#define IOBUF_SIZE				(4096)
#define STACK_SIZE				(8192)

/*--------------------------------------------------------------------------*/
/* Prototypes for utility functions
 */

void loader_init (CALLREGS *regs);
void put_char (const int c);
unsigned long get_time (void);
int get_char (unsigned long timeout);
int disk_read (void *buf,unsigned long sector,unsigned long extent);
unsigned long get_compat_booti_version (void);
unsigned long get_booti_version (void);
unsigned long get_compat_machtype (void);
unsigned long get_machtype (void);
#if SYMBOL_SUPPORT
void clear_symbols (void);
int add_symbol (char *data);
#endif
void print_model (void);
int add_vme_bootinfo (void);
void call_bug (void);

/* prototypes for file "loaderlib.c" */
void malloc_init (void *heap_base,unsigned long heap_size);
void * malloc (unsigned long size);
int free (void *memaddr);
void mem_clear (void *mem,unsigned long count);
void mem_move (void *dest,const void *srce,unsigned long count);
int mem_cmp (void *mem1,void *mem2,unsigned long count);
void disable_icache (unsigned char);
void enable_icache (unsigned char);
void invalidate_icache (unsigned char);
unsigned char get_cpu_type (void);
unsigned char get_fpu_type (void);
#if MEMORY_SIZE == 0
int ram_probe (unsigned long where);
#endif
int strlen (const char *s);
char * strcpy (char *d,const char *s);
void strcat (char *d,const char *s);
void strcatn (char *d,const char *s,unsigned long n);
void strncpy (char *d,const char *s,unsigned long n);
int vsoutput (void (*output)(const int),const char *fmt,va_list va);
int sprintf (char *buff,const char *fmt,...);
int printf (const char *fmt,...);
int put_str (const char *str);
void panic (const char *fmt,...);
int prefix_string (const char *s,const char *p);
int equal_strings (const char *s1,const char *s2);
int case_equal_strings (const char *s1,const char *s2);
int file_size (const char *path);
int file_open (const char *path);
long file_tell (void);
int file_seek (int where,int whence);
int file_read (char *buf,int count);
void file_close (void);
void percent_init (unsigned long total);
void percent_term (const char *msg);
void percent_show (unsigned long current);


/* prototypes for file "loader.c" */
int read_line (int mode,unsigned long timeout);
const FILEMAP * find_file_map (const char *path);
void show_tag (const TAGRECORD *tr);
const char * get_tag_name (unsigned long tag);
void unexpected_tag (const TAGRECORD *tr);
const TAGRECORD * get_first_tag (void);
const TAGRECORD * get_next_tag (void);
void get_debug_tag (void);
void read_map_data (void);
const BOOTRECORD * find_boot_record (char *name);
int bootrecord_available (const BOOTRECORD *record);
void list_records (void);
const BOOTRECORD * get_boot_record (unsigned long timeout);
void loading (const char *what);
#if SYMBOL_SUPPORT
void load_symbols (const char *file_name);
#endif
void display_message_file (const char *file_name);
int check_bootinfo_version (const char *memptr);
int add_bi_record (unsigned short tag,unsigned short size,const void *data);
int add_bi_string (unsigned short tag,const unsigned char *s);
int create_bootinfo (void);
#if BOOTINFO_COMPAT_1_0
int create_compat_bootinfo (void);
#endif
void start_kernel (void (*startcode_entry)(void),unsigned long kernel_dest_addr,char *kernel_load_addr,unsigned long kernel_mem_size,unsigned long ramdisk_dest_addr,char *ramdisk_load_addr,unsigned long ramdisk_mem_size,int call_monitor);
char * load_kernel (const char *file_name,unsigned long mem_start,unsigned long *kernel_size,unsigned long extra_size);
void boot_linux (const BOOTRECORD *boot_record);
void start_loader (void);
void Main (CALLREGS *regs);

/*-----------------------------< end of file >------------------------------*/

