#include <stdio.h>
#include <stdlib.h>

#include "gs_token.h"
#include "gs_list.h"
#include "gs_type.h"

#include "common/common.h"

/* -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- */
int gs_isidentifier(TOKEN *item)
{
	if (item != NULL)
	{
		if (item->ptr_type == TP_STRING)
		{	return TRUE;
		}
	}

	return FALSE;
}


/* -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- */
int gs_isdictionary(TOKEN *item)
{
	if (item != NULL)
	{
		if (item->ptr_type == TP_DICTIONARY)
		{	return TRUE;
		}
	}

	return FALSE;
}


/* -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- */
int gs_islist(TOKEN *item)
{
	if (item != NULL)
	{
		if (item->ptr_type == TP_LIST)
		{	return TRUE;
		}
	}

	return FALSE;
}


/* -------------------------------------------------------------------- */
/* Return Values:							*/
/*									*/
/*	TRUE  if Item is a simple data item				*/
/* 	FALSE if Item is an 'Identifier', 'Dictionary' or 'List'	*/
/*									*/
/* -------------------------------------------------------------------- */
int gs_isdata(TOKEN *item)
{
	return (!(gs_isidentifier(item) || gs_isdictionary(item) || gs_islist(item)));
}
