// FIFO_Send.cpp
// $Id: FIFO_Send.cpp,v 4.6 1999/07/05 09:52:51 nanbor Exp $

/* -*- C++ -*- */

#define ACE_BUILD_DLL
#include "ace/FIFO_Send.h"

#if defined (ACE_LACKS_INLINE_FUNCTIONS)
#include "ace/FIFO_Send.i"
#endif

ACE_RCSID(ace, FIFO_Send, "$Id: FIFO_Send.cpp,v 4.6 1999/07/05 09:52:51 nanbor Exp $")

ACE_ALLOC_HOOK_DEFINE(ACE_FIFO_Send)

void
ACE_FIFO_Send::dump (void) const
{
  ACE_TRACE ("ACE_FIFO_Send::dump");
  ACE_FIFO::dump ();
}

ACE_FIFO_Send::ACE_FIFO_Send (void)
{
//  ACE_TRACE ("ACE_FIFO_Send::ACE_FIFO_Send");
}

int
ACE_FIFO_Send::open (const ASYS_TCHAR *rendezvous_name,
                     int flags,
                     int perms,
                     LPSECURITY_ATTRIBUTES sa)
{
  ACE_TRACE ("ACE_FIFO_Send::open");
  return ACE_FIFO::open (rendezvous_name,
                         flags | O_WRONLY,
                         perms,
                         sa);
}

ACE_FIFO_Send::ACE_FIFO_Send (const ASYS_TCHAR *fifo_name,
                              int flags,
                              int perms,
                              LPSECURITY_ATTRIBUTES sa)
{
  ACE_TRACE ("ACE_FIFO_Send::ACE_FIFO_Send");
  if (this->ACE_FIFO_Send::open (fifo_name,
                                 flags,
                                 perms,
                                 sa) == -1)
    ACE_ERROR ((LM_ERROR,
                ASYS_TEXT ("%p\n"),
                ASYS_TEXT ("ACE_FIFO_Send::ACE_FIFO_Send")));
}
