%{
/*
 *  agParse.y
 *  $Id: agParse.y,v 2.5 1999/07/07 19:42:33 bkorb Exp $
 *  Parse rules for the macro definitions
 */

/*
 *  AutoGen copyright 1992-1999 Bruce Korb
 *
 *  AutoGen is free software.
 *  You may redistribute it and/or modify it under the terms of the
 *  GNU General Public License, as published by the Free Software
 *  Foundation; either version 2, or (at your option) any later version.
 *
 *  AutoGen is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with AutoGen.  See the file "COPYING".  If not,
 *  write to:  The Free Software Foundation, Inc.,
 *             59 Temple Place - Suite 330,
 *             Boston,  MA  02111-1307, USA.
 */


/*
 *  Declarations
 */
#include "autogen.h"

extern YYSTYPE addSibMacro( YYSTYPE, YYSTYPE );
extern YYSTYPE makeTextMacro( YYSTYPE, YYSTYPE );
extern YYSTYPE makeBlockMacro( YYSTYPE, YYSTYPE );
extern YYSTYPE findPlace( YYSTYPE, YYSTYPE );
extern YYSTYPE identify( YYSTYPE );

%}

%start definitions

/*
 * Keywords
 */
%token TK_AUTOGEN TK_DEFINITIONS

%token TK_END TK_VAR_NAME TK_OTHER_NAME TK_STRING TK_NUMBER


%% /* * * * *  RULES * * * * */
definitions     : identity def_list TK_END
                    {
                        $$ = makeBlockMacro( (YYSTYPE)&rootEntry, $2 );
                    }
                ;

/*
 *  The marker_list definition is in bison (list-first) order.
 *  It should be reversed for yacc
 */
def_list        : definition           { $$ = $1; }
                | definition def_list  { $$ = addSibMacro( $1, $2 ); }
                | identity   def_list  { $$ = $2; }
                ;


definition      : place ';'
                    { $$ = makeTextMacro( $1, (YYSTYPE)"" ); }

                | place '=' anystring ';'
                    { $$ = makeTextMacro( $1, $3 ); }

                | place '=' '{' def_list '}' ';'
                    { $$ = makeBlockMacro( $1, $4 ); }
                ;

identity        : TK_AUTOGEN TK_DEFINITIONS anyname ';'
                    { $$ = identify( $3 ); }
                ;

anystring       : anyname   { $$ = $1; }
                | TK_STRING { $$ = $1; }
                | TK_NUMBER { $$ = $1; }
                ;

anyname         : TK_OTHER_NAME { $$ = $1; }
                | TK_VAR_NAME   { $$ = $1; } ;


place           : TK_VAR_NAME
                    { $$ = findPlace( $1, (YYSTYPE)NULL ); }

                | TK_VAR_NAME '[' TK_NUMBER ']'
                    { $$ = findPlace( $1, $3 ); }

                | TK_VAR_NAME '[' TK_VAR_NAME ']'
                    { $$ = findPlace( $1, $3 ); }
                ;
