(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                 ProPre.v                                 *)
(****************************************************************************)

(* Grammaire de ProPre : "Recursive Definition" *)

Declare ML Module "Propre".

Grammar vernac eqs_def1: List :=
  eqs_cons [ "|" command:ne_command_list($ts) "=>" command:command($u)
             eqs_def1($es) ]
    -> [ (COMMANDLIST $u ($LIST $ts)) ($LIST $es)]
| eqs_nil [ ] -> [ ].

Grammar vernac eqs_def: List :=
  eqs_def [command:ne_command_list($ts) "=>" command:command($u) eqs_def1($es)]
    -> [(COMMANDLIST $u ($LIST $ts)) ($LIST $es)].

Grammar vernac vernac :=
  rec_def [ "Recursive"  "Definition" identarg($id_f) indpar($prms_f)
    ":" comarg($type_f) " := " eqs_def($eqs_f) "." ]
   -> [(RecursiveDefinition $id_f $prms_f $type_f ($LIST $eqs_f))].


(* $Id: ProPre.v,v 1.9 1999/06/29 07:47:57 loiseleu Exp $ *)
