(**************************************************************************
  *********                    ntaux.mli                          *********
  **************************************************************************)
open Term;;
open More_util;;
open Ntdef;;

(*misc *)
val nc_suppress_annotation : natural_constr -> natural_constr;;

val nc_rec_suppress_annotation : natural_constr -> natural_constr;;

val nc_is_type_False : constr -> bool;;

val select_list_of_DOPN :
      (natural_constr -> bool) -> natural_constr -> natural_constr list;;

val select_DOPN_first :
      (natural_constr -> bool) -> natural_constr -> natural_constr;;

val flat_map_list_of_DOPN :
      (natural_constr -> natural_constr list) -> natural_constr -> natural_constr list;;

(*** text_info **
  lambda *)
val nc_lambda_case : natural_constr -> bool;;

val nc_lambda_sort : natural_constr -> nt_sort;;

val nc_lambda_var_right : natural_constr -> int;;

val nc_lambda_var_list_length : natural_constr -> int;;

val nc_lambda_type_right : natural_constr -> int;;

val nc_lambda_sort_right : natural_constr -> int;;

val nc_lambda_coord : natural_constr -> nt_coord;;

val nc_is_lambda_right_0 : natural_constr -> bool;;

val nc_is_lambda_in_case : natural_constr -> bool;;

val nc_lambda_nat : natural_constr -> nt_lambda_nat;;

val nc_lambda_typ_is_a_sort : natural_constr -> sorts option;;

val nc_set_lambda_in_case : nt_lambda_in_case -> natural_constr -> unit;;

val nc_set_n_lambda_in_case :
      int -> nt_lambda_in_case -> natural_constr -> unit;;

val nc_is_lambda_var_list_anonymous : natural_constr -> bool;;

(*apply *)
val nc_is_apply_head_up : natural_constr -> bool;;

val nc_apply_subs_number : natural_constr -> int;;

val nc_nbr_elim_cases : natural_constr -> int;;

(*id *)
val nc_is_immediate_hypothesis : natural_constr -> bool;;

val nc_id_nat : natural_constr -> nt_id_nat;;

(*id *)
val nc_is_identifier : natural_constr -> bool;;

val nc_is_construct : natural_constr -> bool;;

(*** text_arg **
  apply_sub *)
(*elim_head *)
(*elim_case *)
val nc_elim_case_nat : natural_constr -> nt_case_nat;;

val nc_is_case_of_induc_elim : natural_constr -> bool;;

val nc_is_induc_case : natural_constr -> bool;;

val nc_is_some_case_number : natural_constr -> bool;;

(*** text_type ***)
val nc_number_of_types : natural_constr -> int;;

val nc_is_type_expected : natural_constr -> bool;;

val nc_is_type_used : natural_constr -> bool;;

val nc_are_sev_types_used : natural_constr -> bool;;

val nc_set_type_use : bool -> natural_constr -> unit;;

val nc_set_first_type_use : bool -> natural_constr -> unit;;

val nc_get_type_list_if_used : natural_constr -> constr list;;

val nc_get_type_list : natural_constr -> constr list;;

val nc_is_concl_false : natural_constr -> bool;;

(*** text_format ***)
val nc_select_rule_family : int -> natural_constr -> char;;

val nc_select_rule : char -> natural_constr -> string;;

val nc_select_elements : char -> natural_constr -> int;;

val nc_set_type_pos : bool * bool -> natural_constr -> unit;;

(*** text_dot ***)
val nc_dot : int -> natural_constr -> char;;

val nc_is_with_dot : natural_constr -> bool;;

