(**************************************************************************
  *********                          ntdata.ml                    *********
  **************************************************************************)
open Generic;;
open Term;;
open More_util;;
open Std;;
open Names;;
open Termenv;;
open Ntdef;;
open Tutil;;
open Ntparam;;
open Ntaux;;
open Ntsons;;

(**************************************************************************
  **                               metavar                               **
  **************************************************************************)
let nc_loc_fun_data_metavar_in_apply_head nc =
 match nc with
 | DOP1 (note, (DOPN ((Inl AppL as op), v))) ->
  (match v.(0) with
  | DOP1 ((Inr ({n_i=Ni_metavar _ as n_i})), (DOP0 (Inl (Meta _)))) ->
   nc_set_n_i n_i nc; DOP1 (note, DOPN (op, Array.map nc_suppress_annotation v))
  | _ -> nc)
 | _ -> nc;;

(**************************************************************************
  **                                types                                **
  **************************************************************************)
let nc_loc_data_double_type rc nc =
 let rec f =
  function
     | t1 :: (t2 :: l) -> if immediate_conv rc t1 t2 then f (t1::l)
                           else t1::f (t2::l)
     | l -> l in
 let expected, used, first_used, type_l = nc_get_n_t nc in
 let type_l = f type_l in
 nc_set_n_t (expected, used, first_used, type_l) nc;;

let nc_glob_data_suppress_extern_type nc =
 match nc_get_n_t nc with
 | true, use, first_used, (_ :: l) -> nc_set_n_t (true, use, first_used, l) nc
 | _ -> ();;

(**************************************************************************
  **                              to elim                                **
  **************************************************************************)
let rec study_last_product i t =
 match t with
 | DOP2 (Prod, typ, (DLAM (na, t'))) ->
  let t' = strip_outer_cast t' in
  (match t' with
   | DOP2 (Prod, _, _) -> study_last_product (i + 1) t'
   | _ ->
    let cst, spi =
     match apply_head typ with
     | DOPN ((MutInd (x0,x1)), _) as cst -> cst, (x0,x1)
     | _ -> raise (Failure "elim")
    and p =
     match apply_head t' with
     | Rel j -> i + 1 - j
     | _ -> raise (Failure "elim") in
    i + 1, cst, spi, p)
 | _ -> raise (Failure "elim");;

let rec study_base_case t =
 match strip_outer_cast t with
 | DOP2 (Prod, typ, (DLAM (na, t'))) -> false::study_base_case t'
 | _ -> [];;

let rec study_induc_case i t =
 match strip_outer_cast t with
 | DOP2 (Prod, typ, (DLAM (na, t'))) ->
  dependent (Rel i) typ::study_induc_case (i + 1) t'
 | _ -> [];;

let rec study_args_product cst p i t =
 match t with
 | DOP2 (Prod, typ, (DLAM (na, t'))) ->
  let t' = strip_outer_cast t' in
  let arg = if dependent (Rel 1) t' then None
   else
   (if p >= i then raise (Failure "elim");
  Some (if dependent cst typ then (true, study_induc_case (p - i) typ)
   else (false, study_base_case typ))) in
  arg::study_args_product cst p (i + 1) t'
 | _ -> [];;

let rec annote_case_lambda l nc =
 match l with
 | induc :: l' -> nc_set_lambda_in_case (Some induc) nc; (match nc with
  | DOP1 ((Inr ({n_i=Ni_lambda _})), _) ->
   annote_case_lambda l' (nc_lambda_son nc)
  | _ -> ())
 | [] -> ();;

let annote_arg induc_elim (nc, data) =
 match nc_get_n_a nc, data with
 | (Na_app_son (use, son_apply, _)), (Some (ind, l)) -> annote_case_lambda l nc;
  let ind_case = if induc_elim then Some ind
   else None
  and n_lamb = List.length l in
  let son_elim = Nase_case (false, ind_case, n_lamb, Ncn_std, Some []) in
  let n_a = Na_app_son (use, son_apply, son_elim) in
  nc_set_n_a n_a nc
 | (Na_app_son (use, son_apply, _)), None ->
  let son_elim = Nase in
  let n_a = Na_app_son (use, son_apply, son_elim) in
  nc_set_n_a n_a nc
 | _ -> raise (Failure "elim");;

let annote_destruct dep nc =
 match nc_get_n_a nc with
 | Na_app_son (use, son_apply, _) ->
  let son_elim = Nase_destruct dep in
  let n_a = Na_app_son (use, son_apply, son_elim) in
  nc_set_n_a n_a nc
 | _ -> raise (Failure "elim");;

let combine (l1, l2) =
 try List.combine l1 l2
 with
 | Invalid_argument "combine" -> raise (Failure "elim");;

let nc_loc_data_to_elim rc nc =
 match nc_get_n_i nc, nc_body nc with
 | (Ni_app ((data_apply, _), use_count)), (DOPN ((Inl AppL), v)) ->
  (match nc_body v.(0) with
  | DOPN ((Inl (Const sp)), _) -> begin
    try let t = strip_outer_cast (const_type rc (c_of_nc v.(0))) in
        let nbr_prod, cst, spi, p = study_last_product 0 t in
        if nbr_prod <> Array.length v - 1 then raise (Failure "elim");
        let destruct, dep, args_l =
         let
         l = List.rev (combine (List.tl (Array.to_list v), study_args_product cst p 0 t))
         in
         fst (List.hd l), snd (List.hd l) = None, List.tl l in
        let induc = List.exists (function
            | _, (Some (true, _)) -> true
            | _ -> false) args_l
        and omit = ref_set_mem spi elim_omit_cst_set in
        let data_elim = Some (induc, omit, cst) in
        let n_i = Ni_app (
         (data_apply, data_elim), use_count) in
        List.iter (annote_arg induc) args_l;
        annote_destruct dep destruct;
        nc_set_n_i n_i nc
    with
    | Failure "elim" | Invalid_argument "combine" -> ()
  end
  | _ -> ())
 | _ -> ();;

(**************************************************************************
  **                             lambda elim                             **
  **************************************************************************)
let nc_loc_data_lambda_elim nc =
 match nc_get_n_i nc with
 | Ni_lambda ((_, (No1, _), _ as data), _, use_count) ->
  let son = nc_lambda_son nc in
  (match nc_get_n_i son with
   | Ni_app ((_, (Some (false, _, cst))), _) ->
    (match nc_elim_head son with
    | DOP1 (_, (Rel 1)) ->
     let data_elim = cst in
     let n_i = Ni_lambda (data, Some data_elim, use_count) in
     nc_set_n_i n_i nc
    | _ -> ())
   | _ -> ())
 | _ -> ();;

