(**************************************************************************
  *********                    ntparam.ml                         *********
  **************************************************************************)

open Generic;;
open Term;;
open Names;;
open Reduction;;
open Std;;
open Pp;;
open Mach;;
open Machops;;
open Termenv;;

open More_util;;
open Vectops;;

(***************************************************************************)
(* DEBUT MODIFICATION POUR PRISE EN COMPTE PAR RESET *)
(* all tables of parameters are collected in one table *)

(***************************************************************************)
type 'a nt_list = 'a list

let ref_list_init l = l:=[];;

let ref_list_mem x l = List.mem x !l;;

let ref_list_add x l = if (not (List.mem x !l)) then l:=x::!l;;

let ref_list_remove x l = l:=subtract !l [x];;

let ref_list_elements l = !l;;

(***************************************************************************)
type 'a nt_set = 'a Coq_set.t;;

let ref_set_init s = s:=Coq_set.empty;;

let ref_set_mem x s = Coq_set.mem x !s;;

let ref_set_add x s = s:=(Coq_set.add x !s);;

let ref_set_remove x s = s:=(Coq_set.remove x !s);;

let ref_set_elements s = Coq_set.elements !s;;

(***************************************************************************)
(* declaration of the ParamText "summary" *)
type nt_param_set_type =
  {apply_omit_construct_set: ((section_path * int) * int) Coq_set.t ref;
   apply_omit_const_set: section_path Coq_set.t ref;
   elim_omit_cst_set: (section_path * int) Coq_set.t ref;
   apply_rec_sub_construct_set: ((section_path * int) * int) Coq_set.t ref;
   apply_rec_sub_const_set: section_path Coq_set.t ref;
   elim_rec_sub_set: (section_path * int) Coq_set.t ref;
   immediate_elim_set: (section_path * int) Coq_set.t ref;
   immediate_delta_red_list : section_path list ref};;

let nt_param_set =
  {apply_omit_construct_set = ref Coq_set.empty;
   apply_omit_const_set = ref Coq_set.empty;
   elim_omit_cst_set = ref Coq_set.empty;
   apply_rec_sub_construct_set = ref Coq_set.empty;
   apply_rec_sub_const_set = ref Coq_set.empty;
   elim_rec_sub_set = ref Coq_set.empty;
   immediate_elim_set = ref Coq_set.empty;
   immediate_delta_red_list = ref []};;

let init_param () =
  nt_param_set.apply_omit_construct_set:=Coq_set.empty;
  nt_param_set.apply_omit_const_set:=Coq_set.empty;
  nt_param_set.elim_omit_cst_set:=Coq_set.empty;
  nt_param_set.apply_rec_sub_construct_set:=Coq_set.empty;
  nt_param_set.apply_rec_sub_const_set:=Coq_set.empty;
  nt_param_set.elim_rec_sub_set:=Coq_set.empty;
  nt_param_set.immediate_elim_set:=Coq_set.empty;
  nt_param_set.immediate_delta_red_list:=[];;

let freeze_param () =
 {apply_omit_construct_set = ref !(nt_param_set.apply_omit_construct_set);
  apply_omit_const_set = ref !(nt_param_set.apply_omit_const_set);
  elim_omit_cst_set = ref !(nt_param_set.elim_omit_cst_set);
  apply_rec_sub_construct_set =ref !(nt_param_set.apply_rec_sub_construct_set);
  apply_rec_sub_const_set = ref !(nt_param_set.apply_rec_sub_const_set);
  elim_rec_sub_set = ref !(nt_param_set.elim_rec_sub_set);
  immediate_elim_set = ref !(nt_param_set.immediate_elim_set);
  immediate_delta_red_list = ref !(nt_param_set.immediate_delta_red_list)};;

let unfreeze_param s =
  nt_param_set.apply_omit_construct_set := !(s.apply_omit_construct_set);
  nt_param_set.apply_omit_const_set := !(s.apply_omit_const_set);
  nt_param_set.elim_omit_cst_set := !(s.elim_omit_cst_set);
  nt_param_set.apply_rec_sub_construct_set := !(s.apply_rec_sub_construct_set);
  nt_param_set.apply_rec_sub_const_set := !(s.apply_rec_sub_const_set);
  nt_param_set.elim_rec_sub_set := !(s.elim_rec_sub_set);
  nt_param_set.immediate_elim_set := !(s.immediate_elim_set);
  nt_param_set.immediate_delta_red_list := !(s.immediate_delta_red_list);;

Summary.declare_summary "TextParam"
 {Summary.freeze_function = freeze_param;
  Summary.unfreeze_function = unfreeze_param;
  Summary.init_function = init_param}
;;

(* 2: declaration of the PARAMTEXT object *)

type nt_param =
| Apply_omit_construct of ((section_path * int) * int)
| Apply_omit_const of section_path
| Elim_omit_cst of (section_path * int)
| Apply_rec_sub_construct of ((section_path * int) * int)
| Apply_rec_sub_const of section_path
| Elim_rec_sub of (section_path * int)
| Immediate_elim of (section_path * int)
| Immediate_delta_red of section_path;;

type nt_param_flag = Nt_remove | Nt_add;;

let cache_param (_,(f,p)) =
  if f=Nt_add then
  match p with
| Apply_omit_construct x -> ref_set_add x nt_param_set.apply_omit_construct_set
| Apply_omit_const x -> ref_set_add x nt_param_set.apply_omit_const_set
| Elim_omit_cst x -> ref_set_add x nt_param_set.elim_omit_cst_set
| Apply_rec_sub_construct x
                  -> ref_set_add x nt_param_set.apply_rec_sub_construct_set
| Apply_rec_sub_const x -> ref_set_add x nt_param_set.apply_rec_sub_const_set
| Elim_rec_sub x -> ref_set_add x nt_param_set.elim_rec_sub_set
| Immediate_elim x -> ref_set_add x nt_param_set.immediate_elim_set
| Immediate_delta_red x -> ref_list_add x nt_param_set.immediate_delta_red_list
  else
  match p with
| Apply_omit_construct x
        -> ref_set_remove x nt_param_set.apply_omit_construct_set
| Apply_omit_const x -> ref_set_remove x nt_param_set.apply_omit_const_set
| Elim_omit_cst x -> ref_set_remove x nt_param_set.elim_omit_cst_set
| Apply_rec_sub_construct x
        -> ref_set_remove x nt_param_set.apply_rec_sub_construct_set
| Apply_rec_sub_const x
        -> ref_set_remove x nt_param_set.apply_rec_sub_const_set
| Elim_rec_sub x -> ref_set_remove x nt_param_set.elim_rec_sub_set
| Immediate_elim x -> ref_set_remove x nt_param_set.immediate_elim_set
| Immediate_delta_red x 
        -> ref_list_remove x nt_param_set.immediate_delta_red_list;;

let specification_param fp = fp;;

let (inTextParam,outTextParam) =
    Libobject.declare_object ("TEXTPARAM",
                    {Libobject.load_function = (fun _ -> ());
                     Libobject.cache_function = cache_param;
                     Libobject.specification_function = specification_param});;

(* Les fonctions d'interface *)

let add_param x = Library.add_anonymous_object (inTextParam (Nt_add,x));;

let remove_param x = Library.add_anonymous_object (inTextParam (Nt_remove,x));;

(* Actuellement inutile car l'interface avec ntcommand continue a se
   faire par les ref_mem_*_{set,list} *)
let mem_param p =
  match p with
| Apply_omit_construct x -> ref_set_mem x nt_param_set.apply_omit_construct_set
| Apply_omit_const x -> ref_set_mem x nt_param_set.apply_omit_const_set
| Elim_omit_cst x -> ref_set_mem x nt_param_set.elim_omit_cst_set
| Apply_rec_sub_construct x
                  -> ref_set_mem x nt_param_set.apply_rec_sub_construct_set
| Apply_rec_sub_const x -> ref_set_mem x nt_param_set.apply_rec_sub_const_set
| Elim_rec_sub x -> ref_set_mem x nt_param_set.elim_rec_sub_set
| Immediate_elim x -> ref_set_mem x nt_param_set.immediate_elim_set
| Immediate_delta_red x -> ref_list_mem x nt_param_set.immediate_delta_red_list

let apply_omit_construct_set = nt_param_set.apply_omit_construct_set;;
let apply_omit_const_set = nt_param_set.apply_omit_const_set;;
let elim_omit_cst_set = nt_param_set.elim_omit_cst_set;;
let apply_rec_sub_construct_set = nt_param_set.apply_rec_sub_construct_set;;
let apply_rec_sub_const_set = nt_param_set.apply_rec_sub_const_set;;
let elim_rec_sub_set = nt_param_set.elim_rec_sub_set;;
let immediate_elim_set = nt_param_set.immediate_elim_set;;
let immediate_delta_red_list = nt_param_set.immediate_delta_red_list;;

(* FIN MODIFICATION POUR PRISE EN COMPTE PAR RESET *)

(**************************************************************************
  **************************************************************************)
let ref_False = ref mkImplicit;;

let init_False s =
  ref_False := global (gLOB nil_sign) (id_of_string "False");;

let is_False c = conv (Evd.mt_evd()) c !ref_False;;
(**************************************************************************
  **************************************************************************)
let is_const_defined sp =
 let lobj = Lib.map_leaf (objsp_of sp) in
 let tag = Libobject.object_tag lobj in
 match tag with
  | "CONSTANT" ->
   let cmap, _, _ = Environ.outConstant lobj in
   let {Constrtypes.cONSTBODY=val0} = Listmap.map cmap CCI in
   (match val0 with
    | Some _ -> true
    | None -> false)
  | _ -> false;;

(**************************************************************************
  **************************************************************************)
let rec change_type_names c t =
 match strip_outer_cast c, strip_outer_cast t with
 | (DOP2 (Lambda, _, (DLAM (na, c')))), (DOP2 (Prod, typ, (DLAM (_, t')))) ->
  let t' = change_type_names c' t' in
  DOP2 (Prod, typ, DLAM (na, t'))
 | _ -> t;;

let rec try_red_to_prod rc c =
 let c = whd_betaiota c in
 match c with
  | DOP2 (Prod, _, _) -> c
  | DOPN ((Const _), _) -> begin
    try try_red_to_prod rc (const_value rc c)
    with
    | _ -> c
  end
  | DOPN (AppL, cv) ->
   (match cv.(0) with
   | DOPN ((Const _), _) as head -> begin
     try let head = const_value rc head in
         try_red_to_prod rc (DOPN (AppL, cons_vect head (tl_vect cv)))
     with
     | _ -> c
   end
   | _ -> c)
  | _ -> c;;

let rec try_immediate_red_to_prod rc c =
 let c = whd_betaiota c in
 match c with
  | DOP2 (Prod, _, _) -> c
  | DOPN ((Const _), _) -> begin
    try try_red_to_prod rc (const_value rc c)
    with
    | _ -> c
  end
  | DOPN (AppL, cv) ->
   (match cv.(0) with
   | DOPN ((Const sp), _) as head ->
    if List.mem sp !immediate_delta_red_list then begin
      try let head = const_value rc head in
          try_red_to_prod rc (DOPN (AppL, cons_vect head (tl_vect cv)))
      with
      | _ -> c
    end
     else c
   | _ -> c)
  | _ -> c;;

let force_red_to_prod rc c =
 let c = try_red_to_prod rc c in
 match c with
  | DOP2 (Prod, _, (DLAM _)) -> c
  | _ ->
   errorlabstrm "ntparam__force_red_to_prod"
    [< 'sTR "not reducible to a product" >];;

(**************************************************************************
  **************************************************************************)
let immediate_conv rc c c' =
 eq_constr
   (nf_betaiota (strong (whd_const !immediate_delta_red_list rc) c))
   (nf_betaiota (strong (whd_const !immediate_delta_red_list rc) c'));;

let immediate_prod_conv rc t t' =
 match try_immediate_red_to_prod rc t with
 | DOP2 (Prod, _, (DLAM (_, t))) -> immediate_conv rc t t'
 | _ -> false;;

(*|let immediate_conv_prod rc c c' =
  | let f_red c = whd_const !immediate_delta_red_list rc c in
  | match try_red_to_prod rc c with
  |  | DOP2 (Prod, _, (DLAM (_, c))) -> immediate_conv rc c c'
  |  | _ -> false;;*)
(**************************************************************************
  **************************************************************************)
let projector_list = ref [];;

let add_to_projector_list (construct, proj_l) =
 let ctr =
  match global (gLOB (Vartab.initial_sign ())) (id_of_string construct) with
  | DOPN ((MutConstruct (x0,x1)), _) -> (x0,x1)
  | _ ->
   errorlabstrm "natural__add_to_projector_list"
    [< 'sTR (construct ^ " is not an inductive constructor.") >] in
 let sp_l = List.map (function str ->
  (match global (gLOB (Vartab.initial_sign ())) (id_of_string str) with
  | DOPN ((Const sp), _) -> sp
  | _ ->
   errorlabstrm "natural__add_to_projector_list"
    [< 'sTR (str ^ " is not a defined constant.") >])) proj_l in
 projector_list:=(ctr, sp_l)::!projector_list;;

let suppress_from_projector_list construct =
 let ctr =
  match global (gLOB (Vartab.initial_sign ())) (id_of_string construct) with
  | DOPN ((MutConstruct (x0,x1)), _) -> (x0,x1)
  | _ ->
   errorlabstrm "natural__add_to_projector_list"
    [< 'sTR (construct ^ " is not an inductive constructor.") >] in
 let rec f =
  function
     | x :: l' as l -> begin
       try if ctr = fst x then f l'
        else x::f l
       with
       | Failure "identical" -> l
     end
     | [] -> raise (Failure "identical") in
 if !projector_list <> [] then projector_list:=f !projector_list;;

let clear_projector_list () = projector_list:=[];;

let red_record rc c =
 let c = whd_betaiota (whd_const !immediate_delta_red_list rc c) in
 try match c with
  | DOPN (AppL, cv) when Array.length cv = 2 ->
   (match cv.(0), cv.(1) with
   | (DOPN ((Const sp), _)), (DOPN (AppL, cv')) ->
    (match cv'.(0) with
    | DOPN ((MutConstruct (x0,x1)), _) when List.mem sp (List.assoc (x0,x1) !projector_list) ->
     whd_betaiota (DOPN (AppL, [|const_value rc cv.(0); cv.(1)|]))
    | _ -> raise (Failure "not ok"))
   | _ -> raise (Failure "not_ok"))
  | _ -> raise (Failure "not_ok")
 with
 | _ -> c;;

let red_to_show rc t = nf_betaiota (strong (red_record rc) t);;

(*let red_to_show rc t = nf rc t;;
  *************************************************************************
  **************************************************************************)
let inc i = i:=!i + 1;;

let is_constr_id c =
 match strip_outer_cast c with
 | DOP0 (Sort _) | Rel _ | VAR _ | DOPN ((Const _), _) | DOPN ((MutInd _), _)
   | DOPN ((MutConstruct _), _) -> true
 | _ -> false;;

let is_constr_var c =
 match strip_outer_cast c with
 | Rel _ | VAR _ -> true
 | _ -> false;;
(***************************************************************************)
