(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                               TypeSyntax.v                               *)
(****************************************************************************)

(*********************************************************)
(*        Or and Exist in Type                           *)
(*                                                       *)
(*********************************************************)

(**********)
Inductive sumboolT [A,B:Prop]:Type:=
   leftT : A->(sumboolT A B)
  |rightT: B->(sumboolT A B).

(**********)
Inductive sumorT [A:Type;B:Prop]:Type:=
   inleftT : A->(sumorT A B)
  |inrightT: B->(sumorT A B).

(**********)
Inductive sigT [A:Set;P:A->Prop]:Type:=
   existT: (x:A)(P x)->(sigT A P).

(**********)
Inductive sigTT [A:Type;P:A->Prop]:Type:=
   existTT: (x:A)(P x)->(sigTT A P).

(* $Id: TypeSyntax.v,v 1.3 1999/07/08 21:55:41 mayero Exp $ *)
