-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description:	"This class is responsible for generating the eiffel code"
	author:			"Daniel Elphick <de397@ecs.soton.ac.uk>"

class CODE_GENERATOR

inherit

	GLOBALS

creation
	make

feature
	
	program_name: STRING
	directory: STRING
	src_directory: STRING
	interface: TAG_TREE
	root_class: ROOT_CLASS_WRITER
	top_level_class: TOP_LEVEL_CLASS_WRITER
	custom_class: CUSTOM_CLASS_WRITER

	make(tree: TAG_TREE; dirname: STRING) is
			-- Writes all the source files into the specified
			-- directory (if empty, current directory)
		require
			valid_tree: tree /= Void
		local
			temp_tree: TAG_TREE
			project: TAG_TREE
		do
			interface := tree.find_child("GTK-Interface")
			if interface = Void then
				print("GTK-Interface tag must be at root%N")
				die_with_code(exit_failure_code)
			end
			project := interface.find_child("project")
			if project = Void then
				print("GTK-Interface must have a project tag%N")
				die_with_code(exit_failure_code)
			end
			set_project_name(project.get_string_from_field("name"))
			program_name := project.get_string_from_field("program_name")
			-- Code to find the directory
			-- however I think this is useless as I've never seen glade fill
			-- this field in!
			temp_tree := project.find_child("directory")
			if temp_tree = Void then
				print("Project must have a directory field%N")
				die_with_code(exit_failure_code)
			end
			directory ?= temp_tree @ 0
			if directory.empty then
				directory := clone(dirname)
			end
			if directory.empty then
				directory := "."
			end
			temp_tree := project.find_child("source_directory")
			if temp_tree = Void then
				print("Project must have a source directory field%N")
				die_with_code(exit_failure_code)
			end
			src_directory ?= temp_tree @ 0
			if src_directory.empty then
				src_directory := directory
			else
				src_directory.precede('/')
				src_directory.prepend(directory)
			end
			print("Project name : " + project_name + "%N")
			print("Program name : " + program_name + "%N")
			print("Directory : " + directory +"%N")
			print("Source directory : " + src_directory + "%N")
			file_tools.mkdir(directory)
			file_tools.mkdir(src_directory)
			src_directory.extend('/')
			!!root_class.make(interface, project, src_directory)
			!!top_level_class.make(interface, root_class.root_features,
										  src_directory)
			!!custom_class.make(src_directory)
			root_class.write_gtk_classes
			root_class.write_class
			top_level_class.write_class
			custom_class.write_class
			write_loadpath
		end
	
	write_loadpath is
			-- Write loadpath.se which includes paths to eGTK
		local
			loadpath_file: STD_FILE_WRITE
			loadpath_file_name: STRING
		do
			loadpath_file_name := clone(src_directory)
			loadpath_file_name.append("loadpath.se")
			if file_exists(loadpath_file_name) then
				print("loadpath.se exists%N")
			else
				!!loadpath_file.connect_to(loadpath_file_name)
				loadpath_file.put_string("${EGTK}/lib/gtk/%N")
				loadpath_file.put_string("${EGTK}/lib/gtk/externals/%N")
				loadpath_file.put_string("${EGTK}/lib/gtk/se/%N")
				loadpath_file.put_string("${EGTK}/lib/gdk/%N")
				loadpath_file.put_string("${EGTK}/lib/gdk/se/%N")
				loadpath_file.put_string("${EGTK}/lib/egtk/%N")
				loadpath_file.disconnect
				print("Wrote loadpath.se%N")
			end
		end
end
