-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writers should inherit from this if they can contain >1 widget"
	author: "Daniel Elphick <de397@ecs.soton.ac.uk>"

deferred class GTK_COMPOSED_BIN_WRITER

inherit
	GTK_ATTRIBUTE_WRITER
		redefine
			append_parent_declaration, append_parent_creation, parent_inherit
		end

	CONTAINER
		rename
			last_class_array as widgets
		end

feature

	append_parent_declaration(code: ARRAY[STRING]) is
		local
			i: INTEGER
		do
			precursor(code)
			from
				i := widgets.lower
			until
				i > widgets.upper
			loop
				(widgets @ i).append_parent_declaration(code)
				i := i + 1
			end
		end

	append_parent_creation(code: ARRAY[STRING]) is
			-- most will probably redefine this
		local
			i: INTEGER
		do
			from
				i := widgets.lower
			until 
				i > widgets.upper
			loop
				(widgets @ i).append_parent_creation(code)
				append_add_widget_code(code, widgets @ i)
				i := i + 1
			end
		end

	parent_inherit: INHERIT_LIST is
		local
			i: INTEGER
		do
			if widgets.count > 0 then
				Result := widgets.first.parent_inherit
				from
					i := widgets.lower + 1
				until
					i > widgets.upper
				loop
					Result.merge_with((widgets @ i).parent_inherit)
					i := i + 1
				end
			else
				!!Result.make
			end
		ensure
			non_void_result: Result /= Void
		end

feature {NONE}

	append_add_widget_code(code: ARRAY[STRING]; widget: CAN_BE_CREATED) is
		do
			code.add_last(name + ".add_widget("+widget.name+")")
		end

end
