-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writes source files for Gtk?ButtonBox objects"
	author: "Daniel Elphick <de397@ecs.soton.ac.uk>"

deferred class GTK_BUTTON_BOX_WRITER

inherit

	GTK_COMPOSED_BIN_WRITER
		rename
			make as make_attribute
		redefine
			append_parent_creation, parent_inherit
		end

	CHILD

feature

	type:STRING is "GTK_BUTTON_BOX"
	
	make(attr_name: STRING; tree: TAG_TREE; src: STRING) is
		do
			make_attribute(attr_name, tree, src)
			layout_style := widget_tree.get_string_from_field("layout_style")
			spacing := widget_tree.get_string_from_field("spacing")
			child_min_width := widget_tree.get_string_from_field("child_min_width")
			child_min_height := widget_tree.get_string_from_field("child_min_height")
			child_ipad_x := widget_tree.get_string_from_field("child_ipad_x")
			child_ipad_y := widget_tree.get_string_from_field("child_ipad_y")
			create_child_class_array(widget_tree.find_children("widget"))
		end
			
	layout_style: STRING
	spacing: STRING
	child_min_width: STRING
	child_min_height: STRING
	child_ipad_x: STRING
	child_ipad_y: STRING

	parent_inherit: INHERIT_LIST is
		local
			temp: KLASS
		do
			Result := precursor
			!!temp.make_with_name("GTK_BUTTON_BOX_EXTERNALS")
			temp.add_undefine_clause("is_equal, copy")
			Result.add(temp)
		end

	append_parent_creation(code: ARRAY[STRING]) is
		local
			i: INTEGER
			temp_child: CHILD
		do
			code.add_last("!!" + name + "." + creation_feature)
			code.add_last(name + ".set_spacing(" + spacing + ")")
			code.add_last(name + ".set_layout(" + name + "." + layout_style + ")")
			code.add_last(name + ".set_child_size(" + child_min_width + ", " +
						child_min_height + ")")
			code.add_last(name + ".set_child_ipadding(" + child_ipad_x + ", " +
						child_ipad_y + ")")
			add_widget_code(code)
			precursor(code)
		end

	creation_feature: STRING is
		deferred
		end

end
