-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writes source files for GtkLabel objects"
	author: "Daniel Elphick <de397@ecs.soton.ac.uk>"

class GTK_LABEL_WRITER

inherit

	GTK_ATTRIBUTE_WRITER
		rename
			make as make_attribute
		redefine
			append_parent_creation
		end
	
	CHILD

creation

	make

feature

		
	type: STRING is
		once
			Result := "GTK_LABEL"
		end

	make(attr_name: STRING; tree: TAG_TREE; src: STRING) is
		do
			make_attribute(attr_name, tree, src)
			label := widget_tree.get_string_from_field("label")
			justify := widget_tree.get_string_from_field("justify")
			wrap := widget_tree.get_boolean_string_from_field("wrap")
			if wrap = "" then
				wrap := "False"
			end
			xalign := widget_tree.get_real_string_from_field("xalign")
			yalign := widget_tree.get_real_string_from_field("yalign")
			xpad := widget_tree.get_integer_string_from_field("xpad")
			ypad := widget_tree.get_integer_string_from_field("ypad")
		end
			
	label: STRING
	justify: STRING
	wrap: STRING
	xalign: STRING
	yalign: STRING
	xpad: STRING
	ypad: STRING
	
	append_parent_creation(code: ARRAY[STRING]) is
		do
			code.add_last("!!" + name + ".make(%""+label+"%")")
			if justify.is_equal("GTK_JUSTIFY_CENTER") then
				code.add_last(name + ".centre")
			elseif justify.is_equal("GTK_JUSTIFY_LEFT") then
				code.add_last(name + ".left_justify")
			elseif justify.is_equal("GTK_JUSTIFY_RIGHT") then
				code.add_last(name + ".right_justify")
			elseif justify.is_equal("GTK_JUSTIFY_FILL") then
				code.add_last(name +".fill")
			else
				print("Warning: justify in "+name+" is not valid%N")
				code.add_last("-- justify flag not recognized")
			end
			code.add_last(name + ".set_alignment("+xalign+", "+yalign+")")
			code.add_last(name + ".set_padding("+xpad+", "+ypad+")")
			code.add_last(name + ".set_line_wrap("+wrap+")")
			add_widget_code(code)
		end

end
