-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writes source files for GtkWindow objects"
	author: "Daniel Elphick <de397@ecs.soton.ac.uk>"

class GTK_WINDOW_WRITER

inherit

	GTK_CLASS_WRITER
		rename 
			make as make_class
		end

	SIGNAL_COMMON

creation

	make

feature

	name: STRING
	
	child_widget: CAN_BE_CREATED

	inherit_from: STRING is "GTK_WINDOW"

	make(tree: TAG_TREE; info: CLASS_INFO; src: STRING) is
		local
			signal_trees: ARRAY[TAG_TREE]
		do
			make_class(tree, info, src)
			create_child_class(widget_tree.find_child("widget"))
			child_widget := last_class
			if child_widget /= Void then
				inherit_list.merge_with(last_class.parent_inherit)
			end
			border_width := widget_tree.get_integer_string_from_field("border_width")
			title := widget_tree.get_string_from_field("title")
			allow_shrink := widget_tree.get_boolean_string_from_field("allow_shrink")
			if allow_shrink = "" then
				allow_shrink := "True"
			end
			allow_grow := widget_tree.get_boolean_string_from_field("allow_grow")
			if allow_grow = "" then
				allow_grow := "True"
			end
			auto_shrink := widget_tree.get_boolean_string_from_field("auto_shrink")
			if auto_shrink = "" then
				auto_shrink := "True"
			end

			visible := tree.get_boolean_from_field("visible", True)
			wm_name := widget_tree.get_string_from_field("wmclass_name")
			wm_class := widget_tree.get_string_from_field("wmclass_class")
			-- TODO: write the wmclass and wmname out

			name := clone(classname)
			name.to_lower
			name.prepend("instance_")
			events := tree.get_string_from_field("events")
			extension_events := tree.get_string_from_field("extension_events")
			-- TODO: write the events out
			make_signals(tree.find_children("signal"))
		end
			
	title: STRING
	border_width: STRING
	allow_shrink:STRING
	allow_grow:STRING
	auto_shrink:STRING
	visible: BOOLEAN
	events: STRING
	extension_events: STRING
	wm_name: STRING
	wm_class: STRING
	
	append_parent_declaration(code: ARRAY[STRING]) is
		do
			code.add_last(name+": "+classname)
		end

	append_parent_creation(code: ARRAY[STRING]) is
		do
			code.add_last("!!" + name + ".make")
			append_top_level_show(code)
		end

	append_top_level_definition(code: ARRAY[STRING]) is
		do
			code.add_last(name + ": " + classname + " is")
			code.add_last("%Tonce")
			code.add_last("%T%T!!Result.make")
			code.add_last("%Tend%N")
		end

	append_top_level_show(code: ARRAY[STRING]) is
		do
			if visible then
				code.add_last(name + ".show")
			end
		end

	write_features is
		local
			code: ARRAY[STRING]
		do
			if child_widget /= Void then
				!!code.make(0,-1)
				child_widget.append_parent_declaration(code)
				write_lines(code)
			end
		end

	write_make_body is
		local
			code: ARRAY[STRING]
		do
			!!code.make(0,-1)
			append_signal_declarations(code)
			write_lines(code)
			write_line("make is")
			indent
			write_line("local")
			write_line("do")
			indent
			write_line("make_top_level")
			write_line("set_title(%""+title+"%")")
			write_line("set_policy("+allow_shrink+", "+allow_grow+", "+auto_shrink+")")
			if border_width /= Void then
				write_line("set_border_width("+border_width+")")
			end
			code.clear
			append_signal_code(code, "Current")
			write_lines(code)
			if child_widget /= Void then
				code.clear
				child_widget.append_parent_creation(code)
				write_lines(code)
				write_line("add_widget("+child_widget.name+")")
			end
			outdent
			write_line("end")
			outdent
		end
end
