%{

class GTK_CLASS_SCANNER

inherit

	GTK_CLASS_TOKENS

	YY_COMPRESSED_SCANNER_SKELETON

creation

	make_with_file

%}

WS      [ \r\f\v\t\n]
INDIR   \*+
ID      [_a-zA-Z][_a-zA-Z0-9]*
STRING  (\"([^\n"\\]|\\[ntvbrfa\\?'"])*\"{WS}*)+

%x CLASSDEF_STATE
%x BRACE_STATE
%x SC_FILE

%%

^#.*                                                  { set_start_condition (SC_FILE)
                                                        less (0)                                    }
<SC_FILE>#{WS}+[0-9]+{WS}+\"                          -- chew leading junk
<SC_FILE>\"{WS}.*\n                                   { set_start_condition (INITIAL)               }
<SC_FILE>[^"\n]+                                      { last_token := TOK_FILE_NAME; 
                                                        last_value := text                          }

<*>{STRING}                                           -- chew character constants
struct{WS}+_[a-zA-Z0-9]+Class{WS}*"{"                 { set_start_condition (CLASSDEF_STATE); less (0)    }
<CLASSDEF_STATE>[a-zA-Z][a-zA-Z0-9]+/Class            { last_token := TOK_CLASS_NAME; last_value := text    }
<CLASSDEF_STATE>"{"	                              { set_start_condition (BRACE_STATE); brace_depth := 1 }
<BRACE_STATE>[a-zA-Z][a-zA-Z0-9]+/Class\ parent_class {last_token := TOK_PARENT_CLASS_NAME; last_value := text }
<BRACE_STATE>"{"                                      { brace_depth := brace_depth + 1 }
<BRACE_STATE>"}"                                      { brace_depth := brace_depth - 1; if brace_depth = 0 then set_start_condition (INITIAL) end }
<BRACE_STATE>[^{}a-zA-Z]*                             -- chew leftovers
<BRACE_STATE>[a-zA-Z]                                 -- chew leftovers

<CLASSDEF_STATE>.|\n                                  -- chew leftovers

[^s#"]*                                               -- chew leftovers
.#                                                    -- chew # not at start of line
s|\"                                                  -- chew leftovers

%%

        brace_depth: INTEGER

        last_value: STRING

end
--!-----------------------------------------------------------------------------
--! The GOTE converter. It converts GTK+ Objects To Eiffel.
--! Copyright (C) 1999 Sam O'Connor
--!
--! This program is free software; you can redistribute it and/or modify
--! it under the terms of the GNU General Public License as published by
--! the Free Software Foundation; either version 2 of the License, or
--! (at your option) any later version.
--!
--! This program is distributed in the hope that it will be useful,
--! but WITHOUT ANY WARRANTY; without even the implied warranty of
--! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--! GNU General Public License for more details.
--!
--! You should have received a copy of the GNU General Public License
--! along with this program; if not, write to the Free Software
--! Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
--!
--! See file "licence" for more information.
--!-----------------------------------------------------------------------------
