-- Copyright (C) 1999 Richie Bielak and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "GTK_BIN - widget that contains one child widget"
	version: "v 0.3.3 GTK+ 1.2.x"
	author: "Richie Bielak"
	date: "4/9/99"
	cvs: "$Id: gtk_bin.e,v 1.7 1999/11/23 03:45:08 richieb Exp $"

class GTK_BIN

-- A widget that contains a single child widget

inherit

	GTK_CONTAINER
		redefine
			make_from_pointer
		end

	GTK_BIN_EXTERNALS
		undefine
			is_equal, copy
		end

	EGTK_SHARED_WIDGET_FACTORY
		undefine
			is_equal, copy
		end

feature

	add_widget (a_child: like child) is
			-- add a child widget to this widget;
			-- (only one widget can be added, later additions
			-- have no effect unless the first one is removed)
		do
			gtk_container_add (widget, a_child.widget)
			add_child (a_child)
		end

	remove_widget (a_child: GTK_WIDGET) is
			-- remove the child widget from this one
		do
			gtk_container_remove (widget, a_child.widget)
			if child = a_child then
				child := Void
			end
		end

	child: GTK_WIDGET
			-- child widget


	make_from_pointer (p: POINTER) is
		do
			precursor (p)
			-- retrieve child widget
			child ?= widget_factory.item_from_pointer (c_gtk_bin_child (p))
		end

feature {GTK_WIDGET}

	add_child (a_child: like child) is
		do
			child := a_child
			child.set_parent (Current)
		end

	child_by_pointer (p: POINTER): GTK_WIDGET is
		do
			if p = child.widget then
				Result := child
			end
		end

end -- GTK_BIN
