/**************************************************************************** 
** File: logging.c
**
** Author: Michael S. Borella
**
** Comments: Routines for log file opening, closing, and writing.  Relies
**           on mytime 'class'
**           TO DO: Make into a 'class' and add priority levels
**
*****************************************************************************/

#include <stdio.h>
#include <stdarg.h>
#include <time.h>
#include "mytime.h"
#include "logging.h"
#include "error.h"

int logfile_active = 0;
FILE *log;

/*----------------------------------------------------------------------------
**
** Function: logfile_open()
**
** Comments: Opens the log file
**
**--------------------------------------------------------------------------*/

void logfile_open(char *fname)
{

  if (logfile_active)
    ftlerr("trying to open log file %s for the second time", fname);

  log = fopen(fname, "w");
  if (log == NULL)
    syserr("can't open log file %s", fname);
  logfile_active = 1;
}

/*----------------------------------------------------------------------------
**
** Function: logfile_close()
**
** Comments: Closes the log file
**
**--------------------------------------------------------------------------*/

void logfile_close(void)
{
  int ret;

  if (!logfile_active)
    return;

  ret = fclose(log);
  if (ret)
    syserr("can't close log file");
  logfile_active = 0;
}

/*----------------------------------------------------------------------------
**
** Function: logfile_write()
**
** Comments: Writes a formatted string to the log file
**
**--------------------------------------------------------------------------*/

void logfile_write(char *fmt, ...)
{
  va_list       args;

  if (!logfile_active) 
    return;

  /*
   * Get the time
   */

  mytime_gettime();
  
  /*
   * Display the message with timestamp
   */

  va_start(args,fmt);
  fprintf(log,"%s.%3d: ", mytime_time(), mytime_usec());
  vfprintf(log, fmt, args);
  fprintf(log, "\n");  
  va_end(args);

  /*
   * Flush the output stream.  Maybe this should be optional?
   */

  fflush(log);
}
