/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	RBD/GDB
 *
 *	$Id: app_mgmt.c,v 6.6 1999/09/12 05:06:22 jsquyres Exp $
 *
 *	Function:	- application execution and management
 */

#include <app_mgmt.h>
#include <lam_ksignal.h>
#include <net.h>
#include <preq.h>
#include <typical.h>

/*
 * public functions
 */
int			app_doom();
int			app_sendprocs();

/*
 *	app_sendprocs
 *
 *	Function:	- send GPS array to all processes in the array
 *	Accepts:	- number of processes in GPS array
 *			- GPS array
 *	Returns:	- 0 or LAMERROR
 */
int
app_sendprocs(nprocs, pgps)

int			nprocs;
struct _gps		*pgps;

{
	struct nmsg	nhead;			/* network msg header */
	struct _gps	*p;			/* ptr GPS entry */
	int		i;			/* favourite index */
/*
 * Set up the message.
 */
	nhead.nh_type = 0;
	nhead.nh_flags = DINT4MSG;
	nhead.nh_msg = (char *) pgps;
	nhead.nh_length = nprocs * sizeof(struct _gps);
/*
 * Loop sending to each process.
 */
	for (i = 0, p = pgps; i < nprocs; i++, p++) {
		nhead.nh_node = p->gps_node;
		nhead.nh_event = (-p->gps_pid) & 0xBFFFFFFF;

		if (nsend(&nhead)) return(LAMERROR);
	}
	
	return(0);
}

/*
 *	app_doom
 *
 *	Function:	- kill running application processes
 *	Accepts:	- GPS array length
 *			- application GPS array
 *	Returns:	- 0 or ERROR
 */
int
app_doom(int app_n, struct _gps *app, int sig)
{
	int		i;

	for (i = 0; i < app_n; i++) {
	    	if (app[i].gps_pid == 0) {
			break;
	    	}

		rpdoom(app[i].gps_node, SELECT_PID, app[i].gps_pid, sig);
	}

	return(0);
}
