/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	GDB
 *
 *	$Id: mpil_signal.c,v 6.2 1999/05/25 22:08:08 kmeyer1 Exp $
 *
 *	Function:	- delivers a signal to a process
 *	Accepts:	- communicator
 *			- process rank
 *			- signal number
 */

#include <blktype.h>
#include <lam_ksignal.h>
#include <mpi.h>
#include <mpisys.h>
#include <portable.h>
#include <preq.h>
#include <terror.h>

int
MPIL_Signal(comm, rank, signo)

MPI_Comm		comm;
int			rank;
int			signo;

{
	int		err;		/* MPI error code */
	int		nid;		/* process's node ID */
	int		pid;		/* process ID */

	lam_initerr();
	lam_setfunc(BLKMPILSIGNAL);

	if (comm == MPI_COMM_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			lam_getfunc(), lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if ((rank == MPI_ANY_SOURCE) || (rank < 0)
		|| (LAM_IS_INTRA(comm) && rank >= comm->c_group->g_nprocs)
		|| (LAM_IS_INTER(comm) && rank >= comm->c_rgroup->g_nprocs)) {
		
		return(lam_errfunc(comm, lam_getfunc(), 
					lam_mkerr(MPI_ERR_RANK, 0)));
	}

	err = MPIL_Comm_gps(comm, rank, &nid, &pid);

	if (err != MPI_SUCCESS) {
		return(lam_errfunc(comm, BLKMPILSIGNAL, err));
	}

	if (rpdoom((int4) nid, (int4) SELECT_PID, (int4) pid, (int4) signo)) {
		return(lam_errfunc(comm, lam_getfunc(),
					lam_mkerr(MPI_ERR_OTHER, errno)));
	}

	lam_resetfunc(BLKMPILSIGNAL);
	return(MPI_SUCCESS);
}
