package com.jclark.xsl.sax;

import org.xml.sax.*;
import com.jclark.xsl.om.*;

class SingleNamespaceResult extends ResultBase {
  SingleNamespaceResult(DocumentHandler handler) {
    super(handler);
  }

  protected void startElementContent(Name elementType,
				     NamespacePrefixMap nsMap)
    throws XSLException {
    try {
      getDocumentHandler().startElement(elementType.getLocalPart(),
					this);
    }
    catch (SAXException e) {
      throwXSLException(e);
    }
  }

  protected void endElementContent(Name elementType) throws XSLException {
    try {
      getDocumentHandler().endElement(elementType.getLocalPart());
    }
    catch (SAXException e) {
      throwXSLException(e);
    }
  }

  public String getName(int i) {
    return getAttributeName(i).getLocalPart();
  }

  public void resultTreeFragment(ResultTreeFragment frag) throws XSLException {
    try {
      frag.emit(getDocumentHandler(), true);
    }
    catch (SAXException e) {
      throwXSLException(e);
    }
  }
}
