package com.jclark.xsl.sax;

import org.xml.sax.*;
import com.jclark.xsl.tr.*;
import com.jclark.xsl.om.*;
import java.util.Locale;
import java.io.IOException;
import java.net.URL;

public class XSLProcessorImpl implements XSLProcessor {
  private XMLProcessorImpl sourceLoader;
  private XMLProcessorImpl sheetLoader;
  private Parser sheetParser;
  private Parser sourceParser;
  private Sheet sheet;
  private Engine engine;
  private InputSource sheetSource;
  private Result result;
  private ResultTypeHandler resultTypeHandler;
  private DocumentHandler documentHandler;
  private boolean stripNamespaces = false;

  public XSLProcessorImpl(Parser sourceParser, Parser sheetParser) {
    this.sourceParser = sourceParser;
    this.sheetParser = sheetParser;
    sourceLoader = new XMLProcessorImpl(sourceParser);
    if (sourceParser == sheetParser)
      sheetLoader = sourceLoader;
    else
      sheetLoader = new XMLProcessorImpl(sheetParser);
    engine = new EngineImpl(sheetLoader,
			    new ExtensionHandlerImpl());
    sheet = null;
  }

  public XSLProcessorImpl(Parser parser) {
    this(parser, parser);
  }

  public void setStripNamespaces(boolean strip) {
    stripNamespaces = strip;
  }

  public void setLocale(Locale locale) throws SAXException {
    sheetParser.setLocale(locale);
    sourceParser.setLocale(locale);
  }

  public void setDTDHandler(DTDHandler handler) { }

  public void setEntityResolver(EntityResolver resolver) {
    sheetParser.setEntityResolver(resolver);
    sourceParser.setEntityResolver(resolver);
  }

  public void setStylesheet(InputSource sheetSource) {
    this.sheetSource = sheetSource;
    sheet = null;
  }

  public void setResultTypeHandler(ResultTypeHandler handler) {
    this.resultTypeHandler = handler;
  }

  public void setDocumentHandler(DocumentHandler handler) {
    documentHandler = handler;
  }

  public void parse(String systemId) throws SAXException, IOException {
    parse(new InputSource(systemId));
  }

  public void setErrorHandler(ErrorHandler handler) {
    sheetParser.setErrorHandler(handler);
    sourceParser.setErrorHandler(handler);
  }

  public void parse(InputSource source) throws SAXException, IOException {
    try {
      if (sheet == null) {
	phase(1);
	Node node = sheetLoader.load(sheetSource,
				     engine.getSheetLoadContext(),
				     engine.getNameTable());
	phase(2);
	sheet = engine.createSheet(node);
      }
      else {
	phase(1);
	phase(2);
      }
      if (resultTypeHandler != null)
	resultTypeHandler.setResultType(sheet.getResultNamespace(),
					sheet.getIndentResult());
      if (documentHandler == null)
	documentHandler = new HandlerBase();
      if (stripNamespaces)
	result = new SingleNamespaceResult(documentHandler);
      else
	result = new MultiNamespaceResult(documentHandler);
      phase(3);
      Node root = sourceLoader.load(source,
				    sheet.getSourceLoadContext(),
				    engine.getNameTable());
      phase(4);
      sheet.process(root, result);
      phase(5);
    }
    catch (XSLException e) {
      String systemId = null;
      int lineNumber = -1;
      Node node = e.getNode();
      if (node != null) {
	URL url = node.getURL();
	if (url != null)
	  systemId = url.toString();
	lineNumber = node.getLineNumber();
      }
      Exception wrapped = e.getException();
      String message = e.getMessage();
      if (systemId != null || lineNumber != -1)
	throw new SAXParseException(message,
				    null,
				    systemId,
				    lineNumber,
				    -1,
				    wrapped);
      if (message == null) {
	if (wrapped instanceof SAXException)
	  throw (SAXException)wrapped;
	if (wrapped instanceof IOException)
	  throw (IOException)wrapped;
      }
      throw new SAXException(message, wrapped);
    }
  }

  void phase(int n) { }
}
