/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.Vector;

public class RecordHandler {
    Vector stateDefs = new Vector();
    Vector data = new Vector();
    Vector mtns = new Vector();
    CLOG_ARROW a;
    MtnInfo m;
    private int evtct = 0;

    public RecordHandler() {
        this.setupArrows();
    }

    private void setupArrows() {
        this.a = new CLOG_ARROW();
        this.a.startetype = -101;
        this.a.endetype = -102;
    }

    void setDataSize(int n) {
        if (n % 2 > 0) {
            System.err.println("Error Reading logfile. Incorrect number of rawevents");
            ++n;
        }
        this.data.ensureCapacity(n / 2);
    }

    void HandleRaw(RECORD rECORD) {
        CLOG_HEADER cLOG_HEADER = rECORD.header;
        CLOG_RAW cLOG_RAW = (CLOG_RAW)rECORD.data;
        int n = cLOG_RAW.etype;
        if (n == this.a.startetype) {
            this.a.startArrowEvent(cLOG_HEADER, cLOG_RAW);
            return;
        }
        if (n == this.a.endetype) {
            this.a.endArrowEvent(cLOG_HEADER, cLOG_RAW);
            return;
        }
        CLOG_STATE cLOG_STATE = this.resolve(n);
        if (cLOG_STATE == null) {
            return;
        }
        if (this.evtct++ == 0) {
            this.m = new MtnInfo(this.stateDefs.size());
            this.m.begT = cLOG_HEADER.timestamp;
        } else {
            this.m.endT = cLOG_HEADER.timestamp;
            int n2 = 0;
            while (n2 < this.stateDefs.size()) {
                CLOG_STATE cLOG_STATE2 = (CLOG_STATE)this.stateDefs.elementAt(n2);
                int n3 = n2++;
                this.m.s[n3] = this.m.s[n3] + cLOG_STATE2.events.size();
            }
            this.mtns.addElement(this.m);
            this.m = new MtnInfo(this.stateDefs.size());
            this.m.begT = cLOG_HEADER.timestamp;
        }
        if (cLOG_STATE.startetype == n) {
            cLOG_STATE.startEvent(cLOG_HEADER);
            return;
        }
        this.data.addElement(cLOG_STATE.endEvent(cLOG_HEADER));
    }

    void HandleStateDef(CLOG_STATE cLOG_STATE) {
        this.stateDefs.addElement(cLOG_STATE);
    }

    private CLOG_STATE resolve(int n) {
        Enumeration enumeration = this.stateDefs.elements();
        while (enumeration.hasMoreElements()) {
            CLOG_STATE cLOG_STATE = (CLOG_STATE)enumeration.nextElement();
            if (n != cLOG_STATE.startetype && n != cLOG_STATE.endetype) continue;
            return cLOG_STATE;
        }
        System.out.println("Error: Unrecognized etype in RAW record");
        return null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }
}

